<?php

namespace App\Http\Controllers\backend;

use App\Config;
use App\Country;
use App\Currency;
use App\Http\Controllers\Controller;
use App\Http\Controllers\Mail\RejectedEmail;
use App\Http\Controllers\Mail\VerifyEmail;
use App\Language;
use App\Level;
use App\Patner;
use App\Profile;
use App\Role;
use App\Rules\ValidatePassword;
use App\Setting;
use App\Theme;
use App\User;
use App\UserData;
use App\Whitelist;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;

class UserController extends Controller
{

    private $setting;
    //Execute if user is authenticated
    public function __construct()
    {

        $this->middleware(['auth', '2fa', 'verify.ip']);

        $this->setting = Setting::first();
    }

    private function get_client_ip_server()
    {
        $ipaddress = '';

        if ($_SERVER['REMOTE_ADDR']) {

            $ipaddress = $_SERVER['REMOTE_ADDR'];

        } else {

            $ipaddress = 'UNKNOWN';

        }
        return $ipaddress;
    }

    private function RandomString()
    {
        $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $randstring = '';
        $chlength = strlen($characters);

        for ($i = 0; $i < 10; $i++) {
            $randstring .= $characters[rand(0, $chlength - 1)];
        }

        return $randstring;
    }

    //List Users
    public function index(Request $request)
    {

        //Select Authenticated User
        $user = Auth::User();

        //Assign Variables
        $searchValue = $request->searchvalue;
        $page = $request->page;
        $resultPage = $request->resultPage;
        $orderBy = $request->orderBy;
        $orderDirection = $request->orderDirection;
        $total = 0;

        //Select Users
        $query = User::WhereNotIn('id', [$user->id])->with(['data', 'profile.city.region.country', 'orders.outCurrencyOrder', 'orders.inCurrencyOrder', 'balances.currency', 'roles']);

        //Search by
        if ($searchValue != '') {

            $query->Where(function ($query) use ($searchValue) {
                $query->Where('email', 'like', '%' . $searchValue . '%')
                    ->orWhere('created_at', 'like', '%' . $searchValue . '%')
                    ->orWhere('updated_at', 'like', '%' . $searchValue . '%');
            });
        }

        //Order By
        if ($orderBy != '') {

            if ($orderDirection != '') {

                $query->orderBy($orderBy, 'desc');

            } else {

                $query->orderBy($orderBy);

            }
        } else if ($orderDirection != '') {

            $query->orderBy('created_at');

        } else {

            $query->orderBy('created_at', 'desc');

        }

        if ($resultPage == null || $resultPage == 0) {

            $resultPage = 10;

        }

        $users = $query->paginate($resultPage);

        //Return Response in JSON Datatype
        return response()->json(['result' => $users], 202);
    }

    public function kycUsers(Request $request)
    {

        //Select Authenticated User
        $user = Auth::User();

        //Assign Variables
        $searchValue = $request->searchvalue;
        $page = $request->page;
        $resultPage = $request->resultPage;
        $orderBy = $request->orderBy;
        $orderDirection = $request->orderDirection;
        $total = 0;

        //Select Users
        $query = User::WhereNotIn('users.id', [$user->id])->with(['organization', 'profile', 'document', 'profile.country', 'profile.region', 'profile.city', 'organization.country', 'organization.region', 'organization.city', 'organization.patners'])->select();

        //Search by
        if ($searchValue != '') {

            $query->Where(function ($query) use ($searchValue) {
                $query->Where('users.email', 'like', '%' . $searchValue . '%')
                    ->orWhere('users.created_at', 'like', '%' . $searchValue . '%')
                    ->orWhere('users.updated_at', 'like', '%' . $searchValue . '%');
            });
        }

        //Order By
        if ($orderBy != '') {

            if ($orderDirection != '') {

                $query->orderBy($orderBy, 'desc');

            } else {

                $query->orderBy($orderBy);

            }
        } else if ($orderDirection != '') {

            $query->orderBy('users.created_at');

        } else {

            $query->orderBy('users.created_at', 'desc');

        }

        if ($resultPage == null || $resultPage == 0) {

            $resultPage = 10;

        }

        //Get Total
        $total = $query->get()->count();

        if ($page > 1) {

            $query->offset(($page - 1) * $resultPage);

        }

        $query->limit($resultPage);

        //Get Users
        $users = $query->get();

        foreach ($users as $user) {

            if ($user->profile->born_site) {
                $born = Country::find($user->profile->born_site);
                $user->profile->born_site = $born->name;
            }
            if ($user->profile->issuing_state) {
                $emition = Country::find($user->profile->issuing_state);
                $user->profile->issuing_state = $emition->name;
            }

            switch ($user->profile->user_type) {
                case 1:
                    $user->profile->user_type = 'Natural';
                    break;
                case 2:
                    $user->profile->user_type = 'Juridico';
                    break;
                default:
                    $user->profile->user_type = 'Ninguno';
                    break;
            }

            switch ($user->profile->marital_status) {
                case 1:
                    $user->profile->marital_status = 'Soltero';
                    break;
                case 2:
                    $user->profile->marital_status = 'Casado';
                    break;
                case 3:
                    $user->profile->marital_status = 'Divorciado';
                    break;
                case 4:
                    $user->profile->marital_status = 'Viudo';
                    break;
                default:
                    $user->profile->marital_status = 'Ninguno';
                    break;
            }

            switch ($user->profile->type_id) {
                case 1:
                    $user->profile->type_id = 'Cedula';
                    break;
                case 2:
                    $user->profile->type_id = 'Pasaporte';
                    break;
                case 3:
                    $user->profile->type_id = 'Licencia de conducir';
                    break;
                default:
                    $user->profile->type_id = 'Ninguno';
                    break;
            }

            switch ($user->profile->politically_exposed_person) {
                case 0:
                    $user->profile->politically_exposed_person = 'No';
                    break;
                case 1:
                    $user->profile->politically_exposed_person = 'Si';
                    break;
            }

            if ($user->profile->city) {
                $address = $user->profile->city->name . ', ' . $user->profile->region->name . ', ' . $user->profile->country->name;

                $user->profile->address = $address . ', ' . $user->profile->street . ', ' . $user->profile->house . ', Codigo Postal: ' . $user->profile->postal_code;

            }

        }

        //Return Response in JSON Datatype
        return response()->json(['page' => $page, 'result' => $users, 'total' => $total], 202);
    }

    //Get Roles for users
    public function userRoles()
    {

        //Select Roles
        $roles = Role::All();

        //Return Response in JSON dataType
        return response()->json(['data' => $roles], 202);
    }

    //Get User For Clients
    public function userClients(Request $request)
    {

        //Assign Variables
        $rolid = $request->role;

        //Find Role
        $role = Role::find($rolid);

        //Get users with trader role
        $user = $role->users()->get();

        //Return Response In JSON DataType
        return response()->json(['data' => $user], 202);
    }

    //Create User
    public function store(Request $request)
    {
        $request->validate([
            'fname' => 'required|string|max:255',
            'sname' => 'string|max:255',
            'flastname' => 'required|string|max:255',
            'slastname' => 'required|string|max:255',
            'email' => 'required|string|email|max:255|unique:users',
            'password' => 'required|string|min:6',
        ]);

        $string = $this->RandomString();
        $hash = Hash::make($string);
        $ip = $this->get_client_ip_server();
        $time = Carbon::now();

        $theme = Theme::Selected();
        $language = Language::Selected();
        $roles = $request->roles;

        $user = new User;
        $user->email = $request->email;
        $user->password = Hash::make($request->password);
        $user->save();

        $profile = new Profile;
        $profile->fname = $request->fname;
        if (!($request->sname == '')) {
            $profile->sname = $request->sname;
        }
        $profile->flastname = $request->flastname;
        $profile->slastname = $request->slastname;
        $profile->user()->associate($user);
        $profile->save();
        
        $data = new UserData;
        $data->user()->associate($user);
        $data->save();
        /*
        $document = new Document;
        $document->user()->associate($user);
        $document->save();*/

        $option = new Config;
        $option->user()->associate($user);
        $option->theme()->associate($theme);
        $option->language()->associate($language);
        $option->withdraw_max_limit = 0;
        $option->daily_withdraw = 0;
        $option->save();

        $string = $this->RandomString();

        do {
            $hash = Hash::make($string);
            $verifyHash = strpos($hash, '/');
        } while ($verifyHash == true);

        $ip = $this->get_client_ip_server();
        $time = Carbon::now();

        $user->verification_token = $hash;
        $user->verification_expire = $time;
        //Loop $roles
        foreach ($roles as $role) {

            //Attach roles to user
            $user->roles()->attach($role);

        }
        do {
            $id_token = $this->RandomString(23);
            $consult = User::Where('id_token', $id_token)->exists();
            if ($consult) {
                $exists = true;
            } else {
                $user->id_token = $id_token;
                $exists = false;
            }

        } while ($exists == true);
        //Verify if user is client
        if (isset($request->client)) {

            //Assign Variable
            $client = $request->client;

            //Attach client to user
            $user->clients()->attach($client);
        }

        $user->save();

        $link = url('/email/' . $user->email . '/' . $hash);

        $data = ['ip' => $ip, 'link' => $link, 'time' => $time];

        Mail::to($user->email)->send(new VerifyEmail($data));

        //Return Response in JSON DataType
        return response()->json(['message' => "success"], 202);
    }

    //Show User Profile
    public function show(Request $request)
    {
        //Select Authenticated User
        $user_id = Auth::User()->id;

        //Select user with Role
        $user = User::Where('users.id', $user_id)->leftJoin('profiles', 'profiles.user_id', '=', 'users.id')
            ->leftJoin('user_datas', 'user_datas.user_id', '=', 'users.id')
            ->leftJoin('countries', 'countries.id', '=', 'profiles.country_id')
            ->leftJoin('regions', 'regions.id', '=', 'profiles.region_id')
            ->leftJoin('cities', 'cities.id', '=', 'profiles.city_id')
            ->select('users.id', 'users.email', 'profiles.fname', 'profiles.sname', 'profiles.flastname', 'profiles.slastname', 'profiles.street', 'profiles.house', 'profiles.postal_code', 'countries.name as country', 'regions.name as region', 'cities.name as city', 'user_datas.secret_status', 'user_datas.sms_verify', 'user_datas.verify_via_email')->first();

        $user->address = $user->city . ', ' . $user->region . ', ' . $user->country . ', ' . $user->street . ', ' . $user->house . ', Codigo Postal: ' . $user->postal_code;
        //Get last session
        //$session = $user->session()->orderBy('id', 'desc');

        //Return Response in JSON DataType
        return response()->json(['user' => $user], 200);
    }

    //Profile Picture Update
    public function picture(Request $request)
    {

        //Validate $request DataType
        $request->validate([
            'picture' => 'required',
            'id' => 'required',
        ]);

        //Assign Variables
        $id = $request->id;
        $pic = $request->picture;
        $ds = DIRECTORY_SEPARATOR;

        //Find User
        $user = User::find($id);

        //Save Img in database
        $user->profile_image = $pic;
        $user->save();

        //Return Response in JSON DataType
        return response()->json(['message' => "success"], 202);
    }

    //Update User
    public function update(Request $request)
    {
        //Validate $request Data
        $request->validate([
            'fname' => 'required|string|max:255',
            'sname' => 'string|max:255',
            'flastname' => 'required|string|max:255',
            'slastname' => 'required|string|max:255',
            'email' => 'required|string|email|max:255',
            'password' => 'confirmed',
        ]);

        //Assign Variables
        $id = $request->id;
        $fname = $request->fname;
        $sname = $request->sname;
        $flastname = $request->flastname;
        $slastname = $request->slastname;
        $email = strtolower($request->email);
        $roles = $request->roles;

        //Find User
        $user = User::Find($id);

        //Edit User
        $user->profile->fname = $fname;
        $user->profile->sname = $sname;
        $user->profile->flastname = $flastname;
        $user->profile->slastname = $slastname;

        if ($user->email !== $email) {
            $user->email = $email;
        }

        //Verify if Password is empty
        if ($request->password != null) {
            if ($request->password == $request->password_confirmation) {
                $user->password = Hash::make($request->password);
            }
        }

        //Save edit user
        $user->save();

        //Detach old roles
        $user->roles()->detach();

        //Loop Roles
        foreach ($roles as $role) {

            //Attach New Role
            $user->roles()->attach($role);

        }

        //Detach old Client
        //$user->clients()->detach();

        //Verify if has client
        if (isset($request->client)) {

            //Assign Variable
            $client = $request->client;

            //Attach new client
            // $user->clients()->attach($client);
        }

        //Return Response in JSON DataType
        return response()->json(['message' => "success"], 202);
    }

    //Update User Profile
    public function updateProfile(Request $request)
    {

        //Validate $request Data
        $request->validate([
            'id' => 'required',
            'old_password' => 'required',
            'password' => 'confirmed',
        ]);

        //Assign Variables
        $id = $request->id;
        $email = strtolower($request->email);

        //Verify if password is empty

        $Opass = $request->old_password;
        $password = Hash::make($request->password);

        //Find User
        $user = User::Find($id);

        if (!Hash::check($Opass, $user->password)) {
            return response()->json(['message' => "success", 'respond' => 'Vieja Contrasena Invalida'], 202);
        }

        $user->password = $password;

        //Save User
        $user->save();

        //Return Response in JSON DataType
        return response()->json(['message' => "success", 'respond' => 'Contrasena modificada con exito!'], 202);
    }

    //Destroy User
    public function destroy(Request $request)
    {

        //Assign Variables
        $id = $request->id;

        //Find User
        $user = User::find($id);

        $user->balances()->delete();
        $user->config()->delete();
        $user->organization()->delete();
        $user->document()->delete();
        $user->accounts()->delete();
        $user->data()->delete();
        //Detach Roles And Clients
        $user->roles()->detach();
        //$user->clients()->detach();

        //Get User Funds
        //$funds = $user->funds()->get();

        //Verify if exists Funds
        /* if($funds){

        //Loop Funds
        foreach($funds as $fund){

        //Select Fund
        $fd = App\Fund::find($fund->id);

        //Delete Fund
        $fd->delete();

        }
        }*/

        //Delete User
        $user->delete();

        //Return Response in JSON DataType
        return response()->json(['message' => "success"], 202);
    }

    //Change Password
    public function changePassword(Request $request)
    {

        //Validate $request Data
        $request->validate([
            'oldpassword' => ['required', new ValidatePassword(auth()->user())],
            'newpassword' => 'required|confirmed',
            'newpassword_confirmation' => 'required',
        ]);

        //Select Authenticated User
        $auth = Auth::User();

        //Select user
        $user = User::Where('id', $auth->id)->first();

        //Assign Variables
        $newpassword = bcrypt($request->newpassword);

        //Update User
        $user->password = $newpassword;

        //Save User
        $user->save();

        return redirect('/profile');
    }

    //Add Whitelist
    public function addWhitelist(Request $request)
    {

        //Validate $request Data
        $request->validate([
            'currency' => 'required',
            'label' => 'required|max:20',
            'address' => 'required|max:255',
        ]);

        //Select Authenticated User
        $auth = Auth::User();

        //Create Whitelist
        $whitelist = new Whitelist;
        $whitelist->user_id = $auth->id;
        $whitelist->currency_id = $request->currency;
        $whitelist->label = $request->label;
        $whitelist->address = $request->address;
        $whitelist->save();

        return redirect('/profile');
    }

    public function kycConfirm(Request $request)
    {

        $request->validate([
            'id' => 'required',
        ]);

        $id = $request->id;

        $user = User::Find($id);

        if (!$user->profile->level1_confirmed) {

            $user->profile->level1_confirmed = 1;
            $level = Level::whereCode(2)->first();
            $user->config->withdraw_max_limit = $this->setting->withdraw_max_limit * $level->percent;
            $user->level()->associate($level);
            $text = "Nivel 1 Verificado Con Exito";

        } else if (!$user->profile->level2_confirmed && $user->profile->level1_confirmed) {

            $user->profile->level2_confirmed = 1;

            $text = "Nivel 2 Verificado Con Exito";

        } else if (!$user->profile->level3_confirmed && $user->profile->level2_confirmed) {

            $user->profile->level3_confirmed = 1;
            $level = Level::whereCode(3)->first();
            $user->config->withdraw_max_limit = $this->setting->withdraw_max_limit * $level->percent;
            $user->level()->associate($level);
            $text = "Nivel 3 Verificado Con Exito";

        }

        $user->push();

        return response()->json(['message' => "success", 'respond' => $text], 202);

    }

    public function kycReject(Request $request)
    {
        $request->validate([
            'id' => 'required',
            'data' => 'required',
            'concor' => 'required',
            'files' => 'required',
        ]);

        $user = User::find($request->id);

        if (!$user->profile->level1_confirmed) {
            $level = 1;
        } else if (!$user->profile->level2_confirmed) {
            $level = 2;
        } else if (!$user->profile->level3_confirmed) {
            $level = 3;
        }

        $data = ['type' => $user->profile->user_type, 'level' => $level, 'data' => $request->data, 'concor' => $request->concor, 'files' => $request->files];

        Mail::to($user->email)->send(new RejectedEmail($data));
        $text = "Verificación rechazada con exito";
        return response()->json(['message' => "success", 'respond' => $text], 202);

    }

    public function kycUpdate(Request $request)
    {

        $user = User::find($request->id);
        if (!$user->profile->level1_confirmed) {
            if ($user->profile->user_type == 1) {
                $request->validate([
                    'id' => 'required',
                    'fname' => 'required',
                    'flastname' => 'required',
                    'slastname' => 'required',
                    'id_number' => 'required',
                    'type_id' => 'required',
                    'date_issue' => 'required',
                    'date_expiry' => 'required',
                    'gender' => 'required',
                    'born_date' => 'required',
                    'country' => 'required',
                    'state' => 'required',
                    'city' => 'required',
                    'phonenumber' => 'required',
                    'born_site' => 'required',
                    'issuing_state' => 'required',
                ]);

                $profile = User::find($request->id)->profile;
                $profile->type_id = $request->type_id;
                $profile->issuing_state = $request->issuing_state;
                $profile->date_issue = $request->date_issue;
                $profile->date_expiry = $request->date_expiry;
                $profile->gender = $request->gender;
                $profile->marital_status = $request->marital_status;
                if ($profile->id_number != $request->id_number) {
                    $profile->id_number = $request->id_number;
                }
                $profile->street = $request->street;
                $profile->house = $request->house;
                $profile->postal_code = $request->postal;
                $profile->born_date = $request->born_date;
                $profile->phonenumber = $request->phonenumber;
                $profile->country_id = $request->country;
                $profile->region_id = $request->state;
                $profile->city_id = $request->city;
                $profile->born_site = $request->born_site;
                $profile->save();
            } else {

                $request->validate([
                    'corporate_name' => 'required|string',
                    'date_incorporation' => 'required|string',
                    'country' => 'required|integer',
                    'state' => 'required|integer',
                    'city' => 'required|integer',
                    'place_incorporation' => 'required|string',
                    'postal' => 'required|string|max:6',
                    'register_incoporation_office' => 'required|string',
                    'type_company' => 'required|string',
                    'shareholders' => 'required|integer',
                    'email_address' => 'required|string|max:100',
                    'merchant_record' => 'required|string',
                    'issuing_state' => 'required|string',
                    'date_issue' => 'required|string',
                    'date_expiry' => 'required|string',
                    'phone_number' => 'required|string',
                    'website' => 'string',
                    'sharehold' => 'required',
                ]);

                $shareholders = $request->shareholders;

                $organization = User::find($request->id)->organization;
                $organization->corporate_name = $request->corporate_name;
                $organization->date_incorporation = $request->date_incorporation;
                $organization->country_id = $request->country;
                $organization->region_id = $request->state;
                $organization->city_id = $request->city;
                $organization->place_incorporation = $request->place_incorporation;
                $organization->postal_code = $request->postal;
                $organization->register_incoporation_office = $request->register_incoporation_office;
                $organization->type_company = $request->type_company;
                $organization->shareholders = $shareholders;
                $organization->email_address = $request->email_address;
                $organization->merchant_record = $request->merchant_record;
                $organization->issuing_state = $request->issuing_state;
                $organization->date_issue = $request->date_issue;
                $organization->date_expiry = $request->date_expiry;
                $organization->phone_number = $request->phone_number;
                $organization->website = $request->website;
                $organization->update();

                foreach ($request->sharehold as $sharehold) {
                    $patner = Patner::find($sharehold['id']);
                    $patner->position = $sharehold['position'];
                    if ($sharehold['type'] == 'sharehold') {
                        $patner->fname_legal_shareholder = $sharehold['fname'];
                        $patner->sname_legal_shareholder = $sharehold['sname'];
                        $patner->flname_legal_shareholder = $sharehold['flname'];
                        $patner->slname_legal_shareholder = $sharehold['slname'];
                        $patner->id_legal_shareholder = $sharehold['id_number'];
                    } else {
                        $patner->fname_legal_representative = $sharehold['fname'];
                        $patner->sname_legal_representative = $sharehold['sname'];
                        $patner->flname_legal_representative = $sharehold['flname'];
                        $patner->slname_legal_representative = $sharehold['slname'];
                        $patner->id_legal_representative = $sharehold['id_number'];
                    }
                    $patner->save();
                }
            }

        } else if (!$user->profile->level2_confirmed) {
            if ($user->profile->user_type == 1) {
                $request->validate([
                    'profession_occupation' => 'required|string',
                    'position' => 'required|string|max:20',
                    'politically_exposed_person' => 'required|integer',
                    'years_in_company' => 'required|integer',
                    'annual_income' => 'required',
                ]);

                $profile = User::find($request->id)->profile;

                $profile->profession_occupation = $request->profession_occupation;
                $profile->position = $request->position;

                if ($request->politically_exposed_person) {
                    $profile->politically_exposed_person = $request->politically_exposed_person;
                    if ($request->select_exposed_person == 'public_employee') {
                        $profile->public_employee = 1;
                    } else if ($request->select_exposed_person == 'military') {
                        $profile->military = 1;
                    } else if ($request->select_exposed_person == 'political_party_member') {
                        $profile->political_party_member = 1;
                    } else if ($request->select_exposed_person == 'diplomat') {
                        $profile->diplomat = 1;
                    }
                }

                $profile->years_in_company = $request->years_in_company;
                $profile->annual_income = $request->annual_income;

                $profile->save();
            } else {
                $request->validate([
                    'business_sector' => 'required|string',
                    'products' => 'required|string',
                    'services' => 'required|string',
                    'monthly_income' => 'required|string',
                    'annual_income' => 'required|string',
                    'net_worth' => 'required|string',
                ]);

                $organization = User::find($request->id)->organization;
                $organization->business_sector = $request->business_sector;
                $organization->products = $request->products;
                $organization->services = $request->services;
                $organization->monthly_income = $request->monthly_income;
                $organization->annual_income = $request->annual_income;
                $organization->net_worth = $request->net_worth;
                $organization->user->kyc_verified = 2;
                $organization->push();

            }

        } else if (!$user->profile->level3_confirmed) {

            if ($user->profile->user_type == 1) {
                $request->validate([
                    'financial_institution' => 'required|string',
                    'account_number' => 'required|string',
                ]);

                $profile = User::find($request->id)->profile;
                $profile->financial_institution = $request->financial_institution;
                $profile->account_number = $request->account_number;

                $profile->save();

            } else {

                $request->validate([
                    'account_number' => 'required|string',
                    'ABA_routing' => 'required|string',
                    'SWIFT' => 'required|string',
                    'IBAN' => 'required|string',
                    'financial_institution' => 'required|string',
                    'bank_address' => 'required|string',
                    'currency' => 'required|string',
                ]);

                $organization = User::find($request->id)->organization;
                $organization->account_number = $request->account_number;
                $organization->ABA_routing = $request->ABA_routing;
                $organization->SWIFT = $request->SWIFT;
                $organization->IBAN = $request->IBAN;
                $organization->financial_institution = $request->financial_institution;
                $organization->bank_address = $request->bank_address;
                $organization->currency = $request->currency;
                $organization->update();

            }

        }

        $text = "Usuario editado con exito";
        return response()->json(['message' => "success", 'respond' => $text], 202);
    }

    public function validJuridicDocument(Request $request)
    {

        $user_id = $request->id;

        $user = User::with('document')->where('id', $user_id)->first();

        if ($request->has('rif')) {

            $file_source = $request->file('rif');
            $name_source = uniqid() . '.pdf';
            $file_source->storeAs('public/' . $user->organization->merchant_record, $name_source);
            $document = $user->document;
            $document->rif = $name_source;

        }
        if ($request->has('register')) {

            $file_sworn = $request->file('register');
            $name_sworn = uniqid() . '.pdf';
            $file_sworn->storeAs('public/' . $user->organization->merchant_record, $name_sworn);
            $document = $user->document;
            $document->merchant_record = $name_sworn;

        }

        $document->save();
        $user->save();
        return response()->json('success', 200);

        return response()->json('error', 400);
    }

    public function validJuridicBankDocument(Request $request)
    {
        if ($request->has('source_founds')) {
            $user_id = $request->id;

            $user = User::with('document', 'organization')->where('id', $user_id)->first();
            $file_source = $request->file('source_founds');
            $name_source = uniqid() . '.pdf';
            $file_source->storeAs('public/' . $user->organization->merchant_record, $name_source);

            $document = $user->document;
            $document->source_founds = $name_source;

            $document->save();

            $user->kyc_verified = 3;
            $user->save();

            return response()->json('success', 200);
        }
        return response()->json('error', 400);
    }

    public function validatePhotoID(Request $request)
    {
        if ($request->has('photo_id')) {
            $user = User::find($request->id);
            $file = $request->file('photo_id');
            $name = uniqid() . '.jpg';
            $file->storeAs('public/' . $user->profile->id_number, $name);
            $document = $user->document;
            $document->identification = $name;
            $document->save();

            return response()->json('success', 200);
        }
        return response()->json('error', 400);
    }

    public function validateSelfie(Request $request)
    {
        if ($request->has('selfie')) {
            $user = User::find($request->id);

            $file = $request->file('selfie');
            $name = uniqid() . '.jpg';
            $file->storeAs('public/' . $user->profile->id_number, $name);
            $document = $user->document;
            $document->selfie = $name;
            $document->save();
            $user->save();

            return response()->json('success', 200);
        }
        return response()->json('error', 400);
    }

    public function validateAddress(Request $request)
    {
        if ($request->has('address')) {
            $user = User::find($request->id);
            $file = $request->file('address');
            $name = uniqid() . '.jpg';
            $file->storeAs('public/' . $user->profile->id_number, $name);
            $document = $user->document;
            $document->mailing_address = $name;
            $document->save();

            return response()->json('success', 200);
        }
        return response()->json('error', 400);
    }

    public function validatePersonExposed(Request $request)
    {
        if ($request->has('person_exposed')) {
            $user = User::find($request->id);
            $file = $request->file('person_exposed');
            $name = uniqid() . '.pdf';
            $file->storeAs($user->profile->id_number, $name);
            $document = $user->document;
            $document->politically_exposed_person = $name;
            $document->save();
            $user->save();

            return response()->json('success', 200);
        }
        return response()->json('error', 400);
    }

    public function validBankDocument(Request $request)
    {

        $user_id = $request->id;

        $user = User::with('document')->where('id', $user_id)->first();

        if ($request->has('source_founds')) {

            $file_source = $request->file('source_founds');
            $name_source = uniqid() . '.pdf';
            $file_source->storeAs($user->profile->id_number, $name_source);
            $document = $user->document;
            $document->source_founds = $name_source;

        }
        if ($request->has('sworn_declaration')) {

            $file_sworn = $request->file('sworn_declaration');
            $name_sworn = uniqid() . '.pdf';
            $file_sworn->storeAs($user->profile->id_number, $name_sworn);
            $document = $user->document;
            $document->sworn_declaration = $name_sworn;

        }

        $document->save();
        $user->save();
        return response()->json('success', 200);

        return response()->json('error', 400);
    }
}
