<?php

namespace App\Http\Controllers\Frontend;

use App\Balance;
use App\Currency;
use App\Http\Controllers\Controller;
use App\Role;
use App\User;
use App\Level;
use App\Setting;
use Carbon\Carbon;

class VerificationController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */

	 private $setting;

	public function __construct()
    {
		$this->setting = Setting::first();
    }
	

    public function verifiedEmail($user, $hash)
    {

        $user = User::where('email', $user)->first();

        $time = Carbon::now();
        $expire = Carbon::parse($user->verification_expire);
        $diff = $expire->diffInMinutes($time);
        $currencies = Currency::All();
        $role = Role::where('slug', 'Client')->first();
        if ($diff >= 60) {
            return redirect()->route('verified.error');
        } else {
            if ($user->verification_token == $hash) {
                if ($user->verified != 1) {
					$level = Level::whereCode(1)->first();
                    foreach ($currencies as $currency) {
                        $bal = new Balance;
                        $bal->amount = 0;
                        $bal->pending_amount = 0;
                        $bal->type = "fund";
                        $bal->user()->associate($user);
                        $bal->currency()->associate($currency);
                        $bal->save();
					}
					$user->roles()->attach($role);
					$user->config->withdraw_max_limit = $this->setting->withdraw_max_limit * $level->percent;
					$user->level()->associate($level);
					$user->verified = 1;
                    $user->push();
                }
                return redirect()->route('verified.confirmation');
            } else {
                return redirect()->route('verified.error');
            }
        }
    }
}
