<?php

namespace App\Http\Controllers\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;

class NewsletterMail extends Mailable
{
    use Queueable, SerializesModels;

    /**
     * Create a new message instance.
     *
     * @return void
     */
     public function __construct($data)
     {
         //
         $this->data = $data;
     }

     /**
      * Build the message.
      *
      * @return $this
      */
     public function build()
     {
         return $this->view('emails.newsletter')->subject('Mensaje del sistema')->with(['data' => $this->data]);
     }
}
