<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\App;
use App\Setting;
use App\Language;

class Locale
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
      if(Auth::check()){
        $user = Auth::user();
        $config = $user->config;
        $locale = $config->language->suffix;
        App::setLocale($locale);
      }else{
        $setting = Setting::first();
        if($setting){
          $locale = $setting->language->suffix;
          App::setLocale($locale);
        }else{
          $language = Language::Where('selected', true)->first();
          if($language){
            $locale = $language->suffix;
            App::setLocale($locale);
          }
        }
      }
      return $next($request);
    }
}
