<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\Auth;

class RedirectContract
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        $user = Auth::user();
        if ($user) {
            $admin_role = $user->roles->where('slug', 'Administrator')->first();

            if ($admin_role) {
                return $next($request);
            }

            if (!$user->data->accept_contract) {
                return redirect()->route('contract');
            }

            return $next($request);

        } else {
            return $next($request);

        }

    }
}
