<?php

namespace App\Http\Middleware;

use Illuminate\Support\Facades\Auth;
use Closure;

class TwoVerify
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        $user = Auth::user();
        $secret = $user->data->secret_status;
        if($secret) {
            $valid = $user->two_verified;
            if($valid){
                return $next($request);
            }
            return redirect()->route('validate-auth');
        }

        $email_secret = $user->data->verify_via_email;
        if($email_secret) {
            $valid = $user->two_verified;
            if($valid){
                return $next($request);
            }
            return redirect()->route('email-code');
        }

        return $next($request);
    }
}
