<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\Auth;
use App\User;

class VerifyIdentity
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next, $flag = '')
    {
        $user_id = Auth::user()->id;
        $user = User::with('profile', 'document', 'organization.patners')->where('id', $user_id)->first();

        switch($flag) {
            case 'type_person':
                $type_person = $user->profile->user_type;
                $id = $user->profile->id_number;
                $org = $user->organization;
                if($type_person == 1 && $id) {
                    return redirect()->route('personal-information');
                }

                if($org) {
                    $rec = $user->organization->merchant_record;
                    if($type_person == 2 && $rec) {
                        return redirect()->route('juridic-information');
                    }
                }
                return $next($request);
            break;

            //Personal Cases
            case 'inf_person':
                $id = $user->profile->id_number;
                if($id) return redirect()->route('personal-document');
                return $next($request);
            break;

            case 'doc_person':
                $doc = $user->document->selfie;
                if($doc) return redirect()->route('professional-information');
                return $next($request);
            break;

            case 'inf_profes':
                $inf = $user->profile->profession_occupation;
                if($inf) return redirect()->route('professional-document');
                return $next($request);
            break;
            
            case 'doc_profes':
                $doc_pro = $user->document->mailing_address;
                if($doc_pro) return redirect()->route('bank-information');
                return $next($request);
            break;

            case 'inf_bank':
                $bank = $user->profile->account_number;
                if($bank) return redirect()->route('bank-document');
                return $next($request);
            break;

            case 'doc_bank':
                $bank_doc = $user->document->source_founds;
                if($bank_doc) return redirect()->route('success');
                return $next($request);
            break;

            //Juridic Cases
            case 'inf_juridic':
                $rec = $user->organization->merchant_record;
                if($rec) {
                    $patner = $user->organization->shareholders;
                    if($patner) {
                        return redirect()->route('valid-patners');
                    }
                    return redirect()->route('juridic-document');
                }
                return $next($request);
            break;

            case 'inf_patners':
                $pat = $user->organization->patners;
                $total_pat = count($pat);
                $total_shar = $user->organization->shareholders;
                if($total_pat == ($total_shar+1)) return redirect()->route('juridic-document');
                return $next($request);
            break;

            case 'doc_juridic':
                $rec = $user->document->merchant_record;
                if($rec) return redirect()->route('juridic-professional-information');
                return $next($request);
            break;

            case 'pro_juridic':
                $pro = $user->organization->business_sector;
                if($pro) return redirect()->route('juridic-bank-information');
                return $next($request);
            break;

            case 'bnk_juridic':
                $bnk = $user->organization->account_number;
                if($bnk) return redirect()->route('juridic-bank-document');
                return $next($request);
            break;

            case 'db_juridic':
                $db = $user->document->source_founds;
                if($db) return redirect()->route('success');
                return $next($request);
            break;
        }
        
        return $next($request);
    }
}
