<?php

namespace App;

use App\Notifications\ResetPassword as ResetPasswordNotification;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use JWTAuth;
use JWTFactory;

class User extends Authenticatable
{
    use Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'email', 'password',
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password', 'remember_token',
    ];

    public function data()
    {
        return $this->hasOne('App\UserData');
    }

    public function profile()
    {
        return $this->hasOne('App\Profile');
    }

    public function document()
    {
        return $this->hasOne('App\Document');
    }

    public function organization()
    {
        return $this->hasOne('App\Organization');
    }

    public function files(){
      return $this->hasMany('App\Files');
    }

    public function config()
    {
        return $this->hasOne('App\Config');
    }

    public function accounts()
    {
        return $this->hasMany('App\Account');
    }

    public function newsletters()
    {
        return $this->hasMany('App\Newsletter');
    }

    public function historicals()
    {
        return $this->hasMany('App\Historical');
    }

    public function balances()
    {
        return $this->hasMany('App\Balance');
    }

    public function orders()
    {
        return $this->hasMany('App\Order');
    }

    public function roles()
    {
        return $this->belongsToMany('App\Role', 'role_user', 'user_id', 'role_id');
    }

    public function level()
    {
        return $this->belongsTo('App\Level');
    }

    public function getRole()
    {
        return $this->roles()->get();
    }

    public function session()
    {
        return $this->hasMany('App\Session')->orderBy('last_activity', 'desc');
    }

    public function scopeWithAll($query)
    {
        $query->with('data', 'profile', 'roles', 'level', 'session');
    }

    public function scopeKYCUser($query)
    {
        $query->with('document', 'profile');
    }

    public function sendPasswordResetNotification($token)
    {
        $this->notify(new ResetPasswordNotification($token));
    }

    public function hasCredential($creN)
    {
        $roles = $this->roles;
        foreach ($roles as $role) {
            $credentials = $role->credentials;
            foreach ($credentials as $credential) {
                if ($credential->code == $creN) {
                    return true;
                }
            }
        }
        return false;
    }

    public function hasRole($roleN)
    {
        $roles = $this->roles()->get();
        foreach ($roles as $role) {
            if ($role->code == $roleN) {
                return true;
            }
        }
        return false;
    }

    public function generateJWT()
    {
        $user = $this;
        if ($user->level()->first()) {
            if ($user->level()->first()->code >= 3) {
                $verified = 1;
            } else {
                $verified = 0;
            }

        } else {
            $verified = 0;

        }

        $customClaims = ['iss' => 'AFX', 'aud' => 'AFX.trade', 'sub' => 'HTTP REQUEST', 'email' => $user->email, 'userid' => $user->id_token, 'verified' => $verified, 'hostedby' => '0000'];

        $token = JWTAuth::fromUser($user, $customClaims);
        session_start();
        $_SESSION['token'] = $token;

        return true;
    }

    public function getJWT()
    {
        session_start();
        $token = $_SESSION['token'];
        return $token;
    }
}
