/*!
 *  Lang.js for Laravel localization in JavaScript.
 *
 *  @version 1.1.10
 *  @license MIT https://github.com/rmariuzzo/Lang.js/blob/master/LICENSE
 *  @site    https://github.com/rmariuzzo/Lang.js
 *  @author  Rubens Mariuzzo <rubens@mariuzzo.com>
 */
(function(root,factory){"use strict";if(typeof define==="function"&&define.amd){define([],factory)}else if(typeof exports==="object"){module.exports=factory()}else{root.Lang=factory()}})(this,function(){"use strict";function inferLocale(){if(typeof document!=="undefined"&&document.documentElement){return document.documentElement.lang}}function convertNumber(str){if(str==="-Inf"){return-Infinity}else if(str==="+Inf"||str==="Inf"||str==="*"){return Infinity}return parseInt(str,10)}var intervalRegexp=/^({\s*(\-?\d+(\.\d+)?[\s*,\s*\-?\d+(\.\d+)?]*)\s*})|([\[\]])\s*(-Inf|\*|\-?\d+(\.\d+)?)\s*,\s*(\+?Inf|\*|\-?\d+(\.\d+)?)\s*([\[\]])$/;var anyIntervalRegexp=/({\s*(\-?\d+(\.\d+)?[\s*,\s*\-?\d+(\.\d+)?]*)\s*})|([\[\]])\s*(-Inf|\*|\-?\d+(\.\d+)?)\s*,\s*(\+?Inf|\*|\-?\d+(\.\d+)?)\s*([\[\]])/;var defaults={locale:"en"};var Lang=function(options){options=options||{};this.locale=options.locale||inferLocale()||defaults.locale;this.fallback=options.fallback;this.messages=options.messages};Lang.prototype.setMessages=function(messages){this.messages=messages};Lang.prototype.getLocale=function(){return this.locale||this.fallback};Lang.prototype.setLocale=function(locale){this.locale=locale};Lang.prototype.getFallback=function(){return this.fallback};Lang.prototype.setFallback=function(fallback){this.fallback=fallback};Lang.prototype.has=function(key,locale){if(typeof key!=="string"||!this.messages){return false}return this._getMessage(key,locale)!==null};Lang.prototype.get=function(key,replacements,locale){if(!this.has(key,locale)){return key}var message=this._getMessage(key,locale);if(message===null){return key}if(replacements){message=this._applyReplacements(message,replacements)}return message};Lang.prototype.trans=function(key,replacements){return this.get(key,replacements)};Lang.prototype.choice=function(key,number,replacements,locale){replacements=typeof replacements!=="undefined"?replacements:{};replacements.count=number;var message=this.get(key,replacements,locale);if(message===null||message===undefined){return message}var messageParts=message.split("|");var explicitRules=[];for(var i=0;i<messageParts.length;i++){messageParts[i]=messageParts[i].trim();if(anyIntervalRegexp.test(messageParts[i])){var messageSpaceSplit=messageParts[i].split(/\s/);explicitRules.push(messageSpaceSplit.shift());messageParts[i]=messageSpaceSplit.join(" ")}}if(messageParts.length===1){return message}for(var j=0;j<explicitRules.length;j++){if(this._testInterval(number,explicitRules[j])){return messageParts[j]}}var pluralForm=this._getPluralForm(number);return messageParts[pluralForm]};Lang.prototype.transChoice=function(key,count,replacements){return this.choice(key,count,replacements)};Lang.prototype._parseKey=function(key,locale){if(typeof key!=="string"||typeof locale!=="string"){return null}var segments=key.split(".");var source=segments[0].replace(/\//g,".");return{source:locale+"."+source,sourceFallback:this.getFallback()+"."+source,entries:segments.slice(1)}};Lang.prototype._getMessage=function(key,locale){locale=locale||this.getLocale();key=this._parseKey(key,locale);if(this.messages[key.source]===undefined&&this.messages[key.sourceFallback]===undefined){return null}var message=this.messages[key.source];var entries=key.entries.slice();var subKey="";while(entries.length&&message!==undefined){var subKey=!subKey?entries.shift():subKey.concat(".",entries.shift());if(message[subKey]!==undefined){message=message[subKey];subKey=""}}if(typeof message!=="string"&&this.messages[key.sourceFallback]){message=this.messages[key.sourceFallback];entries=key.entries.slice();subKey="";while(entries.length&&message!==undefined){var subKey=!subKey?entries.shift():subKey.concat(".",entries.shift());if(message[subKey]){message=message[subKey];subKey=""}}}if(typeof message!=="string"){return null}return message};Lang.prototype._findMessageInTree=function(pathSegments,tree){while(pathSegments.length&&tree!==undefined){var dottedKey=pathSegments.join(".");if(tree[dottedKey]){tree=tree[dottedKey];break}tree=tree[pathSegments.shift()]}return tree};Lang.prototype._applyReplacements=function(message,replacements){for(var replace in replacements){message=message.replace(new RegExp(":"+replace,"gi"),function(match){var value=replacements[replace];var allCaps=match===match.toUpperCase();if(allCaps){return value.toUpperCase()}var firstCap=match===match.replace(/\w/i,function(letter){return letter.toUpperCase()});if(firstCap){return value.charAt(0).toUpperCase()+value.slice(1)}return value})}return message};Lang.prototype._testInterval=function(count,interval){if(typeof interval!=="string"){throw"Invalid interval: should be a string."}interval=interval.trim();var matches=interval.match(intervalRegexp);if(!matches){throw"Invalid interval: "+interval}if(matches[2]){var items=matches[2].split(",");for(var i=0;i<items.length;i++){if(parseInt(items[i],10)===count){return true}}}else{matches=matches.filter(function(match){return!!match});var leftDelimiter=matches[1];var leftNumber=convertNumber(matches[2]);if(leftNumber===Infinity){leftNumber=-Infinity}var rightNumber=convertNumber(matches[3]);var rightDelimiter=matches[4];return(leftDelimiter==="["?count>=leftNumber:count>leftNumber)&&(rightDelimiter==="]"?count<=rightNumber:count<rightNumber)}return false};Lang.prototype._getPluralForm=function(count){switch(this.locale){case"az":case"bo":case"dz":case"id":case"ja":case"jv":case"ka":case"km":case"kn":case"ko":case"ms":case"th":case"tr":case"vi":case"zh":return 0;case"af":case"bn":case"bg":case"ca":case"da":case"de":case"el":case"en":case"eo":case"es":case"et":case"eu":case"fa":case"fi":case"fo":case"fur":case"fy":case"gl":case"gu":case"ha":case"he":case"hu":case"is":case"it":case"ku":case"lb":case"ml":case"mn":case"mr":case"nah":case"nb":case"ne":case"nl":case"nn":case"no":case"om":case"or":case"pa":case"pap":case"ps":case"pt":case"so":case"sq":case"sv":case"sw":case"ta":case"te":case"tk":case"ur":case"zu":return count==1?0:1;case"am":case"bh":case"fil":case"fr":case"gun":case"hi":case"hy":case"ln":case"mg":case"nso":case"xbr":case"ti":case"wa":return count===0||count===1?0:1;case"be":case"bs":case"hr":case"ru":case"sr":case"uk":return count%10==1&&count%100!=11?0:count%10>=2&&count%10<=4&&(count%100<10||count%100>=20)?1:2;case"cs":case"sk":return count==1?0:count>=2&&count<=4?1:2;case"ga":return count==1?0:count==2?1:2;case"lt":return count%10==1&&count%100!=11?0:count%10>=2&&(count%100<10||count%100>=20)?1:2;case"sl":return count%100==1?0:count%100==2?1:count%100==3||count%100==4?2:3;case"mk":return count%10==1?0:1;case"mt":return count==1?0:count===0||count%100>1&&count%100<11?1:count%100>10&&count%100<20?2:3;case"lv":return count===0?0:count%10==1&&count%100!=11?1:2;case"pl":return count==1?0:count%10>=2&&count%10<=4&&(count%100<12||count%100>14)?1:2;case"cy":return count==1?0:count==2?1:count==8||count==11?2:3;case"ro":return count==1?0:count===0||count%100>0&&count%100<20?1:2;case"ar":return count===0?0:count==1?1:count==2?2:count%100>=3&&count%100<=10?3:count%100>=11&&count%100<=99?4:5;default:return 0}};return Lang});

(function () {
    Lang = new Lang();
    Lang.setMessages({"en.auth":{"failed":"These credentials do not match our records.","throttle":"Too many login attempts. Please try again in :seconds seconds."},"en.messages":{"account":"Account","accounts":"Accounts","active":"Active","address":"Address","address_management":"Address Management","amount":"Amount","back":"back","balance":"Balance","basic_information":"Basic Information","birthdate":"Birth Date","born":"Born","change":"Change","chart":"Chart","city":"City","confirm":"Confirm","copyright":"Copyright (c) 2018 Copyright","country":"Country","create":"Create","created":"Created","created_by":"Created By","currencies":"Currencies","currency":"Currency","daily":"Daily","date":"Date","deposit":"Deposit","deposits":"Deposits","distribution":"Distribution","email":"E-Mail Address","enabled":"Enabled","enter":"Enter","entity":"Entity","equivalent":"Equivalent","exchangeable":"Exchangeable","fee":"fee","first":"First","forgot_password":"Forgot Your Password?","general":"General","google_auth":"Google Authenticator","historical":"Historical","home":"Home","house":"House","ip":"IP","last_login_ip":"Last Login Ip","last_login_time":"Last Login Time","last_modified":"Last Modified","lastname":"Lastname","lenguage":"Language","login":"Login","logout":"Logout","markets":"Markets","message":"Message","modify":"Modify","monthly":"Monthly","name":"Name","new":"New","newsletter":"Newsletter","old":"Old","options":"Options","password":"Password","pending":"Pending","phone":"Phone","photo":"Photo","portfolio":"Portfolio","postal":"Postal Code","prima":"Prima","profile":"profile","profile_text_1":"Used for withdrawal and security modifications","profile_text_2":"Address Management allows you to save and write memos for each of your withdrawal addresses. The Whitelist function helps protect your funds by only allowing withdrawals to whitelisted addresses.","rate":"Rate","reference":"Reference","register":"Register","remember":"Remember me","reserved":"All Rights Reserved.","roles":"Roles","search":"Search","second":"Second","select_lenguage":"Please select language for the system.","select_theme":"Please select theme for the system.","settings":"Settings","state":"State","status":"Status","stepone":"First Step","stepthree":"Third Step","stepthree_text_1":"To finish, please enter the information of the company.","steptwo":"Second Step","steptwo_text_1":"Now, we need the information of the administrator, the e-mail address will be used as login username.","street":"Street","symbol":"Symbol","system":"System","test":"This system is in test, if you see a problem please contact us through","theme":"Theme","title":"Title","total":"Total","transactions":"Transactions","type":"Type","ubication":"Ubication","upload":"Upload","user":"User","users":"Users","value":"Value","weekly":"Weekly","welcome_steps_1":"Default Language","welcome_steps_10":"Withdraw Max Amount","welcome_steps_2":"Default Theme","welcome_steps_3":"Administrator Username","welcome_steps_4":"Administrator Password","welcome_steps_5":"Administrator Personal Data","welcome_steps_6":"Company Name","welcome_steps_7":"Company Logo","welcome_steps_8":"Company Favicon","welcome_steps_9":"Principal Fiat Currency","welcome_text_1":"Welcome To General Trading System GTS. Before getting started, we need some information on the database. You will need to know the following items before proceeding.","welcome_text_2":"We're going to use this information to create administrator user and settings data.","welcome_text_3":"In all likelihood, these items were supplied to you by the Company Owner and System Administrator. If you do not have this information, then you will need to contact them before you can continue. if you're all ready...","welcome_title":"Welcome","withdraw":"Withdraw","withdrawal_address":"Withdrawal Address Management","withdraws":"Withdraws"},"en.pagination":{"next":"Next &raquo;","previous":"&laquo; Previous"},"en.passwords":{"password":"Passwords must be at least six characters and match the confirmation.","reset":"Your password has been reset!","sent":"We have e-mailed your password reset link!","token":"This password reset token is invalid.","user":"We can't find a user with that e-mail address."},"en.system":{"continue":"Continue"},"en.validation":{"accepted":"The :attribute must be accepted.","active_url":"The :attribute is not a valid URL.","after":"The :attribute must be a date after :date.","after_or_equal":"The :attribute must be a date after or equal to :date.","alpha":"The :attribute may only contain letters.","alpha_dash":"The :attribute may only contain letters, numbers, and dashes.","alpha_num":"The :attribute may only contain letters and numbers.","array":"The :attribute must be an array.","attributes":[],"before":"The :attribute must be a date before :date.","before_or_equal":"The :attribute must be a date before or equal to :date.","between":{"array":"The :attribute must have between :min and :max items.","file":"The :attribute must be between :min and :max kilobytes.","numeric":"The :attribute must be between :min and :max.","string":"The :attribute must be between :min and :max characters."},"boolean":"The :attribute field must be true or false.","confirmed":"The :attribute confirmation does not match.","custom":{"g-recaptcha-response":{"captcha":"Captcha error! try again later or contact site admin.","required":"Please verify that you are not a robot."}},"date":"The :attribute is not a valid date.","date_format":"The :attribute does not match the format :format.","different":"The :attribute and :other must be different.","digits":"The :attribute must be :digits digits.","digits_between":"The :attribute must be between :min and :max digits.","dimensions":"The :attribute has invalid image dimensions.","distinct":"The :attribute field has a duplicate value.","email":"The :attribute must be a valid email address.","exists":"The selected :attribute is invalid.","file":"The :attribute must be a file.","filled":"The :attribute field must have a value.","gt":{"array":"The :attribute must have more than :value items.","file":"The :attribute must be greater than :value kilobytes.","numeric":"The :attribute must be greater than :value.","string":"The :attribute must be greater than :value characters."},"gte":{"array":"The :attribute must have :value items or more.","file":"The :attribute must be greater than or equal :value kilobytes.","numeric":"The :attribute must be greater than or equal :value.","string":"The :attribute must be greater than or equal :value characters."},"image":"The :attribute must be an image.","in":"The selected :attribute is invalid.","in_array":"The :attribute field does not exist in :other.","integer":"The :attribute must be an integer.","ip":"The :attribute must be a valid IP address.","ipv4":"The :attribute must be a valid IPv4 address.","ipv6":"The :attribute must be a valid IPv6 address.","json":"The :attribute must be a valid JSON string.","lt":{"array":"The :attribute must have less than :value items.","file":"The :attribute must be less than :value kilobytes.","numeric":"The :attribute must be less than :value.","string":"The :attribute must be less than :value characters."},"lte":{"array":"The :attribute must not have more than :value items.","file":"The :attribute must be less than or equal :value kilobytes.","numeric":"The :attribute must be less than or equal :value.","string":"The :attribute must be less than or equal :value characters."},"max":{"array":"The :attribute may not have more than :max items.","file":"The :attribute may not be greater than :max kilobytes.","numeric":"The :attribute may not be greater than :max.","string":"The :attribute may not be greater than :max characters."},"mimes":"The :attribute must be a file of type: :values.","mimetypes":"The :attribute must be a file of type: :values.","min":{"array":"The :attribute must have at least :min items.","file":"The :attribute must be at least :min kilobytes.","numeric":"The :attribute must be at least :min.","string":"The :attribute must be at least :min characters."},"not_in":"The selected :attribute is invalid.","not_regex":"The :attribute format is invalid.","numeric":"The :attribute must be a number.","present":"The :attribute field must be present.","regex":"The :attribute format is invalid.","required":"The :attribute field is required.","required_if":"The :attribute field is required when :other is :value.","required_unless":"The :attribute field is required unless :other is in :values.","required_with":"The :attribute field is required when :values is present.","required_with_all":"The :attribute field is required when :values is present.","required_without":"The :attribute field is required when :values is not present.","required_without_all":"The :attribute field is required when none of :values are present.","same":"The :attribute and :other must match.","size":{"array":"The :attribute must contain :size items.","file":"The :attribute must be :size kilobytes.","numeric":"The :attribute must be :size.","string":"The :attribute must be :size characters."},"string":"The :attribute must be a string.","timezone":"The :attribute must be a valid zone.","unique":"The :attribute has already been taken.","uploaded":"The :attribute failed to upload.","url":"The :attribute format is invalid."},"es.auth":{"failed":"Los datos introducidos no son correctos","throttle":"Demasiados intentos de inicio, por favor espere :seconds segundos."},"es.messages":{"account":"Cuenta","accounts":"Cuentas","active":"Activo","address":"Direcci\u00f3n","address_management":"Administrar Direcciones","amount":"Monto","back":"Atras","balance":"Balance","basic_information":"Informaci\u00f3n Basica","birthdate":"Fecha de nacimiento","born":"Nacimiento","change":"Cambiar","chart":"Grafica","city":"Ciudad","conective_de":"De","confirm":"Confirmar","copyright":"Copyright (c) 2018 Copyright","country":"Pais","create":"Crear","created":"Creado","created_by":"Creado Por","currencies":"Monedas","currency":"Moneda","daily":"Diario","date":"Fecha","deposit":"Deposito","deposits":"Depositos","distribution":"Distribuci\u00f3n","email":"Correo Electronico","enabled":"Habilitar","enter":"Entrar","entity":"Entidad","equivalent":"Equivalente","exchangeable":"Intercambiable","fee":"Couta","first":"Primer","forgot_password":"Olvidaste tu contrase\u00f1a?","general":"General","google_auth":"Autenticaci\u00f3n de Google","historical":"Historico","home":"Inicio","house":"Casa","ip":"IP","last_login_ip":"Ultimo IP de inicio","last_login_time":"Ultimo inicio de sesi\u00f3n","last_modified":"Ultima Modificaci\u00f3n","lastname":"Apellido","lenguage":"Lenguaje","login":"Iniciar Sesi\u00f3n","logout":"Cerrar Sesi\u00f3n","markets":"Mercados","message":"Mensaje","modify":"Modificar","monthly":"Mensual","name":"Nombre","new":"Nueva","newsletter":"Comunicados","old":"Vieja","options":"Opciones","password":"Contrase\u00f1a","pending":"Pendiente","phone":"Telefono","photo":"Foto","portfolio":"Portafolio","postal":"Codigo Postal","prima":"Prima","profile":"Perfil","profile_text_1":"Utilizado para retiros y modificaciones de seguridad.","profile_text_2":"La Administraci\u00f3n de direcciones te permite guardar y escribir tus direcciones para retiros. La funci\u00f3n de lista blanca ayuda a proteger tus fondos permitiendo solamente retiros de tus direcciones asociadas.","rate":"Tarifa","reference":"Referencia","register":"Registrarse","remember":"Recordarme","reserved":"Todos los derechos reservados.","roles":"Roles","search":"Buscar","second":"Segundo","select_lenguage":"Por favor seleccione el lenguaje para el sistema.","select_theme":"Por favor seleccione el tema para el sistema.","settings":"Configuraci\u00f3n","state":"Estado","status":"Estado","stepone":"Primer Paso","stepthree":"Tercer Paso","stepthree_text_1":"Para finalizar, por favor introduzca los datos de la compa\u00f1ia.","steptwo":"Segundo Paso","steptwo_text_1":"Ahora, necesitamos la informaci\u00f3n del administrador, el correo electronico sera utilizado como nombre de usuario.","street":"Calle","symbol":"Simbolo","system":"Sistema","test":"Este sistema aun esta en desarrollo, si ve alguna problema por favor contactenos a traves de","theme":"Tema","title":"Titulo","total":"Total","transactions":"Transacciones","type":"Tipo","ubication":"Ubicaci\u00f3n","upload":"Subir","user":"Usuario","users":"Usuarios","value":"Valor","weekly":"Semanal","welcome_steps_1":"Lenguaje Por Defecto","welcome_steps_10":"Monto Maximo de retiros","welcome_steps_2":"Tema Por Defecto","welcome_steps_3":"Usuario Administrador","welcome_steps_4":"Contrase\u00f1a Administrador","welcome_steps_5":"Informaci\u00f3n personal del administrador","welcome_steps_6":"Nombre de la compa\u00f1ia","welcome_steps_7":"Logo de la compa\u00f1ia","welcome_steps_8":"Favicon de la compa\u00f1ia","welcome_steps_9":"Moneda principal fiduciaria","welcome_text_1":"Bienvenido a General Trading System GTS. Antes de empezar, necesitamos alguna informaci\u00f3n en la base de datos. Por favor ten contigo la siguiente informaci\u00f3n antes de continuar.","welcome_text_2":"Vamos a usar esta informaci\u00f3n para crear el usuario administrativo y los datos del sistema","welcome_text_3":"Con toda probabilidad, estos elementos fueron proporcionados por el propietario de la compa\u00f1\u00eda y el administrador del sistema. Si no tiene esta informaci\u00f3n, tendr\u00e1 que comunicarse con ellos antes de poder continuar. si ya est\u00e1s listo ...","welcome_title":"Bienvenido","withdraw":"Retiro","withdrawal_address":"Administraci\u00f3n de direcciones para retiro","withdraws":"Retiros"},"es.pagination":{"next":"Siguiente &raquo;","previous":"&laquo; Anterior"},"es.passwords":{"password":"La contrase\u00f1a debe contener al menos seis caracteres y coincidir con la confirmaci\u00f3n.","reset":"Tu contrase\u00f1a ha sido reestablecida!","sent":"Te enviamos un correo con el link de reinicio de contrase\u00f1a!","token":"El Token de reinicio de contrase\u00f1a no es valido","user":"No se encuentra un usuario con ese correo electronico"},"es.system":{"continue":"Continuar"},"es.validation":{"accepted":"El :attribute tiene que ser aceptado.","active_url":"El :attribute no es un URL valido.","after":"El :attribute debe ser una fecha despues de :date.","after_or_equal":"El :attribute debe ser una fecha despues o igual que :date.","alpha":"El :attribute debe contener solo letras.","alpha_dash":"El :attribute debe contener solo numeros, letras y guiones.","alpha_num":"El :attribute debe contener solo letras y numeros.","array":"El :attribute debe ser un arreglo.","attributes":[],"before":"El :attribute debe ser una fecha antes de :date.","before_or_equal":"El :attribute debe ser una fecha antes o igual que  :date.","between":{"array":"The :attribute must have between :min and :max items.","file":"The :attribute must be between :min and :max kilobytes.","numeric":"The :attribute must be between :min and :max.","string":"The :attribute must be between :min and :max characters."},"boolean":"The :attribute field must be true or false.","confirmed":"The :attribute confirmation does not match.","custom":{"g-recaptcha-response":{"captcha":"Error de Captcha. Prueba despues o contacta al administrador del sitio.","required":"Por favor. Verifica que no eres un Robot!"}},"date":"The :attribute is not a valid date.","date_format":"The :attribute does not match the format :format.","different":"The :attribute and :other must be different.","digits":"The :attribute must be :digits digits.","digits_between":"The :attribute must be between :min and :max digits.","dimensions":"The :attribute has invalid image dimensions.","distinct":"The :attribute field has a duplicate value.","email":"The :attribute must be a valid email address.","exists":"The selected :attribute is invalid.","file":"The :attribute must be a file.","filled":"The :attribute field must have a value.","gt":{"array":"The :attribute must have more than :value items.","file":"The :attribute must be greater than :value kilobytes.","numeric":"The :attribute must be greater than :value.","string":"The :attribute must be greater than :value characters."},"gte":{"array":"The :attribute must have :value items or more.","file":"The :attribute must be greater than or equal :value kilobytes.","numeric":"The :attribute must be greater than or equal :value.","string":"The :attribute must be greater than or equal :value characters."},"image":"The :attribute must be an image.","in":"The selected :attribute is invalid.","in_array":"The :attribute field does not exist in :other.","integer":"The :attribute must be an integer.","ip":"The :attribute must be a valid IP address.","ipv4":"The :attribute must be a valid IPv4 address.","ipv6":"The :attribute must be a valid IPv6 address.","json":"The :attribute must be a valid JSON string.","lt":{"array":"The :attribute must have less than :value items.","file":"The :attribute must be less than :value kilobytes.","numeric":"The :attribute must be less than :value.","string":"The :attribute must be less than :value characters."},"lte":{"array":"The :attribute must not have more than :value items.","file":"The :attribute must be less than or equal :value kilobytes.","numeric":"The :attribute must be less than or equal :value.","string":"The :attribute must be less than or equal :value characters."},"max":{"array":"The :attribute may not have more than :max items.","file":"The :attribute may not be greater than :max kilobytes.","numeric":"The :attribute may not be greater than :max.","string":"The :attribute may not be greater than :max characters."},"mimes":"The :attribute must be a file of type: :values.","mimetypes":"The :attribute must be a file of type: :values.","min":{"array":"The :attribute must have at least :min items.","file":"The :attribute must be at least :min kilobytes.","numeric":"The :attribute must be at least :min.","string":"The :attribute must be at least :min characters."},"not_in":"The selected :attribute is invalid.","not_regex":"The :attribute format is invalid.","numeric":"The :attribute must be a number.","present":"The :attribute field must be present.","regex":"The :attribute format is invalid.","required":"The :attribute field is required.","required_if":"The :attribute field is required when :other is :value.","required_unless":"The :attribute field is required unless :other is in :values.","required_with":"The :attribute field is required when :values is present.","required_with_all":"The :attribute field is required when :values is present.","required_without":"The :attribute field is required when :values is not present.","required_without_all":"The :attribute field is required when none of :values are present.","same":"The :attribute and :other must match.","size":{"array":"The :attribute must contain :size items.","file":"The :attribute must be :size kilobytes.","numeric":"The :attribute must be :size.","string":"The :attribute must be :size characters."},"string":"The :attribute must be a string.","timezone":"The :attribute must be a valid zone.","unique":"The :attribute has already been taken.","uploaded":"The :attribute failed to upload.","url":"The :attribute format is invalid."}});
})();
