<?php
// app/api/balance/currencies

    header("Content-Type:application/json");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
    
    // parametros obligatorios
    $parmsob = array("sessionid");
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    //Declaramos e inicializamos nuestras variables
    $out = new stdClass();
    $sessionid = $_GET["sessionid"];
    
    //Validamos que la session del usuario sea valida para continuar
    isSessionValid($db, $sessionid);
    
    //Contamos los resultados total del query a ejecutar
    $sql = "SELECT COUNT(id) AS qty ".
    "       FROM currencies ".
    "       WHERE EXISTS( ".
    "           SELECT 1 FROM pairs ".
    "           WHERE pairs.currencyid = currencies.id ".
    "           OR pairs.refcurrencyid = currencies.id) ";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
            
    $total = $rs->fetch_assoc();
    
    //Retornamos el total de elementos resultantes del query
    $out->numofrecords = (int)$total["qty"];
    
    //Consultamos los valores
    $sql = "SELECT * FROM currencies".
    "       WHERE EXISTS( ".
    "           SELECT 1 FROM pairs ".
    "           WHERE pairs.currencyid = currencies.id ".
    "           OR pairs.refcurrencyid = currencies.id) ".
    "       ORDER BY symbol ASC";
    if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
    
    //Ordenamos los valores
    while($row = $rs->fetch_assoc()){
        $record = new stdClass();
        $record->id = (int)$row["id"];
        $record->symbol = $row["symbol"];
        $record->decimals = (int)$row['decimals'];
        
        $records [] = $record;
    }
    
    $out->records = $records;
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>
