<?php
//  app/api/c2p/banks
    header("Content-Type:application/json");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
    
    // parametros obligatorios
    $parmsob = array("sessionid");
    if (!parametrosValidos($_GET, $parmsob)){
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(",", $parmsob)));
    }
    
    //Definicion de variables y almacenamiento de valores enviados por GET
    $out= new stdClass();
    $sessionid = $_GET["sessionid"];
    
    //Validamos la session
    isSessionValid($db, $sessionid);
    
    // Obtenemos el lenguaje del usuario
    $lang = updateLang($db,$sessionid);
    
    // Consultamos la api de banco plaza
    $headers = array('Content-Type:application/json');
    $request = array();
    $rest = queryApiBP($BP_URL_QA, "pagos/c2p/bancos", $BP_VERSION, "GET", $headers, $request);
    
    if($rest['httpres'] != 200 && $rest['httpres'] != 201){
        switch($rest['httpres']){
            case 503:
                badEnd("500", array("msg"=>determinateMsgFail(array(
                    "esp"=>'El servidor no puede atender temporalmente su petición',
                    "eng"=>'The server is temporarily unable to service your petition BP'), $lang, "El servidor no puede atender temporalmente su petición")));
                break;
            default:
                badEnd("500", array("msg"=>determinateMsgFail(array(
                    "esp"=>'Error llamada a API BP',
                    "eng"=>'Error Call to API'), $lang, "Error llamada a API BP")));
        }
    }
    
    $out = $rest;
    
    header("HTTP/1.1 200");
    echo(json_encode($out));
    die();
    
?>