<?php 
    function getExchanges($db, $pairid, $exchangenumofrec, $ownfilterexchange, $ownexchange){
        
        //Obtenemos los datos del par para obtener los decimales base
        $sql = "SELECT pairs.refcurrencyid AS pairscurrency, ".
        "       currencies.decimals AS currencydecimals ".
        "       FROM pairs, currencies ".
        "       WHERE pairs.id AND".
        "       pairs.status = 1 AND ".
        "       pairs.id = ".$pairid." AND ".
        "       currencies.id = pairs.currencyid ".
        "       GROUP BY pairs.id".
        "       ORDER BY pairs.id ASC";
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
            
        $row = $rs->fetch_assoc();
        $currencydecimals = $row['currencydecimals'];
        
        //Obtenemos los datos del par para obtener los decimales ref
        $sql = "SELECT pairs.refcurrencyid AS pairscurrency, ".
        "       currencies.decimals AS currencydecimals ".
        "       FROM pairs, currencies ".
        "       WHERE pairs.id AND".
        "       pairs.status = 1 AND ".
        "       pairs.id = ".$pairid." AND ".
        "       currencies.id = pairs.refcurrencyid ".
        "       GROUP BY pairs.id".
        "       ORDER BY pairs.id ASC";
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
            
        $row = $rs->fetch_assoc();
        $refcurrencydecimals = $row['currencydecimals'];
        
        if(($ownexchange == 1 && $ownfilterexchange != '') || $ownexchange == 0){
            $sql = "SELECT orders.id AS orderid, ".
            "       orders.quantity AS orderqty, ".
            "       IF(orders.type = 1, orders.side, IF(orders.side = 1, 2, 1)) AS orderside, ".
            "       (SELECT ord.price FROM orders ord ".
            "       WHERE ord.type = 2 AND (ord.id = t.orderid OR ord.id = txother.orderid)) AS orderprice, ".
            "       t.id AS txid, ".
            "       t.datecreated AS datecreated,  ".
            "       IF(orders.side = 2, t.amount, tx.amount) AS qty ".
            "       FROM orders, accounts, transactions t  ".
            "           LEFT JOIN transactions tx ".
            "           ON t.orderid = tx.orderid  ".
            "           AND t.txid = tx.txid ".
            "           AND tx.amount < 0 ".
            "           AND tx.dsc NOT LIKE 'Comisi%' ".
            "           LEFT JOIN transactions txother ".
            "           ON t.orderid != txother.orderid ".
            "           AND t.txid = txother.txid  ".
            "           AND txother.amount > 0 ".
            "           AND txother.dsc NOT LIKE 'Comisi%' ".
            "       WHERE t.orderid IS NOT NULL ".
            "       ".$ownfilterexchange.
            "       AND orders.id = txother.orderid ".
            "       AND orders.pairid = ".$pairid.
            "       AND t.id = t.txid ".
            "       AND t.dsc NOT LIKE 'Comisi%' ".
            "       AND accounts.id = orders.accountid ".
            "       GROUP BY t.txid ".
            "       ORDER BY datecreated DESC, txid DESC".
            "       LIMIT ".$exchangenumofrec;
            if (!$rs=$db->query($sql))
                badEnd("500", array("msg"=>$db->error.$sql));
        
            while($row = $rs->fetch_assoc()){
                $record = new stdClass();
                $record->id = (int)$row['orderid'];
            
                $record->price = new stdClass();
                $record->price->number = (float)number_format($row['orderprice'],$currencydecimals,".","");
                $record->price->formatted = number_format($record->price->number,$currencydecimals,",",".");
            
                $record->quantity = new stdClass();
                $record->quantity->number = (float)number_format(abs($row['qty']),$refcurrencydecimals,".","");
                $record->quantity->formatted = number_format($record->quantity->number,$refcurrencydecimals,",",".");
            
                $record->date = new stdClass();
                $record->date->cannonical = date("Y-m-d H:i:s", strtotime($row['datecreated']));
                $record->date->formatted = date("d/m/Y H:i", strtotime($row['datecreated']));
            
                $record->side = new stdClass();
                $record->side->id = (int)$row['orderside'];
                $record->side->dsc = $record->side->id == 1 ? 'Venta' : 'Compra' ;
            
                $exchanges [] = $record;
            }   
        }
    
        return $exchanges;
    }
?>