<?php 
    //cms/api/pairs/delete

    header("Content-Type:application/json");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
    
    // parametros obligatorios
    $parmsob = array("sessionid",'id'); 
    if (!parametrosValidos($_GET, $parmsob)){
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    }
    
    //Declaracion de variables
    $out = new stdClass();
    $sessionid = $_GET["sessionid"];
    $id = $_GET['id'];
    
    //Validamos la session
    isSessionValidCMS($db, $sessionid);
    
    //Validamos que tenga privilegios para eliminar
    if (!tienePrivilegio($db, $sessionid, 60))
        badEnd("403", array("msg"=>"No tiene Privilegios"));
    
    // COnsultamos que el par exista
    $sql = "SELECT COUNT(id) AS qty ".
    "       FROM pairs ".
    "       WHERE id = ".$id;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    $row = $rs->fetch_assoc();
    
    // Retornamos 204 cuando la busqueda no obtiene resutados
    if($row['qty'] == 0){
        badEnd("204", array("msg"=>"No se encuentra el registro"));
    }
    
    // Consultamos para usar el nombre en la auditoria
    $sql = "SELECT CONCAT(curr.symbol,'/',currencies.symbol) AS name ".
    "       FROM currencies, pairs par ".
    "       LEFT JOIN currencies curr ON par.refcurrencyid = curr.id".
    "       WHERE currencies.id = par.currencyid ".
    "       AND par.id = ".$id;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    $row = $rs->fetch_assoc();
    
    // Eliminamos los registros de el par
    $db->autocommit(FALSE);
    
    $sql = "DELETE FROM pairs WHERE id = ".$id;
    if (!$db->query($sql)){
        $error = $db->error;
        $errono = $db->errno;
        $db->rollback();
        $db->close();
        if ($errono == 1451)
            badEnd("304",array("msg"=>"Existen dependencias que no permiten eliminar este par"." ".$error));
        else
            badEnd("500",array("msg"=>$error." ".$error));
    }
    
    $sql = "DELETE FROM cmspreffees WHERE pairid = ".$id;
    if (!$db->query($sql)){
        $error = $db->error;
        $errono = $db->errno;
        $db->rollback();
        $db->close();
        if ($errono == 1451)
            badEnd("304",array("msg"=>"Existen dependencias que no permiten eliminar este par"." ".$error));
        else
            badEnd("500",array("msg"=>$error." ".$error));
    }
    
    $out->id = (int)$id;
    
    //auditoria
    setAudit($db, "PARES", $sessionid, "CMS", "Se eliminó el par ".$row['name']);
    
    $db->commit();
    $db->close();
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>