<?php 
    //cms/api/pairs/entry

    header("Content-Type:application/json");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
    
    // parametros obligatorios
    $parmsob = array("sessionid",'id'); 
    if (!parametrosValidos($_GET, $parmsob)){
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    }
    
    //Declaracion de variables
    $out = new stdClass();
    $sessionid = $_GET["sessionid"];
    $id = $_GET['id'];
    
    //Validamos la session
    isSessionValidCMS($db, $sessionid);
    
    //Validamos que el usuario tenga privilegios
    if(!tienePrivilegio($db, $sessionid, 61))
        badEnd("403", array("msg"=>"No tiene Privilegios"));
        
    // Validamos que exista el registro
    $sql = "SELECT COUNT(par.id) AS qty ".
    "       FROM currencies, pairs par ".
    "       LEFT JOIN currencies curr ON par.refcurrencyid = curr.id".
   // "       WHERE par.status = 1 ".
    "       WHERE currencies.id = par.currencyid ";//Modificado where
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    $row = $rs->fetch_assoc();
    
    // Si la cantidad es 0, retornamos error
    if($row['qty'] == 0){
        badEnd('204',array('msg'=>'Par no encontrado'));
    }
    
    // Consultamos los registros a detalle
    $sql = "SELECT currencies.name AS currencyname, currencies.symbol AS currencysymbol, ".
    "       currencies.icon AS currencyicon, ".
    "       currencies.id AS currencyid, par.id AS pairsid,".
    "       par.status AS status, ".
    "       currencies.decimals AS currencydecimals, ".
    "       curr.name AS currencyrefname, curr.symbol AS currencyrefsymbol, ".
    "       curr.icon AS currencyreficon, ".
    "       curr.id AS currencyrefid, curr.decimals AS currencyrefdecimals ".
    "       FROM currencies, pairs par ".
    "       LEFT JOIN currencies curr ON par.refcurrencyid = curr.id".
    //"       WHERE par.status = 1 ".
    "       WHERE currencies.id = par.currencyid ". //Modificado where
    "       AND par.id = ".$id.
    "       GROUP BY par.id";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
    
    $pairdata = $rs->fetch_assoc();
    
    $out->entry = new stdClass();
    $out->entry->id = (int) $pairdata["pairsid"];
    
    $out->entry->status = new stdClass();
    $out->entry->status->id = (int)$pairdata["status"];
    $out->entry->status->dsc = $out->entry->status->id == 1 ? 'Activo' : 'Inactivo';
    
    //Datos de moneda currency
    $out->entry->currency = new stdClass();
    $out->entry->currency->id = (int)$pairdata["currencyid"];
    $out->entry->currency->dsc = $pairdata["currencyname"];
    $out->entry->currency->symbol = $pairdata["currencysymbol"];
    $out->entry->currency->icon = $pairdata["currencyicon"];
    $out->entry->currency->decimals = (int)$pairdata["currencydecimals"];
    
    //Datos de refcurrency
    $out->entry->refcurrency = new stdClass();
    $out->entry->refcurrency->id = (int)$pairdata["currencyrefid"];
    $out->entry->refcurrency->dsc = $pairdata["currencyrefname"];
    $out->entry->refcurrency->symbohrol = $pairdata["currencyrefsymbol"];
    $out->entry->refcurrency->icon = $pairdata["currencyreficon"];
    $out->entry->refcurrency->decimals = (int)$pairdata["currencyrefdecimals"];
    
    $out->entry->dsc = $out->entry->refcurrency->symbol .'/'.$out->entry->currency->symbol;
    
    // Privilegios del usuario
    $privileges = new stdClass();
    $privileges->create = tienePrivilegio($db, $sessionid, 58);
    $privileges->read = tienePrivilegio($db, $sessionid, 61);
    $privileges->update = tienePrivilegio($db, $sessionid, 59);
    $privileges->delete = tienePrivilegio($db, $sessionid, 60);
    $out->privileges = $privileges;
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>