<?php
// cms/api/regions/entry

    header("Content-Type:application/json");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
    
    // parametros obligatorios
    $parmsob = array("sessionid","id");
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    //Declaramos e inicializamos nuestras variables
    $out= new stdClass;
    $sessionid = $_GET["sessionid"];
    $id = $_GET["id"];
    
    //Validamos que la session del usuario sea valida para continuar
    isSessionValidCMS($db, $sessionid);
    
    //Validamos que el usuario tenga privilegios
    if(!tienePrivilegio($db, $sessionid, 51))
        badEnd("403", array("msg"=>"No tiene Privilegios"));
        
    //Consultamos los datos especificos de la region que se requiere
    $sql = "SELECT regions.id AS regionsid, regions.name AS regionsname, ".
    "       regions.status AS regionsstatus, countries.id AS countriesid, ".
    "       countries.name AS countriesname ".
    "       FROM regions, countries".
    "       WHERE regions.id =".$id.
    "       AND regions.countryid = countries.id";
    if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
            
    //Ordenamos los valores
    $row = $rs->fetch_assoc();
    $out->entry = new stdClass();
    $out->entry->id = (int)$row["regionsid"];
    $out->entry->dsc = $row["regionsname"];
    
    $out->entry->country = new stdClass();
    $out->entry->country->id = (int)$row["countriesid"];
    $out->entry->country->dsc = $row["countriesname"];
    
    $out->entry->status = new stdClass();
    $out->entry->status->id = (int)$row["regionsstatus"];
    $out->entry->status->dsc =  $out->entry->status->id == 1 ? "Activo" : "Inactivo";
    
    //Retornamos los privilegios del usuario actual
    $access = new stdClass;
    $access->create = tienePrivilegio($db, $sessionid, 48);
    $access->read =   tienePrivilegio($db, $sessionid, 51);
    $access->update = tienePrivilegio($db, $sessionid, 49);
    $access->delete = tienePrivilegio($db, $sessionid, 50);
    $out->privileges = $access;
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>
