<?php
// api/currencies/criptolist

    header("Content-Type:application/json");
    header('Access-Control-Allow-Origin: *');
    header("Access-Control-Allow-Headers: Origin, X-Requested-With, Content-Type, Accept");
    header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE');
    include("../dbconn.php");
    include("../utils.php");
    
    // parametros obligatorios
    if (isset($_SERVER['HTTP_TOKENID']) && $_SERVER['HTTP_TOKENID'] == '')
        badEnd("400", array("msg"=>"Parametros obligatorios tokenid"));
    
    //Declaramos e inicializamos nuestras variables
    $out = new stdClass();
    // Obtener sessionid
    $sessionid = $_SERVER['HTTP_TOKENID'];
    
    // Validamos la session
    isSessionValid($db, $sessionid);
    
    // Consultamos la cantidad de monedas fiat que existen
    // interface = 4 o interface = 5
    $sql = "SELECT COUNT(id) AS qty ".
    "       FROM currencies ".
    "       WHERE interface = 4 OR interface = 5";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error.$sql));
        
    $row = $rs->fetch_assoc();
    //Retornamos el total
    $out->numofrecords = (int)$row["qty"];
    
    // Consultamos los detalles de las monedas
    $sql = "SELECT * ".
    "       FROM currencies ".
    "       WHERE interface = 4 OR interface = 5";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error.$sql));
        
    while($row = $rs->fetch_assoc()){
        $record = new stdClass();
        
        $record->id = (int)$row['id'];
        $record->name = $row['name'];
        $record->symbol = $row['symbol'];
        
        $record->status = new stdClass();
        $record->status->id = (int)$row['status'];
        $record->status->dsc = $record->status->id == 1 ? 'Activo' : 'Inactivo';
        
        $records [] = $record;
    }
    
    $out->records = $records;
 
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>
