<?php
// api/fees/operations

    header("Content-Type:application/json");
    header('Access-Control-Allow-Origin: *');
    header("Access-Control-Allow-Headers: Origin, X-Requested-With, Content-Type, Accept");
    header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE');
    include("../dbconn.php");
    include("../utils.php");
    
    // parametros obligatorios
    if (isset($_SERVER['HTTP_TOKENID']) && $_SERVER['HTTP_TOKENID'] == '')
        badEnd("400", array("msg"=>"Parametros obligatorios tokenid"));
    
    // parametros obligatorios
    $parmsob = array('currencyid');
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    //Declaramos e inicializamos nuestras variables
    $out= new stdClass();
    // Obtener sessionid
    $sessionid = $_SERVER['HTTP_TOKENID'];
    $currencyid = $_GET['currencyid'];
    // Creamos el objeto de deposito, retiro, y transferencias
    
    $out->xfer = new stdClass();
    $out->deposits = new stdClass();
    $out->withdrawals = new stdClass();
    
    //Validamos que la session del usuario sea valida para continuar
    isSessionValid($db, $sessionid);
    
    // Consultamos los decimales para montos formateados
    $sql = "SELECT decimals FROM currencies WHERE id = ".$currencyid;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    $currencydecimals = $rs->fetch_assoc();
    
    // Consultamos los datos de usuario natural 
    $sql = "SELECT cmspreffees.*, levels.name AS levelname FROM cmspreffees, levels WHERE cmspreffees.currencyid = ".$currencyid.
    "       AND levels.id = cmspreffees.levelid";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
    
    while($row = $rs->fetch_assoc()){
        $out->test [] = $row;
        
        // Depositos
        $deposit = new stdClass();
            
        $deposit->id = (int)$row['levelid'];
        $deposit->level = (int)$row['levelid'];
        $deposit->leveldsc = $row['levelname'];
        
        $deposit->fees = new stdClass();
        $deposit->fees->pctfee = new stdClass();
        $deposit->fees->nmalfee = new stdClass();
        
        if($row['nmlfeedeposits'] == null){
            $deposit->fees->pctfee->number = (float)$row['pctfeedeposits'];
            $deposit->fees->pctfee->formatted = numberFormatt($deposit->fees->pctfee->number, 3).'%';
            
            $deposit->fees->nmalfee->number = null;
            $deposit->fees->nmalfee->formatted = null;
        }else{
            $deposit->fees->pctfee->number = null;
            $deposit->fees->pctfee->formatted = null;
            
            $deposit->fees->nmalfee->number = (float)$row['nmlfeedeposits'];
            $deposit->fees->nmalfee->formatted = numberFormatt($deposit->fees->nmalfee->number, $currencydecimals['decimals']);
        }
        
        
        // Validamos el tipo de usuario
        if($row['usertype'] == 1){
            
            $naturaldeposits [] = $deposit;
            
        }else{
            
            $juridicdeposits [] = $deposit;
            
        }
        
        // retiros
        $withdraw = new stdClass();
            
        $withdraw->id = (int)$row['levelid'];
        $withdraw->level = (int)$row['levelid'];
        $withdraw->leveldsc = $row['levelname'];
        
        $withdraw->fees = new stdClass();
        $withdraw->fees->pctfee = new stdClass();
        $withdraw->fees->nmalfee = new stdClass();
        
        if($row['nmlfeewithdrawals'] == null){
            $withdraw->fees->pctfee->number = (float)$row['pctfeewithdrawals'];
            $withdraw->fees->pctfee->formatted = numberFormatt($withdraw->fees->pctfee->number, 3).'%';
            
            $withdraw->fees->nmalfee->number = null;
            $withdraw->fees->nmalfee->formatted = null;
        }else{
            $withdraw->fees->pctfee->number = null;
            $withdraw->fees->pctfee->formatted = null;
            
            $withdraw->fees->nmalfee->number = (float)$row['nmlfeewithdrawals'];
            $withdraw->fees->nmalfee->formatted = numberFormatt($withdraw->fees->nmalfee->number, $currencydecimals['decimals']);
        }
        
        
        // Validamos el tipo de usuario
        if($row['usertype'] == 1){
            
            $naturalwithdrawals [] = $withdraw;
            
        }else{
            
            $juridicwithdrawals [] = $withdraw;
            
        }
        
        // transferencias
        $xfer = new stdClass();
            
        $xfer->id = (int)$row['levelid'];
        $xfer->level = (int)$row['levelid'];
        $xfer->leveldsc = $row['levelname'];
        
        $xfer->fees = new stdClass();
        $xfer->fees->pctfee = new stdClass();
        $xfer->fees->nmalfee = new stdClass();
        
        if($row['nmlfeesxfer'] == null){
            $xfer->fees->pctfee->number = (float)$row['pctfeexfer'];
            $xfer->fees->pctfee->formatted = numberFormatt($xfer->fees->pctfee->number, 3).'%';
            
            $xfer->fees->nmalfee->number = null;
            $xfer->fees->nmalfee->formatted = null;
        }else{
            $xfer->fees->pctfee->number = null;
            $xfer->fees->pctfee->formatted = null;
            
            $xfer->fees->nmalfee->number = (float)$row['nmlfeesxfer'];
            $xfer->fees->nmalfee->formatted = numberFormatt($xfer->fees->nmalfee->number, $currencydecimals['decimals']);
        }
        
        
        // Validamos el tipo de usuario
        if($row['usertype'] == 1){
            
            $naturalxfers [] = $xfer;
            
        }else{
            
            $juridicxfers [] = $xfer;
            
        }
        
    }
    
    $out->deposits->natural = $naturaldeposits;
    $out->deposits->juridic = $juridicdeposits;
    
    $out->withdrawals->natural = $naturalwithdrawals;
    $out->withdrawals->juridic = $juridicwithdrawals;
    
    $out->xfer->natural = $naturalxfers;
    $out->xfer->juridic = $juridicxfers;
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>
