<?php
// app/api/accounts/approvedvalid

    header("Content-Type:application/json");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
    
    $out = new stdClass();
    
    //  Este servicio es para obtener las direcciones USDT que esperan por aprobacion
    //  una vez tengan confirmada una transaccion, blanqueamos ese txid, y lanzamos el approve
        
    $sql = "SELECT * ".
    "       FROM wallets ".
    "       WHERE txid IS NOT NULL".
    "       OR txidApprove IS NOT NULL";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error.$sql));
    
    while($row = $rs->fetch_assoc()){
        // Verificamos si esta en approve o no
        if($row['txid'] !== null){ 
            //  Consultamos por ese txid
            $request = array('method'=>'getTransactionByTxid','txid'=>$row['txid']);
            $rest = json_decode(queryServicesUSDT($USDT_URL, $request), true);
            $out->entry [] = $rest;
        
            if($rest != null && $rest['ret'][0]['contractRet'] == 'SUCCESS'){
                // Aprobamos la direccion
                $request = array('method'=>'approveAddress', 'from' => $row['wallet'], 'fromKey' => $row['secretKey']);
                $rest = json_decode(queryServicesUSDT($USDT_URL, $request), true);
                
                if($rest == NULL){
                    badEnd('500',array("msg"=>$rest, "msg2"=> $row));
                }
                
                // Guardamos el txid del approve
                $sql = "UPDATE wallets SET".
                "       txid = NULL, ".
                "       txidApprove = '".$rest['txid']."'".
                "       WHERE id = ".$row['id'];
                if (!$db->query($sql))
                    badEnd("500", array("msg"=>$db->error));
            }else if(($rest['ret'][0]['contractRet'] == 'OUT_OF_ENERGY' || $rest['ret'][0]['contractRet'] == 'REVERT')){
                // Expiramos la wallet
                $sql = "UPDATE wallets SET".
                "       expirationDate = DATE_SUB(NOW(), INTERVAL 7 DAY), ".
                "       txid = NULL, ".
                "       txidApprove = NULL ".
                "       WHERE id = ".$row['id'];
                if (!$db->query($sql))
                    badEnd("500", array("msg"=>$db->error));
            }
        }else if($row['txidApprove'] !== null){
            //  Consultamos por ese txid
            $request = array('method'=>'getTransactionByTxid','txid'=>$row['txidApprove']);
            $rest = json_decode(queryServicesUSDT($USDT_URL, $request), true);
            $out->entry [] = $rest;
            
            if($rest != null && $rest['ret'][0]['contractRet'] == 'SUCCESS'){
                //  Devolvemos los tron a la wallet central
                $request = array('method'=>'resendTrx', 'from'=>$row['wallet'], 'fromKey' => $row['secretKey']);
                $rest = json_decode(queryServicesUSDT($USDT_URL, $request), true);
            
                // Si es distinto a null y esta fina, lanzamos el resend y actualizamos el registro
                $sql = "UPDATE wallets SET ".
                "       txidApprove = NULL, ".
                "       txid = NULL ".
                "       WHERE id = ".$row['id'];
                if (!$db->query($sql))
                    badEnd("500", array("msg"=>$db->error));
            }else if(($rest['ret'][0]['contractRet'] == 'OUT_OF_ENERGY' || $rest['ret'][0]['contractRet'] == 'REVERT')){
                // Expiramos la wallet
                $sql = "UPDATE wallets SET".
                "       expirationDate = DATE_SUB(NOW(), INTERVAL 7 DAY), ".
                "       txid = NULL, ".
                "       txidApprove = NULL " .
                "       WHERE id = ".$row['id'];
                if (!$db->query($sql))
                    badEnd("500", array("msg"=>$db->error));
            }
        }
    }
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>