<?php
// app/api/login/recover

    header("Content-Type:application/json");
    include("../../../settings/dbconn.php");
    include_once("../../../settings/utils.php");
    require '../../hooks/PHPMailer5/PHPMailerAutoload.php';
    date_default_timezone_set('Etc/UTC');
    
    // parametros obligatorios
    $parmsob = array("hash","pwd");
    if (!parametrosValidos($_GET, $parmsob)){
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    }
    
    //Definimos las variables y guardamos los datos recibidos por GET
    $hash = $_GET["hash"];
    $pwd = $_GET["pwd"];
    $out = new stdClass();
    
    $lang = updateLang($db,$hash);
    
    $sql = "SELECT id, usr FROM users WHERE sessionid = '".$hash."'";
    if (!$rs=$db->query($sql)){
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
    }
    
    $user = $rs->fetch_assoc();
    
    // Si el usuario es nuevo y tiene transacciones pendientes de las cargamos
    $sql = "SELECT * FROM users WHERE sessionid = '".$hash."'";
    if (!$rs=$db->query($sql)){
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
    }
    
    $row = $rs->fetch_assoc();
    
    // Si es nulo o vacio es un usuario nuevo, validamos si tiene transferencias
    if ($row['pwd'] === '' || $row['pwd'] === null) {
        // Obtenemos las xfer por paypending = 1 y userid del usuario
        $sql = "SELECT * FROM transactions ".
        "       WHERE paypending = 1 ".
        "       AND accountdestination = ".$row['id'];
        if (!$resxfer=$db->query($sql)){
            badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
        }
        
        while($transRow = $resxfer->fetch_assoc()){
            // Quitamos el paypending a 0
            $sql = "UPDATE transactions SET ".
            "       paypending = 0 ".
            "       WHERE transactions.txid = ".$transRow['txid'];
            if (!$db->query($sql)){
                badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
            }
            
            // Creamos la cuenta de destino del usuario
            //Validamos si es una criptomoneda o fiat
            $isCripto = false;
            $isFiat = false;
            
            // Obtenemos los datos de la moneda de la cuenta
            $sql = "SELECT ".
            "       currencies.id AS currencyid, ".
            "       currencies.interface AS interface, ".
            "       currencies.symbol AS symbol ".
            "       FROM currencies, accounts ".
            "       WHERE accounts.currencyid = currencies.id".
            "       AND accounts.id = ".$transRow['accountid'];
            if (!$res=$db->query($sql)){
                badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
            }
            
            $currencydata = $res->fetch_assoc();
        
            if(intval($currencydata['interface']) == 1 || intval($currencydata['interface']) == 3 || intval($currencydata['interface']) == 2){
                $isFiat = true;
            }else if(intval($currencydata['interface']) == 4 || intval($currencydata['interface']) == 5 || intval($currencydata['interface']) == 6){
                $isCripto = true;
            }
            
            if($isCripto && !$isFiat){
                $apiKeySecret = '';
                $txidWallet = '';
                //Si interface = 5, generamos la wallet con la api de la TCV
                if(intval($currencydata['interface']) == 5){
                    $rsp = queryPrivate('deposit_address', $TCV_JWT, $TCV_URL, $VERSION_API, false, ['currency' => $currencydata['symbol']]);
                    $out->test = $rsp;
                    
                    //Si el address es null o la respuesta distinta a 201, error
                    if($rsp['address'] == NULL || $rsp['httpres'] != 201){
                        badEnd("402", array("msg"=>"Error al obtener direccion: ".$rsp['error']['message']));
                    }
                    
                    $walletid = $rsp['address'];
                    $apiKeySecret = randomString(8);
                }elseif(intval($currencydata['interface']) == 4){
                    $parms = array("label"=>"afxaddr");
                    $request = array('method'=>'getnewaddress','parms' => $parms);
                    $rsp = json_decode(queryServicesBTC($BTC_URL, $request), true);
        
                    // Validamos que el error no sea nulo para mandar el mensaje
                    if($rsp['error'] != null){
                        badEnd('500',array("msg"=>$rest['error']['message']));
                    }
                    
                    if($rsp['result'] == null){
                        badEnd('402',array("msg"=>"Error al obtener direccion: ".$rsp['error']['message']));
                    }
                    
                    $walletid = $rsp['result'];
                    $apiKeySecret = randomString(8);
                }else if(intval($currencydata['interface']) == 6){
                    //TETHER
                    $request = array('method'=>'createAddress');
                    //$request = array('method'=>'createAddress2','parms' => $parms); //testing width trx transaction
                    $rest = json_decode(queryServicesUSDT($USDT_URL, $request), true);
    
                    if($rest['newaddress']['address_base58'] == null){
                        badEnd('402',array("msg"=>"Error al obtener direccion: ", 'msg2'=>$rest));
                    }
    
                    $walletid = $rest['newaddress']['address_base58'];
                    $apiKeySecret = $rest['newaddress']['private_key'];
    
                    $txidWallet = $rest['transaction']['txid'];
                }else{
                    $walletid = randomString(30);
                    $apiKeySecret = randomString(8);
                }
            
                //Insertamos la nueva cuenta
                $sql = "INSERT INTO accounts".
                "       (".
                "       paymentmethodid, ".
                "       userid, ".
                "       currencyid, ".
                "       details1, ".
                "       status ".
                "       )".
                "       VALUES(".
                "       -1, ".
                "       ".$row['id'].", ".
                "       ".$currencydata['currencyid'].", ".
                "       '".$walletid."', ".
                "       1 ".
                "       )";
                if (!$db->query($sql)){
                    badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
                }
                
                // Retornamos el id que fue insertado
                $idcreated = (int)$db->insert_id;
            
                //Al ser una cripto, creamos una wallet
                $sql = "INSERT INTO wallets".
                "       (".
                "       wallet, ".
                "       secretKey, ".
                "       accountid, ".
                "       txid, ".
                "       expirationDate".
                "       )".
                "       VALUES(".
                "       '".$walletid."', ".
                "       '".$apiKeySecret."', ".
                "       ".$idcreated.", ".
                "       ".($txidWallet == '' ? 'NULL' : "'".$txidWallet."'").", ".
                "       DATE_ADD(NOW(), INTERVAL 1 YEAR)".
                "       )";
                if (!$db->query($sql)){
                    badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
                }
            
            }else if($isFiat && !$isCripto){
                //Insertamos la nueva cuenta
                $sql = "INSERT INTO accounts".
                "       (".
                "       paymentmethodid, ".
                "       userid, ".
                "       currencyid, ".
                "       status".
                "       )".
                "       VALUES(".
                "       -1, ".
                "       ".$row['id'].", ".
                "       ".$currencydata['currencyid'].", ".
                "       1".
                "       )";
                if (!$db->query($sql)){
                    badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
                }
            }else{
                badEnd("500", array("msg"=>"No se logro determinar el tipo de moneda, avise para verificar el arreglo de monedas"));
            }
            
            
            //Consultamos nuevamente los datos del usuario de destino
            $sql = "SELECT accounts.id AS accountid ".
            "       FROM accounts, users ".
            "       WHERE accounts.userid = users.id ".
            "       AND users.id = ".$row['id'].
            "       AND accounts.currencyid = ".$currencydata['currencyid'].
            "       AND accounts.paymentmethodid = -1";
            if (!$res=$db->query($sql))
                badEnd("500", array("msg"=>$db->error));
            
            $accountdestination = $res->fetch_assoc();
            
            // Obtenemos el correo del usuario
            $sql = "SELECT users.usr AS usr ".
            "       FROM users, accounts ".
            "       WHERE accounts.id = ".$transRow['accountid'].
            "       AND users.id = accounts.userid";
            if (!$res=$db->query($sql))
                badEnd("500", array("msg"=>$db->error));
            
            $usrorigin = $res->fetch_assoc();
            
            //insertamos la transferencia hacia el destino
            $sql = "INSERT INTO transactions".
            "       (".
            "       datecreated, ".
            "       dsc, ".
            "       accountid, ".
            "       txid, ".
            "       accountorigin, ".
            "       amountghost, ".
            "       amount, ".
            "       accountdestination, ".
            "       validator, ".
            "       validthru, ".
            "       paypending ".
            "       )".
            "       VALUES(".
            "       NOW(), ".
            "       'Transferencia PAY de ".$usrorigin['usr']."', ".
            "       ".$accountdestination["accountid"].", ".
            "       ".$transRow['txid'].", ".
            "       ".$transRow['accountid'].", ".
            "       0, ".
            "       ".abs($transRow['amount']).", ".
            "       ".$accountdestination["accountid"].", ".
            "       NULL, ".
            "       NULL, ".
            "       0 ".
            "       )";
            if (!$db->query($sql)){
                badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
            }
            
            // Actualizamos el movimiento de origen por la cuenta nueva
            $sql = "UPDATE transactions SET ".
            "       accountdestination = ".$accountdestination["accountid"].
            "       WHERE id = ".$transRow['id'];
            if (!$db->query($sql)){
                badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
            }
        }
    }
    
    $sql =  "UPDATE users " .
            "SET    pwd = '" . $pwd . "', ".
            "       sessionid = NULL, ".
            "       pwdexpiration = DATE_ADD(NOW(), INTERVAL 1 YEAR), ".
            "       status = 1 ".
            "WHERE  sessionid='".$hash."'";
    if (!$db->query($sql)){
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
    }
    
    if ($db->affected_rows == 0){
        badEnd("401", array("msg"=>determinateMsgFail(array(
            "esp"=>"Hash incorrecto",
            "eng"=>"Invalid Hash"), $lang, "Hash incorrecto")));
    }
    
    // Retornamos mensaje de que todo fue exitoso
    $out->msg = "Contraseña cambiada satisfactoriamente";
    
    try {
        
        // incluir auditoria
        $sql = "INSERT INTO audit (application, module, userid, dsc, ipaddress) " .
               "VALUES            ('APP','USUARIOS APP', '" .$user['id']. "', 'Se cambio la clave del usuario ".$user['usr']."', NULL)";
        if (!$db->query($sql)){
            badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
        }
        
    } catch (Exception $e){
        die();
    }
    
    //auditoria
    //setAudit($db, "USUARIOS APP", $sessionid, "APP", "Se cambio la clave del usuario ".$user['usr']);
    
    // Obtenemos el nombre del usuario
    $sql = "SELECT users.usr AS email, IF(userpersons.fname IS NULL, usercompanies.name, CONCAT(userpersons.fname,' ',userpersons.flastname)) AS name, ".
    "       IF(users.type = 1, userpersons.phone, usercompanies.phone) AS phone, " .
    "       users.level AS level, users.lang AS lang ".
    "       FROM users ".
    "       LEFT JOIN userpersons ON userpersons.usrid = users.id ".
    "       LEFT JOIN usercompanies ON usercompanies.usrid = users.id ".
    "       WHERE id = ".$user['id'];
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error.$sql));
        
    $userdata = $rs->fetch_assoc();
    
    // Consultamos los datos del mensaje
    $sql = "SELECT * FROM cmsmessages WHERE id = 11";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error.$sql));
        
    $data = $rs->fetch_assoc();
    
    // Validamos que el usuario tenga las notificaciones activas
    $sql = "SELECT * FROM usermessages ".
    "       WHERE categoryid = ".$data['category'].
    "       AND usrid = ".$user['id'];
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
    
    $userPref = $rs->fetch_assoc();
    
    if($userPref['email'] == null || $userPref['email'] == 1){
        $subject = $lang == "esp" ? $data['name_esp'] : $data['name_eng'];
        $subject = '=?UTF-8?B?'.base64_encode($subject).'?=';
        $body = 
        "       <div style='background-color: #F8F8FA;padding: 20px;'>".
        "           <img style='margin: auto; display: block;margin-bottom:10px;' width='110' height='110' src='".$homeurl."/img/afx-logo-email.png'/>".
        "           <div style='margin: auto; display: block;background-color: #FFF;border-radius: 22px;width: 60%;padding:30px;'>".
        "               <h1 class='goodText' style='color:#474C58;text-align:center;font-size: 20px;font-weight: bold;'>".($lang == "esp" ? "Hola" : "Hello")." ".$userdata['name']."</h1>".
        "               <p class='goodText' style='font-size: 18px;color: #474C58;text-align:center;margin-bottom:30px;margin-left:20px;margin-right:20px;'>".($lang == "esp" ? $data['dsc_esp'] : $data['dsc_eng'])."</p>".
        "           </div>".
        "           <p class='copy' style='margin-top:40px; color: #767E93;text-align:center;'>".$footerEmails."</p>".
        "       </div>";
        
        enviarCorreo2($fromeMail, strtolower($user['usr']), $subject, $body);
    }
    // Se valida la preferenca del mensaje y se envía según el idioma
    if($userPref['sms'] == null || $userPref['sms'] == 1){
        $msg = $lang == "esp" ? $data['sms_esp'] : $data['sms_eng'];
        enviarSMS($userdata['phone'], $msg);
    }
    
    if($userPref['system'] == null || $userPref['system'] == 1){
        
        $email = '';
        $sms = '';
        
        // Si se envia por correo obtenemos el correo del usuario
        if($userPref['email'] == null || $userPref['email'] == 1){
            $sql = "SELECT usr ".
            "       FROM users ".
            "       WHERE id = ".$user['id'];
            if (!$resPref=$db->query($sql))
                badEnd("500", array("msg"=>$db->error.$sql));
                    
            $rowPrefCom = $resPref->fetch_assoc();
            
            $email = $rowPrefCom['usr'];
        }
        
        // SI se envia por sms, obtenemos el numero del usuario
        if($userPref['sms'] == null || $userPref['sms'] == 1){
            $sql = "SELECT IF(users.type = 1, userpersons.phone, usercompanies.phone) AS phone ".
            "       FROM users ".
            "       LEFT JOIN usercompanies ON usercompanies.usrid = users.id ".
            "       LEFT JOIN userpersons ON userpersons.usrid = users.id ".
            "       WHERE users.id = ".$user['id'];
            if (!$resPref=$db->query($sql))
                badEnd("500", array("msg"=>$db->error.$sql));
                
            $rowPrefCom = $resPref->fetch_assoc();
            
            $sms = $rowPrefCom['phone'];
            
        }
                        
        // Enviamos el mensaje por la mensajeria interna
        $msg = ($lang == "esp" ? $data['dsc_esp'] : $data['dsc_eng']);
        saveInternalMsg($db, $msg, $user['id'], $email, $sms);
    }
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>
