<?php
// app/api/login2fa/register
    header("Content-Type:application/json");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
    include("../../hooks/google2fa/autoload.php");
    use PragmaRX\Google2FA\Google2FA;
    
    // parametros obligatorios
    $parmsob = array("sessionid", 'type');
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    //Declaramos e inicializamos nuestras variables
    $out= new stdClass();
    $sessionid = $_GET["sessionid"];
    $type = $_GET['type'];
    $validator = '';
    
    //Validamos que la session del usuario sea valida para continuar
    $userid = isSessionValid($db, $sessionid);
    
    // Obtenemos el lenguaje del usuario
    $lang = updateLang($db,$sessionid);
    
    //  Obtenemos los datos del usuario
    $sql = "SELECT * FROM users WHERE id = ".$userid;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
    
    $userdata = $rs->fetch_assoc();
    
    /* Parametro type
        1: Google
        2: Email
        3: Phone
    */
    if ($type == 1) {
        $out->google2fa = new stdClass();
        $google2fa = new Google2FA();
        $secretKey = '';
            
        // Si el type es 1 y ya esta activo no dejamos que entre por aqui
        if ($userdata['google2fa'] == null) {
            $secretKey = $google2fa->generateSecretKey(32);
            
            $sql = "UPDATE users SET ".
            "       google2fa = '".$secretKey."'".
            "       WHERE id = ".$userid;
            if (!$db->query($sql))
                badEnd("500", array("msg"=>$db->error));
        } else {
            $secretKey = $userdata['google2fa'];
        }
        
        $qr = $google2fa->getQRCodeUrl(
            "AFX Trade",
            $userdata['usr'],
            $secretKey
        );
        
        $out->google2fa->qr = $qr;
        $out->google2fa->secret = $secretKey;
        
    }else if ($type == 2) {
        $validator = (int)getValidator(6);
    }else if ($type == 3) {
        $validator = (int)getValidator(6);
    }else{
        badEnd("500", array("msg"=>"Parametro type debe ser 1, 2 o 3"));
    }
        
    $out->userid = (int)$userid;

    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>
