<?php
// cms/api/privileges/saveuserprivileges

    header("Content-Type:application/json");
    include("../dbconn.php");
    include("../utils.php");
    
    // parametros obligatorios
    $parmsob = array("sessionid","userid","privileges");
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    //Declaramos e inicializamos nuestras variables
    $out= new stdClass;
    $sessionid = $_GET["sessionid"];
    $userid = $_GET["userid"];
    $privileges = $_GET["privileges"];
    
    //Validamos que la session del usuario sea valida para continuar
    isSessionValidCMS($db, $sessionid);
    
    //Validamos que tenga privilegios para modificar
    if (!tienePrivilegio($db, $sessionid, 16))
        badEnd("403", array("msg"=>"No tiene Privilegios"));
    
    //Consultamos el usuario para validar que existe
    $sql = "SELECT usr, name, type FROM cmsusers WHERE type = 0 AND id = ".$userid;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
        
    $row = $rs->fetch_assoc();
    //Si el dato no existe retornamos 204
    if($row["name"] == null){
        badEnd("204", array("msg"=>"No se encuentra el registro"));
    }
    
    //Guardamos el correo del usuario
    $usr = $row["usr"];
    
    // Se eliminan los privilegios anteriores
    $sql = "DELETE FROM userprivileges WHERE userid=" . $userid;
    if (!$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
    
    
    $sql =  "INSERT INTO userprivileges(userid, privilegeid) " . 
    "       VALUES".validateInsert($privileges, $userid);
    if (!$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
                
    $out->userid = $userid;
    
    //auditoria
    setAudit($db, "USUARIOS", $sessionid, "CMS", "Se actualizaron los privilegios del usuario ".$usr);
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
    
    /*  Funcion para insertar los diversos privilegios  */
    function validateInsert($privileges, $userid){
        //Separamos cada privilegio para crear cadena e insertarlos
        $privs = explode("-", $privileges);
        $insertString = "";
        
        foreach ($privs as $priv){
            $insertString = $insertString."(".$userid.", ".$priv."),";
        }
        
        
        return substr($insertString, 0, -1);
    }
?>
