<?php
// cms/api/economicact/list

    header("Content-Type:application/json");
    include("../dbconn.php");
    include("../utils.php");
    
    // parametros obligatorios
    $parmsob = array("sessionid",'order','offset','numofrec');
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    //Declaramos e inicializamos nuestras variables
    $out= new stdClass;
    $sessionid = $_GET["sessionid"];
    $offset = $_GET['offset'];
    $numofrec = $_GET['numofrec'];
    $filter = '';
    $order = determinateOrder($_GET['order']);
    
    //Validamos que la session del usuario sea valida para continuar
    isSessionValidCMS($db, $sessionid);
    
    //Validamos que el usuario tenga privilegios
    if(!tienePrivilegio($db, $sessionid, 69))
        badEnd("403", array("msg"=>"No tiene Privilegios"));
        
    // Si obtenemos el filter, armamos el query
    if(isset($_GET['filter']) && $_GET['filter']){
        // Iniciamos la cadena del query
        $filter = " WHERE ( ";
        
        //Separamos el filtro por el simbolo +
        $filterEl = separateFilter($_GET["filter"]);
        
        //Recorremos cada elemento
        foreach($filterEl as $index => $el){
            if($index == 0){
                $filter .= " dsc LIKE '%".$el."%' ";
            }else{
                $filter .= " OR dsc LIKE '%".$el."%' ";
            }
        }
        
        $filter .= " ) ";
    }
        
    // Consultamos la cantidad registros
    $sql = "SELECT COUNT(id) AS qty ".
    "       FROM economicactivities ".
    "       ".$filter;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error.$sql));
        
    $row = $rs->fetch_assoc();
    //Retornamos el total
    $out->numofrecords = (int)$row["qty"];
    
    // Consultamos los detalles de los registros
    $sql = "SELECT * FROM economicactivities ".
    "       ".$filter.
    "       ".$order.
    "       LIMIT ".$offset.", ".$numofrec;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error.$sql));
    
    while($row=$rs->fetch_assoc()){
        $record = new stdClass();
        
        $record->id = (int)$row['id'];
        $record->dsc = $row['dsc'];
        
        $records [] = $record;
    }
    
    $out->records = $records;
    
    //Retornamos los privilegios del usuario en este modulo
    $access = new stdClass;
    $access->create = tienePrivilegio($db, $sessionid, 66);
    $access->read =   tienePrivilegio($db, $sessionid, 69);
    $access->update = tienePrivilegio($db, $sessionid, 67);
    $access->delete = tienePrivilegio($db, $sessionid, 68);
    $out->privileges = $access;
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
    
    /*  Funcion para determinar el orden de los registros, donde si:
    *   1 = nombre ASC
    *   2 = ID ASC
    *   -1 = nombre DESC
    *   -2 = ID DESC
    */
    function determinateOrder($order){
        $str = '';
        
        switch($order){
            case 1:
                $str = ' ORDER BY dsc ASC ';
                break;
            case 2:
                $str = ' ORDER BY id ASC ';
                break;
            case -1:
                $str = ' ORDER BY dsc DESC ';
                break;
            case -2:
                $str = ' ORDER BY id DESC ';
                break;
        }
        
        return $str;
    }
    
?>