<?php
// app/api/accounts/entry

    header("Content-Type:application/json");
    include("../dbconn.php");
    include("../utils.php");
    
    // parametros obligatorios
    $parmsob = array("sessionid","id");
    if (!parametrosValidos($_GET, $parmsob)){
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(",", $parmsob)));
    }
    
    //Definicion de variables y almacenamiento de valores enviados por GET
    $out= new stdClass;
    $sessionid = $_GET["sessionid"];
    $id = $_GET["id"];
    
    //Validamos la session
    isSessionValid($db, $sessionid);
    
    //Consultamos los datos del usuario por su ssid
    $sql = "SELECT id, usr FROM users WHERE sessionid = '".$sessionid."'";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    $row = $rs->fetch_assoc();
    //Guardamos el id del usuario
    $userid = $row["id"];
    
    //Consultamos los datos requeridos
    $sql = "SELECT * FROM accounts WHERE userid = ".$userid.
    "       AND id = ".$id;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    //Ordenamos el resultado
    $row = $rs->fetch_assoc();
    
    //En caso de que no existan registros retornamos 404
    if($row["id"] == null){
        badEnd("404", array("msg"=>"No encontrado"));
    }
    
    $out->entry = new stdClass();
    //Guardamos el id de la cuenta
    $out->entry->id = (int)$row["id"];
        
    //Metodo de pago
    $out->entry->paymentmethod = new stdClass();
    $out->entry->paymentmethod->id = (int)$row["paymentmethodid"];
    
    //Consultamos el nombre del metodo de pago
    $sql = "SELECT dsc".
    "       FROM paymentmethods".
    "       WHERE id = ".$row["paymentmethodid"];
    if (!$res=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    $payment = $res->fetch_assoc();
    //Guardamos el nombre del metodo de pago
    $out->entry->paymentmethod->dsc = $payment["dsc"];
        
    //Moneda de la cuenta
    $out->entry->currency = new stdClass();
    $out->entry->currency->id = (int)$row["currencyid"];
        
    //Consultamos los datos de la moneda
    $sql = "SELECT id, name, symbol FROM currencies WHERE id = ".$row["currencyid"];
    if (!$res=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    $currency = $res->fetch_assoc();
    //Guardamos los detalles de la moneda
    $out->entry->currency->dsc = $currency["name"];
    $out->entry->currency->symbol = $currency["symbol"];
        
    //Datos de la cuenta
    $out->entry->status = (int)$row["status"];
    $out->entry->deleteable = $out->entry->status == 0 ? true : false;
    $out->entry->details1 = $row["details1"] == null ? "" : $row["details1"] ;
    $out->entry->details2 = $row["details2"] == null ? "" : $row["details2"] ;
    $out->entry->details3 = $row["details3"] == null ? "" : $row["details3"] ;
    $out->entry->details4 = $row["details4"] == null ? "" : $row["details4"] ;
    
    $out->entry->valid = new stdClass();
    $out->entry->valid->id = (int)$row["valid"];
    $out->entry->valid->dsc = validateAccount($out->entry->valid->id);
        
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
    
    /*  Funcion para validar estado de la cuenta
    *   0 = Pendiente por verificar
    *   1 = Aprobada
    *   -1 = Rechazada
    */
    function validateAccount($valid){
        $strres = "";
        
        switch($valid){
            case 0:
                $strres = "Pendiente";
                break;
            case 1:
                $strres = "Activa";
                break;
            case -1:
                $strres = "Rechazada";
                break;
        }
        
        return $strres;
    }
?>
