<?php
// app/api/transactions/list

    header("Content-Type:application/json");
    include("../dbconn.php");
    include("../utils.php");
    
    // parametros obligatorios
    $parmsob = array("sessionid","parid","numofrec","offset");
    if (!parametrosValidos($_GET, $parmsob)){
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    }
    
    //Declaracion de variables
    $out = new stdClass;
    $sessionid = $_GET["sessionid"];
    $parid = $_GET["parid"];
    $numofrec = $_GET["numofrec"];
    $offset = $_GET["offset"];
    $order = determinateOrder($_GET["order"]);
    
    //Validamos la session
    isSessionValid($db, $sessionid);
    
    
    //MANTENER PARA CONSULTAS REALES, MIENTRAS SE RETORNARA DATA DUMMY
    /*
    //Obtenemos la cantidad de transacciones que existen
    $sql = "SELECT count(transactions.id) AS qty FROM transactions, orders ".
    "       WHERE transactions.amount > 0 AND orders.pairid = ".$parid." AND transactions.orderid = orders.id";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
        
    $row = $rs->fetch_assoc();
    
    //Retornamos la cantidad total de transacciones
    $out->numofrecords = (int)$row["qty"];
    
    //Consultamos los datos requeridos
    $sql = "SELECT * FROM transactions, orders ".
    "       WHERE transactions.amount > 0 AND orders.pairid = ".$parid." AND transactions.orderid = orders.id".
    "       ".$order.
    "       LIMIT ".$offset.", ".$numofrec;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
        
    //Ordenamos los resultados
    while($row = $rs->fetch_assoc()){
        $record = new stdClass();
        $record->id = (int)$row["id"];
        
        $record->price = new stdClass();
        $record->price->number = (float)$row["amount"];
        $record->price->formatted = number_format($record->price->number,2,",",".");
        
        $record->qty = new stdClass();
        $record->qty->number = (float)$row["quantity"];
        $record->qty->formatted = number_format($record->qty->number,2,",",".");
        
        $record->date = new stdClass();
        $record->date->cannonical = date("Y-m-d H:i", strtotime($row["datecreated"]));
        $record->date->formatted = date("d/m/Y h:i a", strtotime($row["datecreated"]));
        
        $record->side = new stdClass();
        $record->side->id = (int) $row["side"];
        $record->side->dsc = determinateSide($record->side->id);
        
        $records [] = $record;
    }
    
    $out->records = $records;*/
    
    $out->numofrecords = (int)$numofrec;
    
    //Ordenamos los resultados
    for($i = 0; $i < $numofrec; $i++){
        $record = new stdClass();
        $record->id = $i;
        
        $record->price = new stdClass();
        $record->price->number = rand(6000.00,10000.00)/1.2;
        $record->price->formatted = number_format($record->price->number,2,",",".");
        
        $record->qty = new stdClass();
        $record->qty->number = rand(6000.00,10000.00)/1.2;
        $record->qty->formatted = number_format($record->qty->number,2,",",".");
        
        $record->date = new stdClass();
        $record->date->cannonical = date("Y-m-d H:i", rand(1539122400,1602280800));
        $record->date->formatted = date("d/m/Y h:i a", rand(1539122400,1602280800));
        
        $record->side = new stdClass();
        $record->side->id = rand(0,2);
        $record->side->dsc = determinateSide($record->side->id);
        
        $records [] = $record;
    }
    
    $out->records = $records;
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
    
    
    /*  Funcion para determinar el orden de los datos, recibe un parametro order que puede ser:
    *   1 = date (default) DESCENDENTE
    *   2 = price DESCENDENTE
    *   3 = quantity DESCENDENTE
    *
    */
    function determinateOrder($order){
        $str = "";
        
        switch($order){
            case 1:
                $str = "transactions.datecreated DESC";
                break;
            case 2:
                $str = "transactions.amount DESC";
                break;
            case 3:
                $str = "transactions.quantity DESC";
                break;
            default:
                $str = "transactions.datecreated DESC";
                break;
        }
        
        return " ORDER BY ".$str;
    }
    
    /*  Funcion para validar si el precio subio o bajo o se mantuvo igual.
    *   Donde recibimos un parametro que:
    *   0 = No hubo cambios con el precio
    *   1 = El precio subio respecto a la transaccion anterior
    *   2 = El precio bajo respecto a la transaccion anterior
    */
    function determinateSide($side){
        $str = "";
        
        switch($side){
            case 0:
                $str = "No cambio";
                break;
            case 1:
                $str = "Subio";
                break;
            case 2:
                $str = "Bajo";
                break;
            default:
                $str = "No cambio";
                break;
        }
        
        return $str;
    }
?>