<?php
// app/api/users/entry
    header("Content-Type:application/json");
    include("../dbconn.php");
    include("../utils.php");

    // parametros obligatorios
    $parmsob = array("sessionid");
    if (!parametrosValidos($_GET, $parmsob)){
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(",", $parmsob)));
    }
    
    //definimos las variables y las rellenamos con los datos recibidos del GET
    $sessionid = $_GET["sessionid"];
    $out = new stdClass;    
    
    //Validamos la session
    isSessionValid($db, $sessionid);
    
    //Consulta de los datos iniciales
    $sql = "SELECT id, usr, datecreated, status, type, level".
    "       FROM users".
    "       WHERE sessionid = '".$sessionid."'";
    if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
            
    $userdata = $rs->fetch_assoc();
    
    if($userdata["id"] == null){
        badEnd("204", array("msg"=>"No se encuentra el registro"));
    }
    
    //Creamos el objecto de salida y asignamos los datos principales
    $out->entry = new stdClass();
    $out->entry->id = (int)$userdata["id"];
    $out->entry->usr = $userdata["usr"];
    $out->entry->datecreated = $userdata["datecreated"];
    
    //Describimos status
    $out->entry->status = new stdClass();
    $out->entry->status->id = (int)$userdata["status"];
    $out->entry->status->dsc = $out->entry->status->id == 0 ? "Inactivo" : "Activo";
    
    //Describimos type
    $out->entry->type = new stdClass();
    $out->entry->type->id = $userdata["type"] == null ? 0 : (int)$userdata["type"];
    $out->entry->type->dsc = $out->entry->type->id == 2 ? "Jurídica" : $out->entry->type->id == 1 ? "Natural" : null;
    
    //Describimos el nivel
    $out->entry->level = new stdClass();
    $out->entry->level->id = (int)$userdata["level"];
    $out->entry->level->dsc = "Nivel ".$out->entry->level->id;
    
    //Consultamos dependiendo del tipo de usuario junto su id
    if($out->entry->type->id == 1){
        $sql = "SELECT *".
        "       FROM userpersons".
        "       WHERE usrid = ".$out->entry->id;
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
            
        $userdetail = $rs->fetch_assoc();
        //Al ser usuario natural se coloca el out de company como null
        $out->entry->company = null;
    }else if($out->entry->type->id == 2){
        $sql = "SELECT *".
        "       FROM usercompanies".
        "       WHERE usrid = ".$out->entry->id;
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
            
        $userdetail = $rs->fetch_assoc();
        //Al ser usuario juridico se coloca el out de person como null
        $out->entry->person = null;
    }else{
        badEnd("304", array("msg"=>"Usuario no activado"));
    }
    
    
    //Procedemos a construir la salida de datos
    if($out->entry->type->id == 1){
        $out->entry->person = new stdClass();

        $out->entry->person->step = (int)$userdetail["step"];
        $out->entry->person->firstname = $userdetail["fname"];
        $out->entry->person->secondname = $userdetail["sname"];
        $out->entry->person->firstlastname = $userdetail["flastname"];
        $out->entry->person->secondlastname = $userdetail["slastname"];
        
        $out->entry->person->document = new stdClass();
        $out->entry->person->document->dsc = $userdetail["doc"];
        
        $out->entry->person->document->type = new stdClass();
        $out->entry->person->document->type = validateDoc($userdetail["doctype"]);
        
        $out->entry->person->document->country = new stdClass();
        $out->entry->person->document->country = getCountry($userdetail["doccountryid"], $db);
        
        $out->entry->person->document->datecreated = new stdClass();
        $out->entry->person->document->datecreated->date = date("Y-m-d H:i", strtotime($userdetail["docissue"]));
        $out->entry->person->document->datecreated->formatted = date("d/m/Y h:i a", strtotime($userdetail["docissue"]));
        
        $out->entry->person->document->dateexpiration = new stdClass();
        $out->entry->person->document->dateexpiration->date = date("Y-m-d H:i", strtotime($userdetail["docexpiry"]));
        $out->entry->person->document->dateexpiration->formatted = date("d/m/Y h:i a", strtotime($userdetail["docexpiry"]));
        
        $out->entry->person->gender = $userdetail["gender"];
        
        $out->entry->person->maritalstatus = new stdClass();
        $out->entry->person->maritalstatus = validateMarital($userdetail["maritalstatus"], strtoupper($userdetail["gender"]));
        
        $out->entry->person->birthdate = new stdClass();
        $out->entry->person->birthdate->date = date("Y-m-d H:i", strtotime($userdetail["birthdate"]));
        $out->entry->person->birthdate->formatted = date("d/m/Y h:i a", strtotime($userdetail["birthdate"]));
        
        $out->entry->person->birthcountry = new stdClass();
        $out->entry->person->birthcountry = getCountry($userdetail["birthcountryid"], $db);
        
        $out->entry->person->phone = $userdetail["phone"];
        
        $out->entry->person->country = new stdClass();
        $out->entry->person->country = getCountry($userdetail["countryid"], $db);
        
        $out->entry->person->region = new stdClass();
        $out->entry->person->region = getRegion($userdetail["regionid"], $db);
        
        $out->entry->person->city = new stdClass();
        $out->entry->person->city = getCity($userdetail["cityid"], $db);
        
        $out->entry->person->street = $userdetail["street"];
        $out->entry->person->home = $userdetail["domicile"];
        $out->entry->person->postalcode = $userdetail["postalcode"];
        $out->entry->person->profession = $userdetail["profession"];
        $out->entry->person->ocupation = $userdetail["ocupation"];
        $out->entry->person->politicalexposed = $userdetail["politicallyexposed"] == null ? null : (int)$userdetail["politicallyexposed"];
        
        $out->entry->person->affiliationbody = $userdetail["affiliationbody"];
        $out->entry->person->positionheld = $userdetail["positionheld"];
        $out->entry->person->pepcountryid = (int)$userdetail["pepcountryid"];
        $out->entry->person->peprelatedid = $userdetail["peprelatedid"];
        $out->entry->person->independentdealer = $userdetail["independentdealer"] == null ? null : (int)$userdetail["independentdealer"];
        $out->entry->person->company = $userdetail["company"];
        
        $out->entry->person->anualincome = new stdClass();
        $out->entry->person->anualincome->number = (float)$userdetail["anualincome"];
        $out->entry->person->anualincome->formatted = number_format($userdetail["anualincome"],2,",",".");
        
        $out->entry->person->patrimony = new stdClass();
        $out->entry->person->patrimony->number = (float)$userdetail["patrimony"];
        $out->entry->person->patrimony->formatted = number_format($userdetail["patrimony"],2,",",".");
        
        $out->entry->person->economicalactivity = $userdetail["economicactivity"];
        
        $out->entry->person->qtyoperationsmothly = $userdetail["qtymonthlyop"];
        
        $out->entry->person->amooperationsmonthly = new stdClass();
        $out->entry->person->amooperationsmonthly->number = $userdetail["amountmonthlyop"];
        //$out->entry->person->amooperationsmonthly->formatted = number_format($userdetail["amountmonthlyop"],2,",",".");
        
        $out->entry->person->preferoptype = new stdClass();
        $out->entry->person->preferoptype->id = $userdetail["prefertypeop"] == null ? null : (int)$userdetail["prefertypeop"];
        $out->entry->person->preferoptype->dsc = "";
        
        $out->entry->person->economicrelation = $userdetail["economicrelation"] == null ? null : (int)$userdetail["economicrelation"];
        
        $out->entry->person->american = $userdetail["american"] != null ? (int)$userdetail["american"] : null;
        $out->entry->person->venezuelan = $userdetail["venezuelan"] != null ? (int)$userdetail["venezuelan"] : null;
        
        //Consulta para obtener los documentos que ha subido el usuario 
        $sql = "SELECT * FROM useruploads".
        "       WHERE userid = ".$out->entry->id;
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
            
            
        while($uploadarr = $rs->fetch_assoc()){
            $upload = new stdClass();
            //Generamos el id de salida
            $upload->id = str_pad($uploadarr["prefuploadid"], 2, "0", STR_PAD_LEFT);
            
            //Consultamos los datos de cada tipo de documento
            $sql = "SELECT * FROM cmsprefuploads".
            "       WHERE id = ".$uploadarr["prefuploadid"];
            if (!$res=$db->query($sql))
                badEnd("500", array("msg"=>$db->error));
            
            $uploaddetail = $res->fetch_assoc();
            
            $upload->dsc = $uploaddetail["dsc"];
            
            //$extention = explode("/",$uploadarr["filetype"]);
            
            //Buscamos el archivo para obtener su nombre y extension
            $filestest = glob("../uploads/users/".$out->entry->id."/".$upload->id.".{jpg,png,jpeg}", GLOB_BRACE);
            
            //El primer resultado
            $info = pathinfo($filestest[0]);
            
            //Url dentro de la carpeta api
            $upload->url = "./api/uploads/users/".$out->entry->id."/".$info["basename"];
            
            $upload->level = new stdClass();
            $upload->level->id = (int)$uploaddetail["level"] == null ? 1 : $uploaddetail["level"];
            $upload->level->dsc = "Nivel ".$upload->level->id;
            
            $upload->validated = (int)$uploadarr["validated"];
            
            $uploads[] = $upload;
        }
        
        $out->entry->person->uploads = $uploads;
    }else if($out->entry->type->id == 2){
        
        $out->entry->company = new stdClass();
        
        $out->entry->company->step = (int)$userdetail["step"];
        $out->entry->company->name = $userdetail["name"];
        $out->entry->company->comercialname = $userdetail["comercialname"];
        
        $out->entry->company->datecreated = new stdClass();
        $out->entry->company->datecreated->date = date("Y-m-d H:i", strtotime($userdetail["creationdate"]));
        $out->entry->company->datecreated->formatted = date("d/m/Y h:i a", strtotime($userdetail["creationdate"]));
        
        $out->entry->company->document = new stdClass();
        $out->entry->company->document->dsc = $userdetail["doc"];
        
        $out->entry->company->document->country = new stdClass();
        $out->entry->company->document->country = getCountry($userdetail["doccountryid"], $db);
        
        $out->entry->company->document->region = new stdClass();
        $out->entry->company->document->region = getRegion($userdetail["docregionid"], $db);
        
        $out->entry->company->document->city = new stdClass();
        $out->entry->company->document->city = getCity($userdetail["doccityid"], $db);
        
        $out->entry->company->document->postalcode = $userdetail["postalcode"];
        
        $out->entry->company->type = new stdClass();
        $out->entry->company->type = getCompanyType($userdetail["ctype"]);
        
        $out->entry->company->website = $userdetail["website"];
        $out->entry->company->branchoffices = $userdetail["branchoffices"] == null ? null : (int)$userdetail["branchoffices"];
        $out->entry->company->partnersnumber = (int)$userdetail["partners"];
        
        $out->entry->company->venezuelan = $userdetail["venezuelan"] != null ? (int)$userdetail["venezuelan"] : null;
        
        //Consulta para obtener socios
        $sql = "SELECT * FROM usercompanypartners".
        "       WHERE companyid = ".$out->entry->id;
        if (!$partnerrow=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
            
        while($partnerdata = $partnerrow->fetch_assoc()){
            $partner = new stdClass();
            $partner->id = (int)$partnerdata["id"];
            $partner->name = $partnerdata["name"];
            $partner->document = $partnerdata["doc"];
            $partner->phone = $partnerdata["phone"];
            $partner->legalrep = (int)$partnerdata["legalrep"];
            $partner->politicalexposed = (int)$partnerdata["politicallyexposed"];
            $partner->affiliationbody = $partnerdata["affiliationbody"];
            $partner->positionheld = $partnerdata["positionheld"];
            $partner->pepcountryid = (int)$partnerdata["pepcountryid"];
            $partner->peprelatedid = $partnerdata["peprelatedid"];
            
            $partners[] = $partner;
        }
        
        $out->entry->company->partners = $partners;
        $out->entry->company->phone = $userdetail["phone"];
        
        $out->entry->company->country = new stdClass();
        $out->entry->company->country = getCountry($userdetail["countryid"], $db);
        
        $out->entry->company->region = new stdClass();
        $out->entry->company->region = getRegion($userdetail["regionid"], $db);
        
        $out->entry->company->city = new stdClass();
        $out->entry->company->city = getCity($userdetail["cityid"], $db);
        
        $out->entry->company->street = $userdetail["street"];
        $out->entry->company->home = $userdetail["domicile"];
        $out->entry->company->independentdealer = $userdetail["independentdealer"] == null ? null : (int)$userdetail["independentdealer"];
        $out->entry->company->politicalexposed = $userdetail["politicallyexposed"] == null ? null : (int)$userdetail["politicallyexposed"];
        
        $out->entry->company->anualincome = new stdClass();
        $out->entry->company->anualincome->number = (float)$userdetail["anualincome"];
        $out->entry->company->anualincome->formatted = number_format($userdetail["anualincome"],2,",",".");
        
        $out->entry->company->patrimony = new stdClass();
        $out->entry->company->patrimony->number = (float)$userdetail["patrimony"];
        $out->entry->company->patrimony->formatted = number_format($userdetail["patrimony"],2,",",".");
        
        $out->entry->company->economicalactivity = $userdetail["economicactivity"];
        $out->entry->company->qtyoperationsmothly = $userdetail["qtymonthlyop"];
        
        $out->entry->company->amooperationsmonthly = new stdClass();
        $out->entry->company->amooperationsmonthly->number = $userdetail["amountmontlyop"];
        //$out->entry->company->amooperationsmonthly->formatted = number_format($out->entry->company->amooperationsmonthly->number,2,",",".");
        
        $out->entry->company->preferoptype = new stdClass();
        $out->entry->company->preferoptype->id = $userdetail["prefertypeop"] == null ? null : (int)$userdetail["prefertypeop"];
        $out->entry->company->preferoptype->dsc = "";
        
        $out->entry->company->economicrelation = $userdetail["economicrelation"] == null ? null : (int)$userdetail["economicrelation"];
        
        //Consulta para obtener los documentos que ha subido el usuario 
        $sql = "SELECT * FROM useruploads".
        "       WHERE userid = ".$out->entry->id;
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
            
            
        while($uploadarr = $rs->fetch_assoc()){
            $upload = new stdClass();
            //Generamos el id de salida
            $upload->id = str_pad($uploadarr["prefuploadid"], 2, "0", STR_PAD_LEFT);
            
            //Consultamos los datos de cada tipo de documento
            $sql = "SELECT * FROM cmsprefuploads".
            "       WHERE id = ".$uploadarr["prefuploadid"];
            if (!$res=$db->query($sql))
                badEnd("500", array("msg"=>$db->error));
            
            $uploaddetail = $res->fetch_assoc();
            
            $upload->dsc = $uploaddetail["dsc"];
            
            //$extention = explode("/",$uploadarr["filetype"]);
            
            //Buscamos el archivo para obtener su nombre y extension
            $filestest = glob("../uploads/users/".$out->entry->id."/".$upload->id.".{jpg,png,jpeg}", GLOB_BRACE);
            
            //El primer resultado
            $info = pathinfo($filestest[0]);
            
            //Url dentro de la carpeta api
            $upload->url = "./api/uploads/users/".$out->entry->id."/".$info["basename"];
            
            $upload->level = new stdClass();
            $upload->level->id = (int)$uploaddetail["level"] == null ? 1 : $uploaddetail["level"];
            $upload->level->dsc = "Nivel ".$upload->level->id;
            
            $upload->validated = (int)$uploadarr["validated"];
            
            $uploads[] = $upload;
        }
        
        $out->entry->company->uploads = $uploads;
    }
    
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
    
    
    /* UTILIDAD */
    
    /*  Funcion para validar el tipo de empresa, donde se recibe:
    *   -ctype: ID para determinar el tipo de empresa
    *   donde:
    *   1 = Privada
    *   2 = Gubernametal
    *   3 = Mixta
    */
    function getCompanyType($ctype){
        $type = new stdClass();
        $type->id = (int)$ctype;
        
        if($type->id == 1){
            $type->dsc = "Privada";
        }else if($type->id == 2){
            $type->dsc = "Gubernamental";
        }else if($type->id == 3){
            $type->dsc = "Mixta";
        }
        
        return $type;
    }
    
    /* Funcion para validar el tipo de documento que fue ingresado, donde:
    * 1 = CI
    * 2 = Passport
    * 3 = Driver license
    * el parametro typeid es el id del tipo de documento
    */
    function validateDoc($typeid){
        $type = new stdClass();
        $type->id = (int)$typeid;
        
        if($type->id == 1){
            $type->dsc = "Cedula";
        }else if($type->id == 2){
            $type->dsc = "Pasaporte";
        }else if($type->id == 3){
            $type->dsc = "Licencia de conducir";
        }else if($type->id == 0){
            $type->dsc = null;
        }
        
        return $type;
    }
    
    /* Funcion para validar el tipo de estado civil, donde:
    * 1 = Soltero/Soltera
    * 2 = Casado/Casada
    * 3 = Divorciado/Divorciada
    * 4 = Viudo/Viuda
    * la funciona recibe dos parametros que son:
    * -gender = genero de la persona que se esta consultando
    * -maritalid = id del estado civil que sera evaluado
    */
    function validateMarital($maritalid, $gender){
        //	1 Single | 2 Married | 3 Divorced | 4 Widower
        $maritalstatus = new stdClass();
        $maritalstatus->id = (int)$maritalid;
        
        if($maritalstatus->id == 1){
            $maritalstatus->dsc = $gender == "F" ? "Soltera" : "Soltero";
        }else if($maritalstatus->id == 2){
            $maritalstatus->dsc = $gender == "F" ? "Casada" : "Casado";
        }else if($maritalstatus->id == 3){
            $maritalstatus->dsc = $gender == "F" ? "Divorciada" : "Divorciado";
        }else if($maritalstatus->id == 4){
            $maritalstatus->dsc = $gender == "F" ? "Viuda" : "Viudo";
        }
        
        return $maritalstatus;
    }
    
    /* Funcion para obtener el pais por su id devolviendo un objeto:
    *  country: {
    *        id: id del pais,
    *        dsc: nombre del pais
    *   }
    *   
    *   Los parametros que recibe son countryid siendo el id del pais, y la conexion de la BD
    */
    function getCountry($countryid, $db){
        if($countryid != 0){
            $sql = "SELECT id, name".
            "       FROM countries".
            "       WHERE id = ".$countryid;
            if (!$rs=$db->query($sql))
                badEnd("500", array("msg"=>$db->error));
            
            $countrydata = $rs->fetch_assoc();
        
            $countryformatted = new stdClass();
            $countryformatted->id = (int)$countrydata["id"];
            $countryformatted->dsc = $countrydata["name"];
        }else{
            $countryformatted = new stdClass();
            $countryformatted->id = null;
            $countryformatted->dsc = null;
        }
        
        return $countryformatted;
    }
    
    /* Funcion para obtener el estado por su id devolviendo un objeto:
    *  region: {
    *        id: id del estado,
    *        dsc: nombre del estado
    *   }
    *   
    *   Los parametros que recibe son regionid siendo el id del estado, y la conexion de la BD
    */
    function getRegion($regionid, $db){
        if($regionid != 0){
            $sql = "SELECT id, name".
            "       FROM regions".
            "       WHERE id = ".$regionid;
            if (!$rs=$db->query($sql))
                badEnd("500", array("msg"=>$db->error));
            
            $regiondata = $rs->fetch_assoc();
        
            $regionformatted = new stdClass();
            $regionformatted->id = (int)$regiondata["id"];
            $regionformatted->dsc = $regiondata["name"];
        }else{
            $regionformatted = new stdClass();
            $regionformatted->id = null;
            $regionformatted->dsc = null;
        }
        
        return $regionformatted;
    }
    
    /* Funcion para obtener la ciudad por su id devolviendo un objeto:
    *  region: {
    *        id: id de la ciudad,
    *        dsc: nombre de la ciudad
    *   }
    *   
    *   Los parametros que recibe son cityid siendo el id de la ciudad, y la conexion de la BD
    */
    function getCity($cityid, $db){
        if($cityid != 0){
            $sql = "SELECT id, name".
            "       FROM cities".
            "       WHERE id = ".$cityid;
            if (!$rs=$db->query($sql))
                badEnd("500", array("msg"=>$db->error));
            
            $citydata = $rs->fetch_assoc();
        
            $cityformatted = new stdClass();
            $cityformatted->id = (int)$citydata["id"];
            $cityformatted->dsc = $citydata["name"];
        }else{
            $cityformatted = new stdClass();
            $cityformatted->id = null;
            $cityformatted->dsc = null;
        }
        
        return $cityformatted;
    }
?>
