WS_waitscreen = true;

window.onload = function(){
    
    // Call Entry
    getEntry(getParameterByName('sessionid'))
    
    // Later
    document.getElementById('later-button').addEventListener("click", function(){
       gotoPage('dashboard','home', { 'sessionid' : getParameterByName('sessionid') })
        
    });
    
    // Go to Register Residence Data
    document.getElementById('previous-button').addEventListener("click", function(){
        gotoPage('register','regCompanyRes',{ 'sessionid' : getParameterByName('sessionid') })
    });
    
    // Go to Register Images
    document.getElementById('next-button').addEventListener("click", function(){
        //gotoPage('register','regPersonImg','');
        verifyData()
    });
    
    // Remove red errors 
    document.getElementsByTagName('body')[0].addEventListener("click", function(){
        if (document.getElementById('economic').value !== ''){
            noError('economic','eeconomic')
            document.getElementById('eeconomic').style.display = 'none'
        }
        if (document.getElementById('politician').value !== ''){
            noError('politician','epolitician')
            document.getElementById('epolitician').style.display = 'none'
        }
    }); 
    
    //Funcion en el main para dar formato a campos
    var fields = ["income", "heritage"];
    var format = ["amount", "amount"];
    formatFields2(fields,format);
    
}


function verifyData(){
    var economicact = document.getElementById('economic');
    var anualincome = document.getElementById('income');
    var patrimony = document.getElementById('heritage');
    var politicalexp = document.getElementById('politician');
    var req = {
        "sessionid" : getParameterByName('sessionid'),
        "economicact": economicact.value,
        "anualincome": anualincome.getAttribute("data-amount"),
        "patrimony" : patrimony.getAttribute("data-amount"),
        'politicalexp' : politicalexp.value,
        "step" : 4
    }
    console.log()
    if( economicact.value=='' || politicalexp.value==''){
        if (economicact.value==''){
            error('economic','eeconomic','Seleccione una actividad.');
            document.getElementById('eeconomic').style.display = 'block'
        }
        if (politicalexp.value==''){
            error('politician','epolitician','Seleccione una opción.');
            document.getElementById('epolitician').style.display = 'block'
        }
        return;
    }else{
        updateCompany(req)
    }

    console.log(req)


}

function updateCompany(req){
    callWS("POST", "users/updatecompany", req, response);
    console.log(req)
    console.log(status)
    function response(status, rsp){
        switch(status){
            case 200:
                // Ok
                gotoPage('register','regCompanyImg',{ 'sessionid' : getParameterByName('sessionid') })
                break;
            case 204:
                break;
            case 400:
                // Parametros incorrectos
                break;
            case 500:
                // Error
                break;
            default:
                break;
        }
        console.log(status)
        console.log(rsp)
    }  
}
    
function getEntry(sessionid){
    console.log('entry')
    callWS("GET", "users/entry", { 'sessionid' : sessionid}, response);
        
    function response(status, rsp){
        switch(status){
            case 200:
                console.log(JSON.parse(rsp))
                document.getElementById('economic').value = JSON.parse(rsp).entry.company.economicalactivity
                var val = (Math.round((JSON.parse(rsp).entry.company.anualincome.number)*100)/100).toFixed(2);
                document.getElementById('income').value = val;//JSON.parse(rsp).entry.company.amooperationsmonthly.number
                document.getElementById('income').dispatchEvent(new Event("keyup"));
                var val = (Math.round((JSON.parse(rsp).entry.company.patrimony.number)*100)/100).toFixed(2);
                document.getElementById('heritage').value = val;
                document.getElementById('heritage').dispatchEvent(new Event("keyup"));
                document.getElementsByClassName('pageCnt')[0].style.visibility="visible"
                if (JSON.parse(rsp).entry.company.politicalexposed == null){
                    document.getElementById('politician').value = ''
                }else{
                    document.getElementById('politician').value = JSON.parse(rsp).entry.company.politicalexposed;   
                }
                // Window Load
                var waitScreen = document.getElementById("waitScreen");
                document.body.removeChild(waitScreen);
                WS_waitscreen = false;
                break;
            case 204:
                break;
            case 400:
                // Parametros incorrectos
                break;
            case 500:
                // Error
                break;
            default:
                break;
        }
        //console.log(status)
        //console.log(rsp)
    }    
}
