WS_waitscreen = true;

window.onload = function(){
    
    // Call Entry
    getOcupations()
    
    getCountries()
    
    // Go to Register Residence Data
    document.getElementById('previous-button').addEventListener("click", function(){
        gotoPage('register','regPersonRes',{ 'sessionid' : getParameterByName('sessionid') })
    });
    
    // Go to Register Images
    document.getElementById('next-button').addEventListener("click", function(){
        //gotoPage('register','regPersonImg','');
        verifyData()
    });
    
    // Remove red errors 
    document.getElementsByTagName('body')[0].addEventListener("click", function(){
        if (document.getElementById('economic').value !== ''){
            noError('economic','eeconomic')
            document.getElementById('eeconomic').style.display = 'none'
        }
        if (document.getElementById('independent').value !== ''){
            noError('independent','eindependent')
            document.getElementById('eindependent').style.display = 'none'
        }
        if (document.getElementById('politician').value !== ''){
            noError('politician','epolitician')
            document.getElementById('epolitician').style.display = 'none'
        }
        if (document.getElementById('profession').value !== ''){
            noError('profession','eprofession')
            document.getElementById('eprofession').style.display = 'none'
        }
        if (document.getElementById('polName').value !== ''){
            noError('polName','epolName')
            document.getElementById('epolName').style.display = 'none'
        }
        if (document.getElementById('polPosition').value !== ''){
            noError('polPosition','epolPosition')
            document.getElementById('epolPosition').style.display = 'none'
        }
        if (document.getElementById('polCountry').value !== ''){
            noError('polCountry','epolCountry')
            document.getElementById('epolCountry').style.display = 'none'
        }
        if (document.getElementById('polDocument').value !== ''){
            noError('polDocument','epolDocument')
            document.getElementById('epolDocument').style.display = 'none'
        }
    });
    
    // Later
    document.getElementById('later-button').addEventListener("click", function(){
       gotoPage('dashboard','home', { 'sessionid' : getParameterByName('sessionid') })
        
    });
    
    //Funcion en el main para dar formato a campos
    var fields = ["income", "heritage"];
    var format = ["amount", "amount"];
    formatFields2(fields,format);
    
    // Persona Politicamente Expuesta
    document.getElementById('politician').addEventListener("change", function(){
        if (document.getElementById('politician').value == 1){
            addPolitician()
        }
        else{
            deletePolitician()
        }
    }); 
}
var occupations;


function verifyData(){
    var ocupation = document.getElementById('occupation');
    var economicact = document.getElementById('economic');
    var politicalexp = document.getElementById('politician');
    var indepmerch = document.getElementById('independent');
    var company = document.getElementById('company');
    var anualincome = document.getElementById('income');
    var patrimony = document.getElementById('heritage');
    var profession = document.getElementById('profession');
    var affiliationbody = document.getElementById('polName');
    var positionheld = document.getElementById('polPosition');
    var pepcountryid = document.getElementById('polCountry');
    var peprelatedid = document.getElementById('polDocument');
    var req = {
        "sessionid" : getParameterByName('sessionid'),
        "ocupation" : ocupation.value,
        "economicact": economicact.value,
        "politicalexp" : politicalexp.value,
        "indepmerch": indepmerch.value,
        "company" : capitalize(company.value),
        "anualincome": anualincome.getAttribute("data-amount"),
        "patrimony" : patrimony.getAttribute("data-amount"),
        "profession" : capitalize(profession. value),
        'affiliationbody' : "",
        "positionheld" : "",
        "pepcountryid": null,
        "peprelatedid" : null,
        "step" : 3
    }
    
    if( economicact.value=='' || indepmerch.value=='' || politicalexp.value=='' ){
        if (economicact.value=='' || profession.value==''){
            error('economic','eeconomic','Seleccione una actividad.');
            document.getElementById('eeconomic').style.display = 'block'
        }
        if (indepmerch.value==''){
            error('independent','eindependent','Seleccione una opción.');
            document.getElementById('eindependent').style.display = 'block'
        }
        if (politicalexp.value==''){
            error('politician','epolitician','Seleccione una opción.');
            document.getElementById('epolitician').style.display = 'block'
        }
        if (profession.value==''){
            error('profession','eprofession','Introduzca una profesión.');
            document.getElementById('eprofession').style.display = 'block'
        }
        if( politicalexp.value==1 ){
            if( affiliationbody.value=='' || positionheld.value=='' || pepcountryid.value=='' || peprelatedid.value=='' ){
                if (affiliationbody.value==''){
                    error('polName','epolName','Introduzca un nombre.');
                    document.getElementById('epolName').style.display = 'block'
                }
                if (positionheld.value==''){
                    error('polPosition','epolPosition','Introduzca un cargo.');
                    document.getElementById('epolPosition').style.display = 'block'
                }
                if (pepcountryid.value==''){
                    error('polCountry','epolCountry','Seleccione un país.');
                    document.getElementById('epolCountry').style.display = 'block'
                }
                if (peprelatedid.value==''){
                    error('polDocument','epolDocument','Introduzca una identificación.');
                    document.getElementById('epolDocument').style.display = 'block'
                }
                return;
            }
        }
        return;
    }
    
    if( politicalexp.value==1 ){
        if( affiliationbody.value=='' || positionheld.value=='' || pepcountryid.value=='' || peprelatedid.value=='' ){
            if (affiliationbody.value==''){
                error('polName','epolName','Introduzca un nombre.');
                document.getElementById('epolName').style.display = 'block'
            }
            if (positionheld.value==''){
                error('polPosition','epolPosition','Introduzca un cargo.');
                document.getElementById('epolPosition').style.display = 'block'
            }
            if (pepcountryid.value==''){
                error('polCountry','epolCountry','Seleccione un país.');
                document.getElementById('epolCountry').style.display = 'block'
            }
            if (peprelatedid.value==''){
                error('polDocument','epolDocument','Introduzca una identificación.');
                document.getElementById('epolDocument').style.display = 'block'
            }
            return;
        }
        else{
            var req = {
                "sessionid" : getParameterByName('sessionid'),
                "ocupation" : ocupation.value,
                "economicact": economicact.value,
                "politicalexp" : politicalexp.value,
                "indepmerch": indepmerch.value,
                "company" : capitalize(company.value),
                "anualincome": anualincome.getAttribute("data-amount"),
                "patrimony" : patrimony.getAttribute("data-amount"),
                "profession" : capitalize(profession. value),
                'affiliationbody' : capitalize(affiliationbody.value),
                "positionheld" : capitalize(positionheld.value),
                "pepcountryid": pepcountryid.value,
                "peprelatedid" : peprelatedid.value,
                "step" : 3
            }
            updatePerson(req)
        }
    }else{
        updatePerson(req)
    }

    console.log(req)

}

function updatePerson(req){
    callWS("POST", "users/updateperson", req, response);
    console.log(req)
    console.log(status)
    function response(status, rsp){
        switch(status){
            case 200:
                // Ok
                gotoPage('register','regPersonImg',{ 'sessionid' : getParameterByName('sessionid') })
                break;
            case 204:
                break;
            case 400:
                // Parametros incorrectos
                break;
            case 500:
                // Error
                break;
            default:
                break;
        }
        console.log(status)
        console.log(rsp)
    }  
}
    
function getEntry(sessionid){
    console.log('entry')
    callWS("GET", "users/entry", { 'sessionid' : sessionid}, response);
        
    function response(status, rsp){
        switch(status){
            case 200:
                console.log(JSON.parse(rsp))
                document.getElementById('economic').value = JSON.parse(rsp).entry.person.economicalactivity;
                if (JSON.parse(rsp).entry.person.independentdealer == null){
                    document.getElementById('independent').value = ''
                }else{
                    document.getElementById('independent').value = JSON.parse(rsp).entry.person.independentdealer;   
                }
                document.getElementById('occupation').value = JSON.parse(rsp).entry.person.ocupation;
                document.getElementById('company').value = JSON.parse(rsp).entry.person.company;
                var val = (Math.round((JSON.parse(rsp).entry.person.anualincome.number)*100)/100).toFixed(2);
                document.getElementById('income').value = val;//JSON.parse(rsp).entry.company.amooperationsmonthly.number
                document.getElementById('income').dispatchEvent(new Event("keyup"));
                var val = (Math.round((JSON.parse(rsp).entry.person.patrimony.number)*100)/100).toFixed(2);
                document.getElementById('heritage').value = val;
                document.getElementById('heritage').dispatchEvent(new Event("keyup"));
                document.getElementById('profession').value = JSON.parse(rsp).entry.person.profession
                if (JSON.parse(rsp).entry.person.politicalexposed == null){
                    document.getElementById('politician').value =''
                }else{
                    document.getElementById('politician').value = JSON.parse(rsp).entry.person.politicalexposed;   
                }
                document.getElementById('polName').value =  JSON.parse(rsp).entry.person.affiliationbody; 
                document.getElementById('polPosition').value = JSON.parse(rsp).entry.person.positionheld; 
                if (document.getElementById('polCountry').value = JSON.parse(rsp).entry.person.pepcountryid == 0){
                    document.getElementById('polCountry').value = ''
                }else{
                    document.getElementById('polCountry').value = JSON.parse(rsp).entry.person.pepcountryid
                }; 
                document.getElementById('polDocument'). value = JSON.parse(rsp).entry.person.peprelatedid; 
                if(document.getElementById('politician').value == 1){
                    addPolitician()
                }
                document.getElementsByClassName('pageCnt')[0].style.visibility="visible"
                // Window Load
                var waitScreen = document.getElementById("waitScreen");
                document.body.removeChild(waitScreen);
                WS_waitscreen = false;
                break;
            case 204:
                break;
            case 400:
                // Parametros incorrectos
                break;
            case 500:
                // Error
                break;
            default:
                break;
        }
        //console.log(status)
        //console.log(rsp)
    }    
}

function addOptions(domElement, array, bool) {
    var selector = document.getElementsByName(domElement)[0];
    var firstOopcion = document.createElement("option");
    firstOopcion.disabled = true;
    firstOopcion.text = 'Selecciona'
    firstOopcion.value =''
    firstOopcion.selected = true
    selector.add(firstOopcion)
    for (countrie in array.records) {
        if (array.records[countrie].id > 0){
            var opcion = document.createElement("option");
            opcion.text = array.records[countrie].dsc;
            opcion.value = array.records[countrie].id
            selector.add(opcion);
        }
    }
    // First Time
    getEntry(getParameterByName('sessionid'))
}

    
function getOcupations(){
    
    var req = {
        "sessionid": getParameterByName('sessionid')
    }
        
    callWS("GET", "additional/ocupations", req, response);
        
    function response(status, rsp){
        switch(status){
            case 200:
                occupations = JSON.parse(rsp);
                addOptions("occupation", occupations)
                //getEntry(getParameterByName('sessionid'))
                break;
            case 204:
                break;
            case 400:
                // Parametros incorrectos
                break;
            case 500:
                // Error
                break;
            default:
                break;
        }
    }    
}

function addPolitician(){
    document.getElementById('politicianForm').style.display = 'block'
}

function deletePolitician(){
    document.getElementById('politicianForm').style.display = 'none'
}
var countries = '';
function getCountries(){
    var req = {
        "sessionid": getParameterByName('sessionid')
    }
        
    callWS("GET", "demographics/countries", req, response);
        
    function response(status, rsp){
        switch(status){
            case 200:
                countries = JSON.parse(rsp);
                addOptions("polCountry", countries,true)
                //getEntry(getParameterByName('sessionid'))
                break;
            case 204:
                break;
            case 400:
                // Parametros incorrectos
                break;
            case 500:
                // Error
                break;
            default:
                break;
        }
    }    
}

