WS_waitscreen = true;

window.onload = function(){
    
    getCountries(true)
    // Call Entry
    getEntry(getParameterByName('sessionid'))
    
    // Go to back to Basic Data
    document.getElementById('previous-button').addEventListener("click", function(){
        gotoPage('register','regPerson',{ 'sessionid' : getParameterByName('sessionid') })
    });
    
    // Go to Register Profesional Information
    document.getElementById('next-button').addEventListener("click", function(){
        //gotoPage('register','regPersonInf',{ 'sessionid' : getParameterByName('sessionid') })
        verifyData()
    });
    
    // Later
    document.getElementById('later-button').addEventListener("click", function(){
       gotoPage('dashboard','home', { 'sessionid' : getParameterByName('sessionid') })
        
    });

    
    // Change values where
    document.getElementById('country').addEventListener("change", function(){
        if (idCountry != document.getElementById('country').value){
            idCountry = document.getElementById('country').value
            getRegions('','')
            removeOptions('city')
            var selector = document.getElementsByName('city')[0];
            var firstOopcion = document.createElement("option");
            firstOopcion.disabled = true;
            firstOopcion.text = 'Selecciona'
            firstOopcion.value =''
            firstOopcion.selected = true
            selector.add(firstOopcion)
        }
    });
    document.getElementById('state').addEventListener("change", function(){
        if (idState != document.getElementById('state').value){
            idState = document.getElementById('country').value
            getCities('','')
        }
    });
    
    // Remove red errors 
    document.getElementsByTagName('body')[0].addEventListener("click", function(){
        if (document.getElementById('country').value !== ''){
            noError('country','ecountry')
            document.getElementById('ecountry').style.display = 'none'
        }
        if (document.getElementById('state').value !== ''){
            noError('state','estate')
            document.getElementById('estate').style.display = 'none'
        }
        if (document.getElementById('city').value !== ''){
            noError('city','ecity')
            document.getElementById('ecity').style.display = 'none'
        }
        if (document.getElementById('street').value !== ''){
            noError('street','estreet')
            document.getElementById('estreet').style.display = 'none'
        }
        if (document.getElementById('postalCode').value !== ''){
            noError('postalCode','epostalCode')
            document.getElementById('epostalCode').style.display = 'none'
        }
    }); 
}

var idCountry = '';
var idState = '';
var idCity = ''

function addOptions(domElement, array, bool) {
    var selector = document.getElementsByName(domElement)[0];
    var firstOopcion = document.createElement("option");
    firstOopcion.disabled = true;
    firstOopcion.text = 'Selecciona'
    firstOopcion.value =''
    firstOopcion.selected = true
    selector.add(firstOopcion)
    for (countrie in array.records) {
        if (array.records[countrie].id > 0){
            var opcion = document.createElement("option");
            opcion.text = array.records[countrie].dsc;
            opcion.value = array.records[countrie].id
            selector.add(opcion);
        }
    }
    // First Time
    if(bool == true && domElement == "country"){
        getEntry(getParameterByName('sessionid'))
    }
}

function getCountries(bool){
    var req = {
        "sessionid": getParameterByName('sessionid')
    }
        
    callWS("GET", "demographics/countries", req, response);
        
    function response(status, rsp){
        switch(status){
            case 200:
                countries = JSON.parse(rsp);
                console.log('getcountry')
                addOptions("country", countries,bool)
                //getEntry(getParameterByName('sessionid'))
                break;
            case 204:
                break;
            case 400:
                // Parametros incorrectos
                break;
            case 500:
                // Error
                break;
            default:
                break;
        }
    }    
}

function getRegions(selR,selC){
    removeOptions('state')
    var req = {
        "sessionid": getParameterByName('sessionid'),
        "countryid": document.getElementsByName('country')[0].value
    }
     if ( req.countryid != ''){
        callWS("GET", "demographics/regions", req, response);
        function response(status, rsp){
            switch(status){
                case 200:
                    states = JSON.parse(rsp);
                    addOptions("state", states,false);
                    if(selR!=''){
                        setTimeout(function(){ document.getElementById('state').value = selR}, 500);
                        if(selC!=''){
                            setTimeout(function(){ getCities(selR,selC)}, 500);
                        }
                    }
                    //Timeout 500
                    //sel esta es la seleccionada setear
                    //getEntry(getParameterByName('sessionid'))
                    break;
                case 204:
                    break;
                case 400:
                    // Parametros incorrectos
                    break;
                case 500:
                    // Error
                    break;
                default:
                    break;
            }
        }     
    }
        
}

function removeOptions(selectElement) {
    x = document.getElementById(selectElement)
    var i, L = x.options.length - 1;
    for(i = L; i >= 0; i--) {
       x.remove(i);
    }
}

function getCities(selR,selC){
    removeOptions('city')
    var req = {
        "sessionid": getParameterByName('sessionid'),
        "regionid": document.getElementsByName('state')[0].value
    }
     if ( req.regionid != ''){
        callWS("GET", "demographics/cities", req, response);
        function response(status, rsp){
            switch(status){
                case 200:
                    cities = JSON.parse(rsp);
                    addOptions("city", cities,false)
                    if(selC!=''){
                        setTimeout(function(){ document.getElementById('city').value = selC}, 500);
                    }
                    break;
                case 204:
                    break;
                case 400:
                    // Parametros incorrectos
                    break;
                case 500:
                    // Error
                    break;
                default:
                    break;
            }
        }     
    }
        
}




function verifyData(){
    var countryid = document.getElementById('country');
    var stateid = document.getElementById('state');
    var cityid = document.getElementById('city');
    var street = document.getElementById('street');
    var domicile = document.getElementById('house');
    var postalcode = document.getElementById('postalCode');
    var req = {
        "sessionid" : getParameterByName('sessionid'),
        "countryid" : countryid.value,
        "stateid": stateid.value,
        "cityid" : cityid. value,
        "street": capitalize(street.value),
        "domicile" : capitalize(domicile. value),
        "postalcode": postalcode.value,
        "step" : 2
    }

    
    if( countryid.value=='' || stateid.value=='' || cityid.value =='' ||
        street.value=='' || postalcode.value==''){
         
        if (countryid.value==''){
            error('country','ecountry','Seleccione un pais.');
            document.getElementById('ecountry').style.display = 'block'
        }
        if (stateid.value==''){
            error('state','estate','Seleccione un estado.');
            document.getElementById('estate').style.display = 'block'
        }
        if (cityid.value==''){
            error('city','ecity','Seleccione una ciudad.');
            document.getElementById('ecity').style.display = 'block'
        }
        if (street.value==''){
            error('street','estreet','Introduzca una dirección.');
            document.getElementById('estreet').style.display = 'block'
        }
        if (postalcode.value==''){
            error('postalCode','epostalCode','Introduzca un código postal.');
            document.getElementById('epostalCode').style.display = 'block'
        }
        
        return;
        
    }else{
        updatePerson(req)    
    }


}

function updatePerson(req){
    callWS("POST", "users/updateperson", req, response);
    function response(status, rsp){
        switch(status){
            case 200:
                // Ok
                gotoPage('register','regPersonInf',{ 'sessionid' : getParameterByName('sessionid') })
                break;
            case 204:
                break;
            case 400:
                // Parametros incorrectos
                break;
            case 500:
                // Error
                break;
            default:
                break;
        }
    }  
}

function getEntry(sessionid){
    console.log('entry')
    callWS("GET", "users/entry", { 'sessionid' : sessionid}, response);
        
    function response(status, rsp){
        switch(status){
            case 200:
                console.log(JSON.parse(rsp))
                
                if(  JSON.parse(rsp).entry.person.country.id == null){
                    document.getElementById('country').value = ''
                }else{
                    document.getElementById('country').value = JSON.parse(rsp).entry.person.country.id;
                }
                
                if(JSON.parse(rsp).entry.person.region.id == null){
                    document.getElementById('state').value = ''
                }else{
                    document.getElementById('state').value = JSON.parse(rsp).entry.person.region.id
                }
                
                if(JSON.parse(rsp).entry.person.city.id == null){
                    document.getElementById('city').value = ''
                }else{
                    document.getElementById('city').value = JSON.parse(rsp).entry.person.city.id
                }
                document.getElementById('street').value = JSON.parse(rsp).entry.person.street
                document.getElementById('house').value = JSON.parse(rsp).entry.person.home
                document.getElementById('postalCode').value = JSON.parse(rsp).entry.person.postalcode
                
                
                if(JSON.parse(rsp).entry.person.region.id!='' && JSON.parse(rsp).entry.person.region.id!=null ){
                    getRegions(JSON.parse(rsp).entry.person.region.id,JSON.parse(rsp).entry.person.city.id)
                }

                /*if(JSON.parse(rsp).entry.person.region.id!=''){
                    getRegions(country);
                    setTimeout(function(){ document.getElementById('state').value = JSON.parse(rsp).entry.person.region.id;
                    getCities(regions);}, 2000);
                }
                
                if(JSON.parse(rsp).entry.person.city.id!=''){
                    setTimeout(function(){ document.getElementById('city').value = JSON.parse(rsp).entry.person.city.id}, 4000);
                }*/
                document.getElementsByClassName('pageCnt')[0].style.visibility="visible"
                // Window Load
                var waitScreen = document.getElementById("waitScreen");
                document.body.removeChild(waitScreen);
                WS_waitscreen = false;

                break;
            case 204:
                break;
            case 400:
                // Parametros incorrectos
                break;
            case 500:
                // Error
                break;
            default:
                break;
        }
        //console.log(status)
        //console.log(rsp)
    }    
}



/* function drawSelect(select, read, rsp, selected, first = ""){
    //rsp - (array) Registros
    //select - donde se insertan las opciones
    //first - si no es vacoi crea un opcion sin value
    //selected - selecciona una opcin especifica
    //read - campo a partir del cual muestra el LBL
    select.innerHTML = "";
    var opt;
    if(first !== ""){
        opt = "";
        opt = document.createElement("option");
        opt.setAttribute("value", "");
        opt.innerHTML = first;
        select.appendChild(opt);
    }
    for(var i=0; i<rsp.length; i++){
        opt = document.createElement("option");
        opt.setAttribute("value", rsp[i].id);
        opt.innerHTML = rsp[i][read];
        if(selected !== null && selected !== "" && selected !== undefined){
            if(rsp[i].id == selected)
                opt.setAttribute("selected", "");
        }
        select.appendChild(opt);
    }
}*/
