<?php
// cms/api/currencies/entry

    header("Content-Type:application/json");
    include("../dbconn.php");
    include("../utils.php");
    
    // parametros obligatorios
    $parmsob = array("sessionid","id");
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    //Declaramos e inicializamos nuestras variables
    $out= new stdClass;
    $sessionid = $_GET["sessionid"];
    $id = $_GET["id"];
    
    //Validamos que la session del usuario sea valida para continuar
    isSessionValidCMS($db, $sessionid);
    
    //Consultamos los valores
    $sql = "SELECT * FROM currencies".
    "       WHERE id = ".$id;
    if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
    
    //Ordenamos los valores
    $row = $rs->fetch_assoc();
    
    //Retornamos 204 si no se encontro un registro
    if($row["id"] == null)
        badEnd("204", array("msg"=>"No se encuentra el registro"));
    
    $out->entry = new stdClass();
    $out->entry->id = (int)$row["id"];
    $out->entry->name = $row["name"];
    $out->entry->symbol = $row["symbol"];
    
    $out->entry->status = new stdClass();
    $out->entry->status->id = (int)$row["status"];
    $out->entry->status->dsc =  $record->status->id == 1 ? "Activo" : "Inactivo";
    
    //Retornamos los privilegios del usuario actual
    $access = new stdClass;
    $access->create = tienePrivilegio($db, $sessionid, 11);
    $access->read =   tienePrivilegio($db, $sessionid, 14);
    $access->update = tienePrivilegio($db, $sessionid, 12);
    $access->delete = tienePrivilegio($db, $sessionid, 13);
    $out->privileges = $access;
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>
