<?php
// cms/api/privileges/list

    header("Content-Type:application/json");
    include("../dbconn.php");
    include("../utils.php");
    
    // parametros obligatorios
    $parmsob = array("sessionid","offset","numofrec");
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    //Declaramos e inicializamos nuestras variables
    $out= new stdClass;
    $sessionid = $_GET["sessionid"];
    $offset = $_GET["offset"];
    $numofrec = $_GET["numofrec"];
    
    //Validamos que la session del usuario sea valida para continuar
    isSessionValidCMS($db, $sessionid);
    
    //En caso de que el filter sea enviado, se construye el query
    if(isset($_GET["filter"]) && $_GET["filter"] != ""){
        $filter = "WHERE (grp LIKE '".$_GET["filter"]."%' OR dsc LIKE '".$_GET["filter"]."%')";
    }
    
    //En caso de que el order sea enviado, se construye el query
    if(isset($_GET["order"]) && $_GET["order"] != ""){
        $order = " ORDER BY ".determinateOrder($_GET["order"]);
    }
    
    //Contamos los resultados total del query a ejecutar
    $sql = "SELECT COUNT(id) AS qty".
    "       FROM privileges".
    "       ".$filter;
    if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
            
    $total = $rs->fetch_assoc();
    
    //Retornamos el total de elementos resultantes del query
    $out->numofrecords = (int)$total["qty"];
    
    //Consultamos los registros
    $sql = "SELECT * FROM privileges".
    "       ".$filter.
    "       ".$order.
    "       LIMIT ".$offset.", ".$numofrec;
    if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
    
    //Ordenamos los valores
    while($row = $rs->fetch_assoc()){
        $record = new stdClass();
        $record->id = (int)$row["id"];
        $record->grp = ucfirst(strtolower($row["grp"]));
        $record->dsc = $row["dsc"]; 
        
        $records [] = $record;
    }
    
    $out->records = $records;
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
    
    /*  Funcion para determinar el orden de los resultados, donde:
    *   1 = grupo ASCENDENTE
    *   2 = descripcion ASCENDENTE
    *   -1 = grupo DESCENDENTE
    *   -2 = descripcion DESCENDENTE
    *   Y si el order es enviado si ser algunos de estos valores,
    *   Retornara un error para avisarle al desarrollador/@
    */
    function determinateOrder($order){
        $orderres = "";
        switch($order){
            case 1:
                $orderres = "grp ASC";
                break;
            case 2:
                $orderres = "dsc ASC";
                break;
            case -1:
                $orderres = "grp DESC";
                break;
            case -2:
                $orderres = "dsc DESC";
                break;
            default:
                badEnd("400", array("msg"=>"Order debe ser 1, 2, -1, o -2"));
                break;
        }
        
        return $orderres;
    }
    
?>
