<?php
// app/api/deposits/insert

    header("Content-Type:application/json");
    include("../dbconn.php");
    include("../utils.php");
    
    // parametros obligatorios
    $parmsob = array("sessionid","accountid","paymentdate","amount","paymentaccountid","paymentref");
    if (!parametrosValidos($_POST, $parmsob)){
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(",", $parmsob)));
    }
    
    $paymentfile = $_FILES["paymentfile"];
    
    if($paymentfile["name"] == null){
        badEnd("400", array("msg"=>"Parametros obligatorios paymentfile"));
    }
    
    //Definicion de variables e inicializacion
    $out = new stdClass;
    $sessionid = $_POST["sessionid"];
    $accountid = $_POST["accountid"];
    $paymentdate = $_POST["paymentdate"];
    $amount = $_POST["amount"];
    $paymentaccountid = $_POST["paymentaccountid"];
    $paymentref = $_POST["paymentref"];
    
    //Validamos la session
    $idUserSession = isSessionValid($db, $sessionid);
    //Validamos el si el usuario puede crear cuentas
    isLevelValid($db, $idUserSession);
    
    //Obtenemos la moneda en la cual se hace el deposito
    $sql = "SELECT * from accounts WHERE id = ".$accountid;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
    
    //Guardamos la data de la cuenta
    $accountdata = $rs->fetch_assoc();
    
    //validamos que exista
    if($accountdata["id"] == null){
        badEnd("500", array("msg"=>"Accountid invalido"));
    }
    
    //Obtenemos el nivel de usuario para determinar su fee
    $sql = "SELECT * FROM users WHERE sessionid = '".$sessionid."'";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
    
    //Guardamos la data de la cuenta
    $userdata = $rs->fetch_assoc();
    
    $level = 1;
    
    if($userdata["level"] == 0){
        $level = 1;
    }else{
        $level = $userdata["level"];
    }
    
    //Obtenemos el fee de cada operacion por la moneda de la cuenta
    $sql = "SELECT * FROM cmspreffees WHERE currencyid = ".$accountdata["currencyid"].
    "       AND levelid = ".$level.
    "       AND usertype = ".$userdata["type"];
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
    
    //Guardamos la data de la cuenta
    $fee = $rs->fetch_assoc();
    /*
    //Validamos que el monto sea mas que el minimo aceptado
    if($fee["minbalance"] > $amount){
        badEnd("403", array("msg"=>"Monto no autorizado"));
    }*/
    
    //Calculamos el monto real quitandole la comision
    if($fee["pctfeedeposits"] != null){
        if($fee["pctfeedeposits"] == 0){
            $realfee = $amount - ($amount - $fee["nmlfeedeposits"]);
            $realamount = $amount - $realfee;
        }else{
            $realfee = ($fee["pctfeedeposits"]*$amount)/100;
            $realamount = $amount - $realfee;
        }
    }else{
        $realfee = (2*$amount)/100;
        $realamount = $amount - $realfee;
    }
    
    
    $db->autocommit(FALSE);
        
    //insertamos la trasaccion del deposito
    $sql = "INSERT INTO transactions".
    "       (".
    "       datecreated, ".
    "       dsc, ".
    "       amount, ".
    "       amountghost, ".
    "       accountid, ".
    "       orderid, ".
    "       txid, ".
    "       accountorigin, ".
    "       accountdestination".
    "       )".
    "       VALUES(".
    "       NOW(), ".
    "       'Depósito', ".
    "       0, ".
    "       ".$amount.", ".
    "       ".$accountid.", ".
    "       NULL, ".
    "       NULL, ".
    "       NULL, ".
    "       ".$paymentaccountid.
    "       )";
    if (!$db->query($sql)){
        $error = $db->error;
        $db->rollback();
        $db->close();
        badEnd("500", array("msg"=>$error));
    }
    
    //Guardamos el id de la transaccion de deposito
    $txid = (int)$db->insert_id;
    $out->id = $txid;
    
    //Le colocamos a la primera transferencia el txid
    $sql = "UPDATE transactions SET".
    "       txid = ".$txid.
    "       WHERE id = ".$txid;
    if (!$db->query($sql)){
        $error = $db->error;
        $db->rollback();
        $db->close();
        badEnd("500", array("msg"=>$error));
    }
    
    //insertamos la comision del deposito
    $sql = "INSERT INTO transactions".
    "       (".
    "       datecreated, ".
    "       dsc, ".
    "       amount, ".
    "       amountghost, ".
    "       accountid, ".
    "       orderid, ".
    "       txid, ".
    "       accountorigin, ".
    "       accountdestination".
    "       )".
    "       VALUES(".
    "       NOW(), ".
    "       'Comisión de Depósito', ".
    "       0, ".
    "       -".$realfee.", ".
    "       ".$accountid.", ".
    "       NULL, ".
    "       ".$txid.", ".
    "       NULL, ".
    "       ".$paymentaccountid.
    "       )";
    if (!$db->query($sql)){
        $error = $db->error;
        $db->rollback();
        $db->close();
        badEnd("500", array("msg"=>$error));
    }
    
    //insertamos la comision del deposito
    $sql = "INSERT INTO transactions".
    "       (".
    "       datecreated, ".
    "       dsc, ".
    "       amount, ".
    "       amountghost, ".
    "       accountid, ".
    "       orderid, ".
    "       txid, ".
    "       accountorigin, ".
    "       accountdestination".
    "       )".
    "       VALUES(".
    "       NOW(), ".
    "       'Comisión de Depósito', ".
    "       0, ".
    "       ".$realfee.", ".
    "       ".$paymentaccountid.", ".
    "       NULL, ".
    "       ".$txid.", ".
    "       NULL, ".
    "       ".$paymentaccountid.
    "       )";
    if (!$db->query($sql)){
        $error = $db->error;
        $db->rollback();
        $db->close();
        badEnd("500", array("msg"=>$error));
    }
    
    //Obtenemos la extension de la imagen
    $ext = pathinfo($paymentfile['name'], PATHINFO_EXTENSION);
    
    //insertamos la comision del deposito
    $sql = "INSERT INTO deposits".
    "       (".
    "       paymentref, ".
    "       paymentaccountid, ".
    "       filetype, ".
    "       paymentdate, ".
    "       createddate, ".
    "       fee, ".
    "       transactionid, ".
    "       valid, ".
    "       amount ".
    "       )".
    "       VALUES(".
    "       '".$paymentref."', ".
    "       ".$paymentaccountid.", ".
    "       '".$paymentfile["type"]."', ".
    "       '".$paymentdate."', ".
    "       NOW(), ".
    "       ".$realfee.", ".
    "       ".$txid.", ".
    "       NULL, ".
    "       ".$amount." ".
    "       )";
    if (!$db->query($sql)){
        $error = $db->error;
        $db->rollback();
        $db->close();
        badEnd("500", array("msg"=>$error));
    }
    
    //Creamos la direccion del folder
    $urlfolder = "../uploads/payments";
        
    //Movemos el FILE del directorio temporal al del sistema para su uso
    if(!move_uploaded_file($paymentfile["tmp_name"], $urlfolder . "/" . $txid . "." . $ext)){
        $db->rollback();
        $db->close();
        badEnd("500", array("msg"=>"Error guardando la imagen"));
    }
    
    //auditoria
    setAudit($db, "OPERACIONES", $sessionid, "APP", "El usuario ".$userdata["id"]." agrego el deposito ".$out->id);
    
    $db->commit();
    $db->close();
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>
