<?php
// cms/api/operations/accept

    header("Content-Type:application/json");
    include("../dbconn.php");
    include("../utils.php");
    
    // parametros obligatorios
    $parmsob = array("sessionid","id");
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    //Declaramos e inicializamos nuestras variables
    $out= new stdClass;
    $sessionid = $_GET["sessionid"];
    $id = $_GET["id"];
    
    //Validamos que la session del usuario sea valida para continuar
    isSessionValidCMS($db, $sessionid);
    
    //Validamos que el usuario tenga privilegios
    if(!tienePrivilegio($db, $sessionid, 31))
        badEnd("403", array("msg"=>"No tiene Privilegios"));
    
    //Consultamos los datos del movimiento para saber si fue rechazado o actualizado
    $sql = "SELECT transactions.id AS transactionid, ".
    "       deposits.transactionid AS depositid, ".
    "       deposits.valid AS depositvalid, ".
    "       deposits.rejected AS depositrejected, ".
    "       withdrawals.transactionid AS withdrawalid, ".
    "       withdrawals.rejected AS withdrawrejected, ".
    "       withdrawals.valid AS withdrawvalid ".
    "       FROM transactions ".
    "       LEFT JOIN deposits ON transactions.id = deposits.transactionid".
    "       LEFT JOIN withdrawals ON transactions.id = withdrawals.transactionid".
    "       WHERE transactions.id = ".$id;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
    
    $row = $rs->fetch_assoc();
    $db->autocommit(FALSE);
    
    // 1 = DEPOSITO; 2 = RETIRO WN
    //Si el campo depositid es distinto a null significa que es un deposito
    if($row["depositid"] != null){
        //Colocamos la fechen nulo
        $sql = "UPDATE deposits SET".
        "       rejected = NULL, ".
        "       valid = NULL ".
        "       WHERE transactionid = ".$id;
        if (!$db->query($sql)){
            $error = $db->error;
            $db->rollback();
            $db->close();
            badEnd("500", array("msg"=>$error));
        }
    }else if($row["withdrawalid"] != null){
        //Colocamos la fecha en nulo
        $sql = "UPDATE withdrawals SET".
        "       rejected = NULL, ".
        "       valid = NULL ".
        "       WHERE transactionid = ".$id;
        if (!$db->query($sql)){
            $error = $db->error;
            $db->rollback();
            $db->close();
            badEnd("500", array("msg"=>$error));
        }
    }else{
        badEnd("500", array("msg"=>"La operacion es una transferencia"));
    }
    
    //Cambiamos los montos
    $sql = "UPDATE transactions SET".
    "       amountghost = amount + amountghost, ".
    "       amount = 0 ".
    "       WHERE txid = ".$id;
    if (!$db->query($sql)){
        $error = $db->error;
        $db->rollback();
        $db->close();
        badEnd("500", array("msg"=>$error));
    }
    
    $out->id = (int)$id;
    
    //auditoria
    setAudit($db, "OPERACIONES", $sessionid, "CMS", "Se revirtio el movimiento ".$out->id);
    
    $db->commit();
    $db->close();
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>
