WS_waitscreen = true;
var requiredLevelData = [];
var decimCoin = 2;
window.onload = function(){
    
    // Call Entry
    getEntry(getParameterByName('sessionid'))
    
    // Later
    document.getElementById('later-button').addEventListener("click", function(){
        document.getElementsByClassName('completeLater')[0].style.display = 'table'
    });
    
    document.getElementById('completeLaterAccept').addEventListener("click", function(){
        gotoPage('dashboard','home', { 'sessionid' : getParameterByName('sessionid') })
    });
    
    document.getElementById('completeLaterCancel').addEventListener("click", function(){
        document.getElementsByClassName('completeLater')[0].style.display = 'none'
    });
    
    // Go to Register Residence Data
    document.getElementById('previous-button').addEventListener("click", function(){
        gotoPage('register','regCompanyRes',{ 'sessionid' : getParameterByName('sessionid') })
    });
    
    // Go to Register Images
    document.getElementById('next-button').addEventListener("click", function(){
        //gotoPage('register','regPersonImg','');
        verifyData()
    });
    
    // Remove red errors 
    document.getElementsByTagName('body')[0].addEventListener("click", function(){
        if (document.getElementById('economic').value !== ''){
            noError('economic','eeconomic')
            document.getElementById('eeconomic').style.display = 'none'
        }
        if (document.getElementById('politician').value !== ''){
            noError('politician','epolitician')
            document.getElementById('epolitician').style.display = 'none'
        }
        if (document.getElementById('heritage').value !==''){
            noError('heritage','eheritage')
            document.getElementById('eheritage').style.display = 'none'
        }
        if (document.getElementById('income').value !==''){
            noError('income','eincome')
            document.getElementById('eincome').style.display = 'none'
        }
    }); 
    
    //Funcion en el main para dar formato a campos
    var fields = ["income", "heritage"];
    formatAmount(fields);
    /*
    var format = ["amount", "amount"];
    formatFields2(fields,format);*/
    
    
    //Mostrar HTML cargado
    esconderHTML(false);
}


function verifyData(){
    var economicact = document.getElementById('economic');
    var anualincome = document.getElementById('income');
    var patrimony = document.getElementById('heritage');
    var politicalexp = document.getElementById('politician');
    var req = {
        "sessionid" : getParameterByName('sessionid'),
        "economicact": economicact.value,
        "anualincome": anualincome.getAttribute("dataNumber"),
        "patrimony" : patrimony.getAttribute("dataNumber"),
        'politicalexp' : politicalexp.value,
        "step" : 4
    }
    if( (economicact.value=='' && requiredLevelData.includes(economicact.getAttribute('dataname'))) || (politicalexp.value=='' && requiredLevelData.includes(politicalexp.getAttribute('dataname'))) ||
        (anualincome.value=='' && requiredLevelData.includes(anualincome.getAttribute('dataname'))) || (patrimony.value=='' && requiredLevelData.includes(patrimony.getAttribute('dataname')))
    
    ){
        if (economicact.value=='' && requiredLevelData.includes(economicact.getAttribute('dataname'))){
            error('economic','eeconomic','Seleccione una actividad.');
            document.getElementById('eeconomic').style.display = 'block'
        }
        if (politicalexp.value=='' && requiredLevelData.includes(politicalexp.getAttribute('dataname'))){
            error('politician','epolitician','Seleccione una opción.');
            document.getElementById('epolitician').style.display = 'block'
        }
        if (patrimony.value=='' && requiredLevelData.includes(patrimony.getAttribute('dataname'))){
            error('heritage','eheritage','Introduzca un monto.');
            document.getElementById('eheritage').style.display = 'block'
        }
        if (anualincome.value=='' && requiredLevelData.includes(anualincome.getAttribute('dataname'))){
            error('income','eincome','Introduzca un monto.');
            document.getElementById('eincome').style.display = 'block'
        }
        return;
    }else{
        updateCompany(req)
    }

    console.log(req)


}

function updateCompany(req){
    callWS("POST", "users/updatecompany", req, response);
    console.log(req)
    console.log(status)
    function response(status, rsp){
        switch(status){
            case 200:
                // Ok
                gotoPage('register','regCompanyImg',{ 'sessionid' : getParameterByName('sessionid') })
                break;
            case 204:
                break;
            case 400:
                // Parametros incorrectos
                break;
            case 500:
                // Error
                break;
            default:
                break;
        }
        console.log(status)
        console.log(rsp)
    }  
}
    
function getEntry(sessionid){
    console.log('entry')
    callWS("GET", "users/entry", { 'sessionid' : sessionid}, response);
        
    function response(status, rsp){
        switch(status){
            case 200:
                console.log(JSON.parse(rsp))
                requiredLevelData = (JSON.parse(rsp).requiredLevel).split(',')
                console.log(requiredLevelData)
                
                document.getElementById('economic').value = JSON.parse(rsp).entry.company.economicalactivity.value
                setStatus('economicIcon',JSON.parse(rsp).entry.company.economicalactivity,'economic')
                
                if(JSON.parse(rsp).entry.company.anualincome.number != 0){
                    var val = (Math.round((JSON.parse(rsp).entry.company.anualincome.number)*100)/100).toFixed(2)
                }else{
                    var val = ''
                }
                document.getElementById('income').value = val;//JSON.parse(rsp).entry.company.amooperationsmonthly.number
                document.getElementById('income').dispatchEvent(new Event("focusout"));
                setStatus('incomeIcon',JSON.parse(rsp).entry.company.anualincome,'income')
                
                if(JSON.parse(rsp).entry.company.patrimony.number != 0){
                    var val = (Math.round((JSON.parse(rsp).entry.company.patrimony.number)*100)/100).toFixed(2)
                }else{
                    var val = ''
                }
                document.getElementById('heritage').value = val;
                document.getElementById('heritage').dispatchEvent(new Event("focusout"));
                setStatus('heritageIcon',JSON.parse(rsp).entry.company.patrimony,'heritage')
                
                document.getElementsByClassName('pageCnt')[0].style.visibility="visible"
                if (JSON.parse(rsp).entry.company.politicalexposed.value == null){
                    document.getElementById('politician').value = ''
                }else{
                    document.getElementById('politician').value = JSON.parse(rsp).entry.company.politicalexposed.value;   
                }
                setStatus('politicianIcon',JSON.parse(rsp).entry.company.politicalexposed,'politician')
                
                // Window Load
                var waitScreen = document.getElementById("waitScreen");
                document.body.removeChild(waitScreen);
                WS_waitscreen = false;
                break;
            case 204:
                break;
            case 400:
                // Parametros incorrectos
                break;
            case 500:
                // Error
                break;
            default:
                break;
        }
        //console.log(status)
        //console.log(rsp)
    }    
}

// name A: classIcon
// name B : BD
// nameC: nameInput
function setStatus(nameA,nameB,nameC){
    
    document.getElementById(nameC).setAttribute('dataname',nameB.update)
                
    if(nameB.valid == -1){
        document.getElementById(nameA).classList.add("iconRed")
        document.getElementById(nameA).classList.add("fas")
        document.getElementById(nameA).classList.add("fa-times-circle")
    }
    else if (nameB.valid == 0){
        document.getElementById(nameA).classList.add("iconYellow")
        document.getElementById(nameA).classList.add("fas")
        document.getElementById(nameA).classList.add("fa-pause-circle")
    }
    else if (nameB.valid == 1){
        document.getElementById(nameA).classList.add("iconGreen")
        document.getElementById(nameA).classList.add("fas")
        document.getElementById(nameA).classList.add("fa-check-circle")
        document.getElementById(nameC).disabled = true;
        document.getElementById(nameC).style.cursor = 'default'
        if(document.getElementById(nameC).tagName != 'SELECT'){
            document.getElementById(nameC).style.backgroundColor = 'white'
        }
    }
}