<?php
// app/api/accounts/generate

    header("Content-Type:application/json");
    include("../dbconn.php");
    include("../utils.php");
    
    // parametros obligatorios
    $parmsob = array("sessionid","currencyid");
    if (!parametrosValidos($_GET, $parmsob)){
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(",", $parmsob)));
    }
    
    //Definicion de variables e inicializacion
    $out= new stdClass;
    $sessionid = $_GET["sessionid"];
    $currencyid = $_GET["currencyid"];
    
    //Validamos la session
    $userid = isSessionValid($db, $sessionid);
    
    //Validamos el si el usuario puede crear cuentas
    isLevelValid($db, $userid);
    
    //consultamos las monedas disponibles para las cuentas AFX
    $sql = "SELECT currencies FROM paymentmethods WHERE id = -1";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    $allowedcurrencies = $rs->fetch_assoc();
    
    //Validamos que la moneda enviada sea valida
    $allowedcurrenciesarr = explode(",",$allowedcurrencies["currencies"]);
    $isValid = false;
    
    foreach($allowedcurrenciesarr as $allowedcurrency){
        if($allowedcurrency == $currencyid){
            $isValid = true;
        }
    }
    
    //Si la moneda no es valida retornamos error
    if(!$isValid){
        badEnd("400", array("msg"=>"La moneda es invalida"));
    }
    
    //Consultamos los datos del usuarios para la insercion/validacion
    $sql = "SELECT * from users WHERE sessionid = '".$sessionid."'";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    $userdata = $rs->fetch_assoc();
    
    //Consultamos si ya posee una cuenta de AFX
    $sql = "SELECT COUNT(id) AS qty FROM accounts".
    "       WHERE userid = ".$userdata["id"].
    "       AND paymentmethodid = -1 ".
    "       AND currencyid = ".$currencyid;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    $row = $rs->fetch_assoc();
    
    if($row["qty"] > 0){
        badEnd("409", array("msg"=>"Registro Duplicado"));
    }
    
    //Consultamos los datos de la moneda
    $sql = "SELECT name, symbol, interface FROM currencies ".
    "       WHERE id = ".$currencyid;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    $row = $rs->fetch_assoc();
    
    //Validamos si es una criptomoneda o fiat
    $isCripto = false;
    $isFiat = false;
    
    if(intval($row['interface']) == 1 || intval($row['interface']) == 3 || intval($row['interface']) == 2){
        $isFiat = true;
    }else if(intval($row['interface']) == 4 || intval($row['interface']) == 5){
        $isCripto = true;
    }
    
    $db->autocommit(FALSE);
        
    if($isCripto && !$isFiat){
        $randomWallet = randomString(30);
        
        //Insertamos la nueva cuenta
        $sql = "INSERT INTO accounts".
        "       (".
        "       paymentmethodid, ".
        "       userid, ".
        "       currencyid, ".
        "       details1, ".
        "       status ".
        "       )".
        "       VALUES(".
        "       -1, ".
        "       ".$userdata["id"].", ".
        "       ".$currencyid.", ".
        "       '".$randomWallet."', ".
        "       1 ".
        "       )";
        if (!$db->query($sql)){
            $error = $db->error;
            $db->rollback();
            $db->close();
            badEnd("500", array("msg"=>$error));
        }
            
        // Retornamos el id que fue insertado
        $out->id = (int)$db->insert_id;
        
        //Al ser una cripto, creamos una wallet
        $sql = "INSERT INTO wallets".
        "       (".
        "       wallet, ".
        "       secretKey, ".
        "       accountid, ".
        "       expirationDate".
        "       )".
        "       VALUES(".
        "       '".$randomWallet."', ".
        "       '".randomString(8)."', ".
        "       ".$out->id.", ".
        "       DATE_ADD(NOW(), INTERVAL 1 YEAR)".
        "       )";
        if (!$db->query($sql)){
            $error = $db->error;
            $db->rollback();
            $db->close();
            badEnd("500", array("msg"=>$error));
        }
        
    }else if($isFiat && !$isCripto){
        //Insertamos la nueva cuenta
        $sql = "INSERT INTO accounts".
        "       (".
        "       paymentmethodid, ".
        "       userid, ".
        "       currencyid, ".
        "       status".
        "       )".
        "       VALUES(".
        "       -1, ".
        "       ".$userdata["id"].", ".
        "       ".$currencyid.", ".
        "       1".
        "       )";
        if (!$db->query($sql)){
            $error = $db->error;
            $db->rollback();
            $db->close();
            badEnd("500", array("msg"=>$error));
        }
            
        // Retornamos el id que fue insertado
        $out->id = (int)$db->insert_id;
    }else{
        $db->rollback();
        $db->close();
        badEnd("500", array("msg"=>"No se logro determinar el tipo de moneda, avise para verificar el arreglo de monedas"));
    }
    
    /*******************FONDEO INICIAL PARA PRUEBAS********************/
    
    //Consultamos los datos de las cuentas de DEPOSITO = -3
    $sql = "SELECT * FROM accounts ".
    "       WHERE currencyid = ".$currencyid.
    "       AND userid = -1 ".
    //"       AND paymentmethodid > 0".
    "       AND paymentmethodid = -3".
    "       AND status = 1";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    $paymentaccountid = $rs->fetch_assoc();
    if($isCripto){
        $amount = $isCripto ? "5" : "1000000";
        
        $level = 1;
    
        if($userdata["level"] == 0){
            $level = 1;
        }else{
            $level = $userdata["level"];
        }
        
        //COnsultamos el fee dependiendo de la cuenta jeje :p
        $sql = "SELECT * FROM cmspreffees".
        "       WHERE usertype = ".$userdata["type"].
        "       AND levelid = ".$level.
        "       AND currencyid = ".$currencyid;
        if (!$rs=$db->query($sql)){
            $error = $db->error;
            $db->rollback();
            $db->close();
            badEnd("500", array("msg"=>$error));
        }
        
        //Guardamos la data de la cuenta
        $fee = $rs->fetch_assoc();
    
        //Calculamos el monto real quitandole la comision
        if($fee["pctfeedeposits"] != null){
            if($fee["pctfeedeposits"] == 0){
                $realfee = $amount - ($amount - $fee["nmlfeedeposits"]);
                $realamount = $amount - $realfee;
            }else{
                $realfee = ($fee["pctfeedeposits"]*$amount)/100;
                $realamount = $amount - $realfee;
            }
        }else{
            $realfee = (2*$amount)/100;
            $realamount = $amount - $realfee;
        }
    
        //insertamos la trasaccion del deposito
    $sql = "INSERT INTO transactions".
    "       (".
    "       datecreated, ".
    "       dsc, ".
    "       amount, ".
    "       amountghost, ".
    "       accountid, ".
    "       orderid, ".
    "       txid, ".
    "       accountorigin, ".
    "       accountdestination".
    "       )".
    "       VALUES(".
    "       NOW(), ".
    "       'Depósito inicial de pruebas', ".
    "       ".$amount.",".
    "       0, ".
    "       ".$out->id.", ".
    "       NULL, ".
    "       NULL, ".
    "       NULL, ".
    "       ".$paymentaccountid["id"].
    "       )";
    if (!$db->query($sql)){
        $error = $db->error;
        $db->rollback();
        $db->close();
        badEnd("500", array("msg"=>$error));
    }
    
    //Guardamos el id de la transaccion de deposito
    $txid = (int)$db->insert_id;
    
    //Le colocamos a la primera transferencia el txid
    $sql = "UPDATE transactions SET".
    "       txid = ".$txid.
    "       WHERE id = ".$txid;
    if (!$db->query($sql)){
        $error = $db->error;
        $db->rollback();
        $db->close();
        badEnd("500", array("msg"=>$error));
    }
    
    //insertamos la comision del deposito
    $sql = "INSERT INTO transactions".
    "       (".
    "       datecreated, ".
    "       dsc, ".
    "       amount, ".
    "       amountghost, ".
    "       accountid, ".
    "       orderid, ".
    "       txid, ".
    "       accountorigin, ".
    "       accountdestination".
    "       )".
    "       VALUES(".
    "       NOW(), ".
    "       'Comisión de Depósito inicial de pruebas', ".
    "       -".$realfee.",".
    "       0, ".
    "       ".$out->id.", ".
    "       NULL, ".
    "       ".$txid.", ".
    "       NULL, ".
    "       ".$paymentaccountid["id"].
    "       )";
    if (!$db->query($sql)){
        $error = $db->error;
        $db->rollback();
        $db->close();
        badEnd("500", array("msg"=>$error));
    }
    
    //insertamos la comision del deposito
    $sql = "INSERT INTO transactions".
    "       (".
    "       datecreated, ".
    "       dsc, ".
    "       amount, ".
    "       amountghost, ".
    "       accountid, ".
    "       orderid, ".
    "       txid, ".
    "       accountorigin, ".
    "       accountdestination".
    "       )".
    "       VALUES(".
    "       NOW(), ".
    "       'Comisión de Depósito inicial de pruebas', ".
    "       ".$realfee.",".
    "       0, ".
    "       ".$paymentaccountid["id"].", ".
    "       NULL, ".
    "       ".$txid.", ".
    "       NULL, ".
    "       ".$paymentaccountid["id"].
    "       )";
    if (!$db->query($sql)){
        $error = $db->error;
        $db->rollback();
        $db->close();
        badEnd("500", array("msg"=>$error));
    }
    //insertamos la comision del deposito
    $sql = "INSERT INTO deposits".
    "       (".
    "       paymentref, ".
    "       paymentaccountid, ".
    "       paymentdate, ".
    "       createddate, ".
    "       fee, ".
    "       transactionid, ".
    "       valid, ".
    "       amount ".
    "       )".
    "       VALUES(".
    "       123456789, ".
    "       ".$paymentaccountid["id"].", ".
    "       NOW(), ".
    "       NOW(), ".
    "       ".$realfee.", ".
    "       ".$txid.", ".
    "       NOW(), ".
    "       ".$amount.
    "       )";
    if (!$db->query($sql)){
        $error = $db->error;
        $db->rollback();
        $db->close();
        badEnd("500", array("msg"=>$error));
    }
    }
    
    //auditoria
    setAudit($db, "F. DE PAGO", $sessionid, "APP", "Se genero la cuenta ".$out->id." para el usuario ".$userdata["id"]);
    
    $db->commit();
    $db->close();
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>
