<?php
// cms/api/accounts/update

    header("Content-Type:application/json");
    include("../dbconn.php");
    include("../utils.php");
    
    // parametros obligatorios
    $parmsob = array("sessionid","id","paymentmethodid","currencyid","details1","status");
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    //Criptomonedas 
    $cryptoarr = array("BTC","LTC","ETH","PTR");
    //Monedas Fiat
    $fiatarr = array("BSS","$","€");
    
    //Declaramos e inicializamos nuestras variables
    $out= new stdClass;
    $sessionid = $_GET["sessionid"];
    $id = $_GET["id"];
    $paymentmethodid = $_GET["paymentmethodid"];
    $currencyid = $_GET["currencyid"];
    $details1 = $_GET["details1"];
    $status = $_GET["status"];
    
    //Validamos que la session del usuario sea valida para continuar
    isSessionValidCMS($db, $sessionid);
    
    //Si el id es 0 se crea, si no se actualiza
    if($id == 0){
        
        //Validamos que tenga privilegios para crear
        if (!tienePrivilegio($db, $sessionid, 23))
            badEnd("403", array("msg"=>"No tiene Privilegios"));
            
        //Insertamos la nueva cuenta
        $sql = "INSERT INTO accounts".
        "       (".
        "       paymentmethodid, ".
        "       userid, ".
        "       currencyid, ".
        "       details1, ".
        "       ".validateInsertField("details2","details2").
        "       ".validateInsertField("details3","details3").
        "       ".validateInsertField("details4","details4").
        "       status".
        "       )".
        "       VALUES(".
        "       ".$paymentmethodid.", ".
        "       -1, ".
        "       ".$currencyid.", ".
        "       '".$details1."', ".
        "       ".validateInsertValue("details2","string")." ".
        "       ".validateInsertValue("details3","string")." ".
        "       ".validateInsertValue("details4","string")." ".
        "       ".$status.
        "       )";
        if (!$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
            
        // Retornamos el id que fue insertado
        $out->id = (int)$db->insert_id;
        
        //auditoria
        setAudit($db, "CTAS. INTERNAS", $sessionid, "CMS", "Se incluyo la cuenta interna ".$out->id);
        
    }else{
        
        //Validamos que tenga privilegios para editar/actualizar
        if (!tienePrivilegio($db, $sessionid, 24))
            badEnd("403", array("msg"=>"No tiene Privilegios"));
        
        //Consultamos para validar que el registro exista
        $sql = "SELECT id, userid FROM accounts WHERE id = ".$id.
        "       AND userid = -1";
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
            
        $row = $rs->fetch_assoc();
        
        // Retornamos 204 cuando la busqueda no obtiene resutados
        if($row["id"] == null){
            badEnd("204", array("msg"=>"No se encuentra el registro"));
        }
        
        $sql = "UPDATE accounts SET".
        "       paymentmethodid = ".$paymentmethodid.", ".
        "       currencyid = ".$currencyid.", ".
        "       details1 = '".$details1."', ".
        "       details2 = ".($_GET["details2"] == "" ? "null" : "'".$_GET["details2"]."'").", ".
        "       details3 = ".($_GET["details3"] == "" ? "null" : "'".$_GET["details3"]."'").", ".
        "       details4 = ".($_GET["details4"] == "" ? "null" : "'".$_GET["details4"]."'").", ".
        "       status = ".$status.
        "       WHERE id = ".$id;
        if (!$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
        
        //Retornamos 304 si no se actualizo ningun registro
        if ($db->affected_rows == 0)
            badEnd("304", array("msg"=>"No se pudo modificar"));
    
        $out->id = (int)$id;
        
        //auditoria
        setAudit($db, "CTAS. INTERNAS", $sessionid, "CMS", "Se actualizo la cuenta interna ".$out->id);
    }
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
    
    /*  Funcion para validar que el campo fue enviado, 
    *   y armar los campos a insertar
    *   Se reciben dos parametros:
    *   $param = Parametro a validar
    *   $field = nombre del campo
    */
    function validateInsertField($param, $field){
        $str = "";
        
        if(isset($_GET[$param]) && $_GET[$param] != ""){
            $str = $str." ".$field.",";
        }
        
        return $str;
    }
    
    /*  Funcion para validar que el valor fue enviado, 
    *   y armar el string para insertarlo
    *   Se recibe un parametro:
    *   $param = Parametro a validar
    *   $type = Tipo de valor
    */
    function validateInsertValue($param,$type){
        $str = "";
        
        if(isset($_GET[$param]) && $_GET[$param] != ""){
            if($type == "string"){
                $str = $str." '".$_GET[$param]."',";
            }else if($type == "number"){
                $str = $str." ".$_GET[$param].",";
            }else{
                $str = $str." '".$_GET[$param]."',";
            }
        }
        
        return $str;
    }
?>
