<?php
// cms/api/cities/update

    header("Content-Type:application/json");
    include("../dbconn.php");
    include("../utils.php");
    
    // parametros obligatorios
    $parmsob = array("sessionid","id","regionid","dsc","status");
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    //Declaramos e inicializamos nuestras variables
    $out= new stdClass;
    
    $sessionid = $_GET["sessionid"];
    $id = $_GET["id"];
    $regionid = $_GET["regionid"];
    $name = $_GET["dsc"];
    $status = $_GET["status"];
    
    //Validamos que la session del usuario sea valida para continuar
    isSessionValidCMS($db, $sessionid);
    
    
    //Si el id es igual a 0, se crea, si no se actualiza la region
    if($id == 0){
        //Validamos que el usuario tenga privilegios
        if(!tienePrivilegio($db, $sessionid, 52))
            badEnd("403", array("msg"=>"No tiene Privilegios"));
        
        //Buscamos el id del pais para almacenarlo
        $sql = "SELECT id, name, countryid FROM regions WHERE id = ".$regionid;
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
            
        $row = $rs->fetch_assoc();
        
        $countryid = $row["countryid"];
        
        $sql = "INSERT INTO cities(countryid, regionid, name, status, created_at, updated_at)".
        "       VALUES (".$countryid.", ".$regionid.", '".$name."', ".$status.", NOW(), NOW())";
        if (!$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
            
        // Retornamos el id que fue insertado
        $out->id = (int)$db->insert_id;
        
        //auditoria
        setAudit($db, "CIUDADES", $sessionid, "CMS", "Se creo la ciudad ".$out->id);
    }else{
        //Validamos que el usuario tenga privilegios
        if(!tienePrivilegio($db, $sessionid, 53))
            badEnd("403", array("msg"=>"No tiene Privilegios"));
            
        //Buscamos el id del pais para almacenarlo
        $sql = "SELECT id, name, countryid FROM regions WHERE id = ".$regionid;
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
            
        $row = $rs->fetch_assoc();
        
        $countryid = $row["countryid"];
        
        //Consultamos para validar que el registro exista
        $sql = "SELECT name, status FROM cities WHERE id = ".$id;
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
            
        $row = $rs->fetch_assoc();
        
        // Retornamos 204 cuando la busqueda no obtiene resutados
        if($row["name"] == null){
            badEnd("204", array("msg"=>"No se encuentra el registro"));
        }
        
        $sql = "UPDATE cities SET".
        "       countryid = ".$countryid.", ".
        "       regionid = ".$regionid.", ".
        "       name = '".$name."', ".
        "       status = ".$status.", ".
        "       updated_at = NOW()".
        "       WHERE id = ".$id;
        if (!$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
        
        //Retornamos 304 si no se actualizo ningun registro
        if ($db->affected_rows == 0)
            badEnd("304", array("msg"=>"No se pudo modificar"));
    
        $out->id = (int)$id;
        
        //auditoria
        setAudit($db, "CIUDADES", $sessionid, "CMS", "Se actualizo la ciudad ".$out->id);
    }
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>
