<?php
// cms/api/orders/cancel

    header("Content-Type:application/json");
    include("../dbconn.php");
    include("../utils.php");
    
    // parametros obligatorios
    $parmsob = array('sessionid','id');
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    //Declaramos e inicializamos nuestras variables
    $out= new stdClass();
    $id = $_GET["id"];
    $sessionid = $_GET["sessionid"];
    
    //Validamos que la session del usuario sea valida para continuar
    $userid = isSessionValidCMS($db, $sessionid);
    
    //Validamos que el usuario tenga privilegios
    if(!tienePrivilegio($db, $sessionid, 34))
        badEnd("403", array("msg"=>"No tiene Privilegios"));
        
    //Consultamospara valida que exista el registro
    $sql = "SELECT COUNT(id) AS qty FROM orders WHERE id = ".$id;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    $row = $rs->fetch_assoc();
    
    //Si es 0, no se encontraron resultados
    if($row['qty'] == 0){
        badEnd("404", array("msg"=>'Orden no encontrada'));
    }
    
    //Validamos que no haya sido ya cancelada
    $sql = "SELECT * FROM orders WHERE id = ".$id;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    $row = $rs->fetch_assoc();
    
    //Si canceled no es null, no se puede colocar una fecha
    if($row['canceled'] != NULL){
        badEnd("402", array("msg"=>'Orden ya esta cancelada'));
    }
    
    //Actualizamos el campo canceled
    $sql = "UPDATE orders SET ".
    "       canceled = NOW() ".
    "       WHERE id = ".$id.
    "       AND canceled IS NULL";
    if (!$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
    
    //Retornamos 304 si no se elimino ningun registro
    if ($db->affected_rows == 0){
        badEnd("403", array("msg"=>"No se pudo modificar"));
    }
    
    $out->id = (int)$id;
    
    //auditoria
    setAudit($db, "ORDENES", $sessionid, "CMS", "El usuario ".$userid." canceló la orden ".$out->id);
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>
