<?php
// app/api/accounts/delete

    header("Content-Type:application/json");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
    
    // parametros obligatorios
    $parmsob = array("sessionid","id");
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    //Declaramos e inicializamos nuestras variables
    $out= new stdClass;
    $sessionid = $_GET["sessionid"];
    $id = $_GET["id"];
    
    //Validamos que la session del usuario sea valida para continuar
    isSessionValid($db, $sessionid);
    
    // Obtenemos el lenguaje del usuario
    $lang = updateLang($db,$sessionid);
    
    //Obtenemos el id del usuario para mejorar la validacion del delete
    $sql = "SELECT id, usr FROM users WHERE sessionid = '".$sessionid."'";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
            
    $row = $rs->fetch_assoc();
    $userid = $row["id"];
    
    //Validamos que exista el registro
    $sql = "SELECT id, userid, paymentmethodid, rejected, approved FROM accounts WHERE id = ".$id.
    "       AND userid = ".$userid;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
            
    $row = $rs->fetch_assoc();
        
    // Retornamos 404 cuando la busqueda no obtiene resutados
    if($row["userid"] == null){
        badEnd("404", array("msg"=>determinateMsgFail(array(
            "esp"=>"No se encuentra el registro",
            "eng"=>"Cannot find the record"), $lang, "No se encuentra el registro")));
    }
    
    // Verificamos si la cuenta esta validada
    //Consultamos el nombre del metodo de pago
    $sql = "SELECT details1, details2, details3, details4 ".
    "       FROM paymentmethods ".
    "       WHERE paymentmethods.id = ".$row["paymentmethodid"];
    if (!$res=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    $payment = $res->fetch_assoc();
    //Guardamos los campos a validar
    $cant = 0;
    if($payment["details1"] != null)$cant = $cant + 1;
    if($payment["details2"] != null)$cant = $cant + 1;
    if($payment["details3"] != null)$cant = $cant + 1;
    if($payment["details4"] != null)$cant = $cant + 1;
    
    $valid = 0;
    if($row["rejected"] != null){
        $valid = -1;
    }else if($row["approved"] != null && $row["rejected"] == null && $cant==count(explode(",", $row["approved"]))){
        $valid = 1;
    }else{
        $valid = 0;
    }
    
    if($valid == 1){
        badEnd("304", array("msg"=>determinateMsgFail(array(
            "esp"=>"No se pudo modificar",
            "eng"=>"Cannot modify"), $lang, "No se pudo modificar")));
    }
    
    //Eliminamos la cuenta si no esta validada por el CMS
    $sql = "DELETE FROM accounts WHERE id = ".$id.
    "       AND userid = ".$userid;
    if (!$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    //Retornamos 304 si no se actualizo ningun registro
    if ($db->affected_rows == 0)
        badEnd("304", array("msg"=>determinateMsgFail(array(
            "esp"=>"No se pudo modificar",
            "eng"=>"Cannot modify"), $lang, "No se pudo modificar")));
    
    $out->id = (int)$id;
    
    // Obtenemos el nombre del usuario
    $sql = "SELECT IF(userpersons.fname IS NULL, usercompanies.name, CONCAT(userpersons.fname,' ',userpersons.flastname)) AS name ".
    "       FROM users ".
    "       LEFT JOIN userpersons ON userpersons.usrid = users.id ".
    "       LEFT JOIN usercompanies ON usercompanies.usrid = users.id ".
    "       WHERE sessionid = '".$sessionid."'";
    if (!$res=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    $userdataaudit = $res->fetch_assoc();
    
    //auditoria
    setAudit($db, "F. DE PAGO", $sessionid, "APP", "El usuario ".$userdataautir['name']." elimino una cuenta de retiro (".$out->id.")");
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>
