<?php
// cms/api/transactions/delete

    header("Content-Type:application/json");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
    
    // parametros obligatorios
    $parmsob = array("sessionid",'id');
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    //Declaramos e inicializamos nuestras variables
    $out = new stdClass();
    $sessionid = $_GET["sessionid"];
    $id = $_GET['id'];
    
    //Validamos que la session del usuario sea valida para continuar
    isSessionValidCMS($db, $sessionid);
    
    //Validamos que el usuario tenga privilegios
    if(!tienePrivilegio($db, $sessionid, 39))
        badEnd("403", array("msg"=>"No tiene Privilegios"));
    
    // Validamos que exista el registro
    $sql = "SELECT COUNT(id) AS qty FROM transactions WHERE txid = ".$id;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
            
    $row = $rs->fetch_assoc();
        
    // Retornamos 404 cuando la busqueda no obtiene resutados
    if($row['qty'] == 0){
        badEnd("204", array("msg"=>"No se encuentra el registro"));
    }
    
    $sql = "DELETE FROM transactions WHERE txid = ".$id;
    if (!$db->query($sql)){
        if ($db->errno == 1451)
            badEnd("304",array("msg"=>"Existen dependencias que no permiten eliminar esta Cuenta"));
        else
            badEnd("500",array("msg"=>$db->error));
    }
        
    //Retornamos 304 si no se actualizo ningun registro
    if ($db->affected_rows == 0)
        badEnd("304", array("msg"=>"No se pudo modificar"));
    
    $out->id = (int)$id;
    
    //auditoria
    setAudit($db, "TRANSACCIONES", $sessionid, "CMS", "Se eliminó el ajuste ".$out->id);
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>
