window.onload = function(){
    
    // Entry
    getEntry(getParameterByName('sessionid'))
    
    // Go to Register Person
    document.getElementById('person').addEventListener("click", function(){
        var req = {
            "sessionid" : getParameterByName('sessionid'),
            "step" : 0,
            "uploadids" : ''
        }
        updatePerson(req)
    });
    
    // Go to Register Company
    document.getElementById('company').addEventListener("click", function(){
        var req = {
            "sessionid" : getParameterByName('sessionid'),
            "step" : 0,
            "uploadids" : ''
        }
        updateCompany(req)
    });
    
    //Mostrar HTML cargado
    //esconderHTML(false);
}

function gotoStep(rsp){
    var lastpag = document.referrer;
    if(lastpag !== ""){
        //Pagina anterior detetcto si viene de un boton anterior
        var lastid="";
        var sid = lastpag.indexOf("&sid=", 0);
        var sess = lastpag.indexOf("&ses", 0);
        if(sid>0 && sess>0){
            lastid = lastpag.substr((sid+5), ((sess)-(sid+5)));
            
            document.getElementById("cellTypeUsr").style.visibility="";//Muestro el form
            esconderHTML(false);
    }else{
            //Valido que tegna un tipo seleccionado
            if(rsp.entry.type.id !== 0 ){
                //Redirecciono a paginas de persona natural dependiendo del paso
                if(rsp.entry.type.id == 1){
                    console.log(rsp.entry)
                    switch(rsp.entry.person.step){
                        case 0:
                            document.getElementById("cellTypeUsr").style.visibility="";
                            esconderHTML(false);
                            break;
                        case 1:
                            gotoPage('register','regPerson',{ 'sessionid': getParameterByName('sessionid') });
                            break;
                        case 2:
                            gotoPage('register','regPersonRes',{ 'sessionid': getParameterByName('sessionid') });
                            break;
                        case 3:
                            gotoPage('register','regPersonInf',{ 'sessionid': getParameterByName('sessionid') });
                            break;
                        case 4:
                            gotoPage('register','regPersonImg',{ 'sessionid': getParameterByName('sessionid') });
                            break;
                        case 5:
                            gotoPage('register','regPersonTr',{ 'sessionid': getParameterByName('sessionid') });
                            break;
                        case 6:
                            gotoPage('register','regPersonStatement',{ 'sessionid': getParameterByName('sessionid') });
                        break;
                        case 7:
                            if(rsp.entry.view == 0){
                                gotoPage('dashboard','home',{ 'sessionid': getParameterByName('sessionid') });
                            }else{
                                gotoPage('step','main',{ 'sessionid': getParameterByName('sessionid') });
                            }
                        break;
                    }
                }else{
                    switch(rsp.entry.company.step){
                        case 0:
                            document.getElementById("cellTypeUsr").style.visibility="";
                            esconderHTML(false);
                            break;
                        case 1:
                            gotoPage('register','regCompany',{ 'sessionid': getParameterByName('sessionid') });
                            break;
                        case 2:
                            gotoPage('register','regCompanyPartner',{ 'sessionid': getParameterByName('sessionid') });
                            break;
                        case 3:
                            gotoPage('register','regCompanyRes',{ 'sessionid': getParameterByName('sessionid') });
                            break;
                        case 4:
                            gotoPage('register','regCompanyInf',{ 'sessionid': getParameterByName('sessionid') });
                            break;
                        case 5:
                            gotoPage('register','regCompanyImg',{ 'sessionid': getParameterByName('sessionid') });
                            break;
                        case 6:
                            gotoPage('register','regCompanyTr',{ 'sessionid': getParameterByName('sessionid') });
                            break;
                        case 7:
                            gotoPage('register','regCompanyStatement',{ 'sessionid': getParameterByName('sessionid') });
                            break;
                        case 8:
                            if(rsp.entry.view == 0){
                                gotoPage('dashboard','home',{ 'sessionid': getParameterByName('sessionid') });
                            }else{
                                gotoPage('step','main',{ 'sessionid': getParameterByName('sessionid') });
                            }
                            break;
                }
            }
            }else{
                document.getElementById("cellTypeUsr").style.visibility="";
                esconderHTML(false);
            }
        }
    }
}

function getEntry(sessionid){
    callWS("GET", "users/entry", { 'sessionid' : sessionid}, response);
    function response(status, rsp){
        
        //console.log(JSON.parse(rsp)) No puedes parsear el responseText acá porque el 304 viene vacío y falla al intentar parsearlo
        switch(status){
            case 200:
                // Ok
                gotoStep(JSON.parse(rsp));
                break;
            case 204:
                break;
            case 304:
                // New
                document.getElementById("cellTypeUsr").style.visibility="";
                esconderHTML(false);
                break;
            case 400:
                // Parametros incorrectos
                break;
            case 500:
                // Error
                break;
            default:
                break;
        }
        //console.log(status)
        //console.log(rsp)
    }    
}


// Update step with updateperson
function updatePerson(req){
    callWS("POST", "users/updateperson", req, response);
    function response(status, rsp){
        switch(status){
            case 200:
                // Ok
                gotoPage('register','regPerson',{ 'sessionid': getParameterByName('sessionid') })
                break;
            case 204:
                break;
            case 400:
                // Parametros incorrectos
                break;
            case 500:
                // Error
                break;
            default:
                break;
        }
    }  
}

// Update step with updatecompany
function updateCompany(req){
    callWS("POST", "users/updatecompany", req, response);
    function response(status, rsp){
        switch(status){
            case 200:
                // Ok
                gotoPage('register','regCompany',{ 'sessionid': getParameterByName('sessionid') })
                break;
            case 204:
                break;
            case 400:
                // Parametros incorrectos
                break;
            case 500:
                // Error
                break;
            default:
                break;
        }
    }  
}