<?php
// cms/api/balances/general

    header("Content-Type:application/json");
    include("../dbconn.php");
    include("../utils.php");
    
    // parametros obligatorios
    $parmsob = array("sessionid", "order", "offset", "numofrec");
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    //Declaramos e inicializamos nuestras variables
    $out= new stdClass;
    $sessionid = $_GET["sessionid"];
    $offset = $_GET['offset'];
    $numofrec = $_GET['numofrec'];
    $filter = "";
    $currencyid = "";
    $whereclause = "";
    $order = determinateOrder($_GET["order"]);
    // VAriable para controlar busqueda por fecha o por fecha y hora
    $dateAndHour = false;
    
    //Validamos que la session del usuario sea valida para continuar
    isSessionValidCMS($db, $sessionid);
    
    //Validamos que el usuario tenga privilegios
    if(!tienePrivilegio($db, $sessionid, 36))
        badEnd("403", array("msg"=>"No tiene Privilegios"));
    
    //En caso de que el filter sea enviado, se construye el query
    // Filtros por montos
    if(isset($_GET["filter"]) && $_GET["filter"] != ""){
        // Iniciamos la cadena del query
        $filter = " ( ";
        
        //Separamos el filtro por el simbolo +
        $filterEl = separateFilter($_GET["filter"]);
        
        //Recorremos cada elemento
        foreach($filterEl as $index => $el){
            
            //Si la fecha tiene / lo partimos en mil
            // Partimos la hora de la fecha
            $datehour = explode(' - ',$el);
            
            //SI este pana trae la hora, guardamos que la trajo
            if(sizeof($datehour) > 1){
                $dateAndHour = true;
            }
            
            if(strpos($datehour[0], '/') !== false){
                $dateelements = explode("/",$datehour[0]);
                
                foreach($dateelements as $i => $element){
                    if($i == 0){
                        $dateConverted .= $element;
                    }else{
                        $dateConverted .= "-".$element;
                    }
                }
                
                $dateel = strftime("%Y-%m-%d", strtotime($dateConverted));
                $dateelhour = strftime("%Y-%m-%d %H:%M", strtotime($dateConverted." ".$datehour[1]));
            }else{
                $dateel = strftime("%Y-%m-%d", strtotime($el));
                $dateelhour = strftime("%Y-%m-%d %H:%M", strtotime($el));
            }
            
            if($index == 0){
                $filter .= ( !$dateAndHour ? " (SELECT DATE(transactions.datecreated) FROM  transactions, accounts ".
                " 	            WHERE accounts.currencyid = cur.id ".
                "          	    AND accounts.id = transactions.accountid ".
                "         	    AND transactions.datecreated = (SELECT MAX(transactions.datecreated) FROM transactions WHERE accounts.id = transactions.accountid) ".
                "         	    ORDER BY transactions.datecreated DESC, transactions.id DESC ".
                "    		    LIMIT 1 ".
                "           ) = DATE('".$dateel."') " : '').
                ( $dateAndHour ? " (SELECT DATE_FORMAT(transactions.datecreated,'%Y-%m-%d %l:%i') FROM  transactions, accounts ".
                " 	            WHERE accounts.currencyid = cur.id ".
                "          	    AND accounts.id = transactions.accountid ".
                "         	    AND transactions.datecreated = (SELECT MAX(transactions.datecreated) FROM transactions WHERE accounts.id = transactions.accountid) ".
                "         	    ORDER BY transactions.datecreated DESC, transactions.id DESC ".
                "    		    LIMIT 1 ".
                "           ) = DATE_FORMAT('".$dateelhour."','%Y-%m-%d %l:%i') " : '').
                "           OR cur.symbol LIKE '".$el."%' ".
                "           ".(validNumber($el) ? " OR (SELECT COUNT(accounts.id) ".
                "        	    FROM accounts ".
                "   	    	WHERE accounts.currencyid = cur.id ".
                "               AND accounts.paymentmethodid = -1 ".
                "           ) LIKE '%".floatval($el)."%'" : (validNumberFormatted($el) ? " OR (SELECT COUNT(accounts.id) ".
                "        	    FROM accounts ".
                "   	    	WHERE accounts.currencyid = cur.id ".
                "               AND accounts.paymentmethodid = -1 ".
                "           ) LIKE '%".parseFormattedNumber($el)."%'" : '') ).
                "           ".(validNumber($el) ? " OR IF((SELECT SUM(transactions.amount) ".
                "        	    FROM transactions, accounts ".
                "        	    WHERE transactions.accountid = accounts.id ".
                "       	    AND accounts.currencyid = cur.id ".
                "       	    AND accounts.paymentmethodid = -1) IS NOT NULL, ".
                "               ROUND((SELECT SUM(transactions.amount) ".
                "        	        FROM transactions, accounts ".
                "        	        WHERE transactions.accountid = accounts.id ".
                "       	        AND accounts.currencyid = cur.id ".
                "       	        AND accounts.paymentmethodid = -1), cur.decimals), ".
                "                0) LIKE '%".floatval($el)."%'" : (validNumberFormatted($el) ? " OR IF((SELECT SUM(transactions.amount) ".
                "        	    FROM transactions, accounts ".
                "        	    WHERE transactions.accountid = accounts.id ".
                "       	    AND accounts.currencyid = cur.id ".
                "       	    AND accounts.paymentmethodid = -1) IS NOT NULL, ".
                "               ROUND((SELECT SUM(transactions.amount) ".
                "        	        FROM transactions, accounts ".
                "        	        WHERE transactions.accountid = accounts.id ".
                "       	        AND accounts.currencyid = cur.id ".
                "       	        AND accounts.paymentmethodid = -1), cur.decimals), ".
                "                0) LIKE '%".parseFormattedNumber($el)."%'" : '')).
                "           ".(validNumber($el) ? " OR IF((SELECT SUM(deposits.amount - deposits.fee) ".
                "               FROM accounts, transactions, deposits ".
                "               WHERE transactions.id = deposits.transactionid ".
                "               AND deposits.rejected IS NULL ".
                "               AND deposits.valid IS NULL ".
                "               AND accounts.id = transactions.accountid ".
                "               AND accounts.currencyid = cur.id ".
                "               AND transactions.amountghost >= 0) IS NOT NULL,".
                "               ROUND((SELECT SUM(deposits.amount - deposits.fee) ".
                "                   FROM accounts, transactions, deposits ".
                "                   WHERE transactions.id = deposits.transactionid ".
                "                   AND deposits.rejected IS NULL ".
                "                   AND deposits.valid IS NULL ".
                "                   AND accounts.id = transactions.accountid ".
                "                   AND accounts.currencyid = cur.id ".
                "                   AND transactions.amountghost >= 0), cur.decimals), ".
                "            0) LIKE '%".floatval($el)."%'" : ( validNumberFormatted($el) ? " OR IF((SELECT SUM(deposits.amount - deposits.fee) ".
                "               FROM accounts, transactions, deposits ".
                "               WHERE transactions.id = deposits.transactionid ".
                "               AND deposits.rejected IS NULL ".
                "               AND deposits.valid IS NULL ".
                "               AND accounts.id = transactions.accountid ".
                "               AND accounts.currencyid = cur.id ".
                "               AND transactions.amountghost >= 0) IS NOT NULL,".
                "               ROUND((SELECT SUM(deposits.amount - deposits.fee) ".
                "                   FROM accounts, transactions, deposits ".
                "                   WHERE transactions.id = deposits.transactionid ".
                "                   AND deposits.rejected IS NULL ".
                "                   AND deposits.valid IS NULL ".
                "                   AND accounts.id = transactions.accountid ".
                "                   AND accounts.currencyid = cur.id ".
                "                   AND transactions.amountghost >= 0), cur.decimals), ".
                "            0) LIKE '%".parseFormattedNumber($el)."%'" : '')).
                "           ".(validNumber($el) ? " OR ( IF((SELECT SUM(transactions.amount) ".
                "            	FROM transactions, accounts ".
                "            	WHERE transactions.accountid = accounts.id ".
                "           	AND accounts.currencyid = cur.id ".
                "           	AND accounts.paymentmethodid = -1) IS NOT NULL, ".
                "               ROUND((SELECT SUM(transactions.amount) ".
                "                	FROM transactions, accounts ".
                "                	WHERE transactions.accountid = accounts.id ".
                "               	AND accounts.currencyid = cur.id ".
                "               	AND accounts.paymentmethodid = -1), cur.decimals),".
                "               0) ".
                "           + IF((SELECT SUM(deposits.amount - deposits.fee) ".
                "               FROM accounts, transactions, deposits ".
                "               WHERE transactions.id = deposits.transactionid ".
                "               AND deposits.rejected IS NULL ".
                "               AND deposits.valid IS NULL ".
                "               AND accounts.id = transactions.accountid ".
                "               AND accounts.currencyid = cur.id ".
                "               AND transactions.amountghost >= 0) IS NOT NULL,".
                "               ROUND((SELECT SUM(deposits.amount - deposits.fee) ".
                "                   FROM accounts, transactions, deposits ".
                "                   WHERE transactions.id = deposits.transactionid ".
                "                   AND deposits.rejected IS NULL ".
                "                   AND deposits.valid IS NULL ".
                "                   AND accounts.id = transactions.accountid ".
                "                   AND accounts.currencyid = cur.id ".
                "                   AND transactions.amountghost >= 0), cur.decimals), ".
                "            0)) LIKE '%".floatval($el)."%'" : (validNumberFormatted($el) ? " OR ( IF((SELECT SUM(transactions.amount) ".
                "            	FROM transactions, accounts ".
                "            	WHERE transactions.accountid = accounts.id ".
                "           	AND accounts.currencyid = cur.id ".
                "           	AND accounts.paymentmethodid = -1) IS NOT NULL, ".
                "               ROUND((SELECT SUM(transactions.amount) ".
                "                	FROM transactions, accounts ".
                "                	WHERE transactions.accountid = accounts.id ".
                "               	AND accounts.currencyid = cur.id ".
                "               	AND accounts.paymentmethodid = -1), cur.decimals), ".
                "               0) ".
                "           + IF((SELECT SUM(deposits.amount - deposits.fee) ".
                "               FROM accounts, transactions, deposits ".
                "               WHERE transactions.id = deposits.transactionid ".
                "               AND deposits.rejected IS NULL ".
                "               AND deposits.valid IS NULL ".
                "               AND accounts.id = transactions.accountid ".
                "               AND accounts.currencyid = cur.id ".
                "               AND transactions.amountghost >= 0) IS NOT NULL,".
                "               ROUND((SELECT SUM(deposits.amount - deposits.fee) ".
                "                   FROM accounts, transactions, deposits ".
                "                   WHERE transactions.id = deposits.transactionid ".
                "                   AND deposits.rejected IS NULL ".
                "                   AND deposits.valid IS NULL ".
                "                   AND accounts.id = transactions.accountid ".
                "                   AND accounts.currencyid = cur.id ".
                "                   AND transactions.amountghost >= 0), cur.decimals), ".
                "            0)) LIKE '%".parseFormattedNumber($el)."%'" : ''));
            }else{
                $filter .= ( !$dateAndHour ? " (SELECT DATE(transactions.datecreated) FROM  transactions, accounts ".
                " 	            WHERE accounts.currencyid = cur.id ".
                "          	    AND accounts.id = transactions.accountid ".
                "         	    AND transactions.datecreated = (SELECT MAX(transactions.datecreated) FROM transactions WHERE accounts.id = transactions.accountid) ".
                "         	    ORDER BY transactions.datecreated DESC, transactions.id DESC ".
                "    		    LIMIT 1 ".
                "           ) = DATE('".$dateel."') " : '').
                ( $dateAndHour ? " (SELECT DATE_FORMAT(transactions.datecreated,'%Y-%m-%d %l:%i') FROM  transactions, accounts ".
                " 	            WHERE accounts.currencyid = cur.id ".
                "          	    AND accounts.id = transactions.accountid ".
                "         	    AND transactions.datecreated = (SELECT MAX(transactions.datecreated) FROM transactions WHERE accounts.id = transactions.accountid) ".
                "         	    ORDER BY transactions.datecreated DESC, transactions.id DESC ".
                "    		    LIMIT 1 ".
                "           ) = DATE_FORMAT('".$dateelhour."','%Y-%m-%d %l:%i') " : '').
                "           OR cur.symbol LIKE '".$el."%' ".
                "           ".(validNumber($el) ? " OR (SELECT COUNT(accounts.id) ".
                "        	    FROM accounts ".
                "   	    	WHERE accounts.currencyid = cur.id ".
                "               AND accounts.paymentmethodid = -1 ".
                "           ) LIKE '%".floatval($el)."%'" : (validNumberFormatted($el) ? " OR (SELECT COUNT(accounts.id) ".
                "        	    FROM accounts ".
                "   	    	WHERE accounts.currencyid = cur.id ".
                "               AND accounts.paymentmethodid = -1 ".
                "           ) LIKE '%".parseFormattedNumber($el)."%'" : '') ).
                "           ".(validNumber($el) ? " OR IF((SELECT SUM(transactions.amount) ".
                "        	    FROM transactions, accounts ".
                "        	    WHERE transactions.accountid = accounts.id ".
                "       	    AND accounts.currencyid = cur.id ".
                "       	    AND accounts.paymentmethodid = -1) IS NOT NULL, ".
                "               ROUND((SELECT SUM(transactions.amount) ".
                "        	        FROM transactions, accounts ".
                "        	        WHERE transactions.accountid = accounts.id ".
                "       	        AND accounts.currencyid = cur.id ".
                "       	        AND accounts.paymentmethodid = -1), cur.decimals), ".
                "                0) LIKE '%".floatval($el)."%'" : (validNumberFormatted($el) ? " OR IF((SELECT SUM(transactions.amount) ".
                "        	    FROM transactions, accounts ".
                "        	    WHERE transactions.accountid = accounts.id ".
                "       	    AND accounts.currencyid = cur.id ".
                "       	    AND accounts.paymentmethodid = -1) IS NOT NULL, ".
                "               ROUND((SELECT SUM(transactions.amount) ".
                "        	        FROM transactions, accounts ".
                "        	        WHERE transactions.accountid = accounts.id ".
                "       	        AND accounts.currencyid = cur.id ".
                "       	        AND accounts.paymentmethodid = -1), cur.decimals), ".
                "                0) LIKE '%".parseFormattedNumber($el)."%'" : '')).
                "           ".(validNumber($el) ? " OR IF((SELECT SUM(deposits.amount - deposits.fee) ".
                "               FROM accounts, transactions, deposits ".
                "               WHERE transactions.id = deposits.transactionid ".
                "               AND deposits.rejected IS NULL ".
                "               AND deposits.valid IS NULL ".
                "               AND accounts.id = transactions.accountid ".
                "               AND accounts.currencyid = cur.id ".
                "               AND transactions.amountghost >= 0) IS NOT NULL,".
                "               ROUND((SELECT SUM(deposits.amount - deposits.fee) ".
                "                   FROM accounts, transactions, deposits ".
                "                   WHERE transactions.id = deposits.transactionid ".
                "                   AND deposits.rejected IS NULL ".
                "                   AND deposits.valid IS NULL ".
                "                   AND accounts.id = transactions.accountid ".
                "                   AND accounts.currencyid = cur.id ".
                "                   AND transactions.amountghost >= 0), cur.decimals), ".
                "            0) LIKE '%".floatval($el)."%'" : ( validNumberFormatted($el) ? " OR IF((SELECT SUM(deposits.amount - deposits.fee) ".
                "               FROM accounts, transactions, deposits ".
                "               WHERE transactions.id = deposits.transactionid ".
                "               AND deposits.rejected IS NULL ".
                "               AND deposits.valid IS NULL ".
                "               AND accounts.id = transactions.accountid ".
                "               AND accounts.currencyid = cur.id ".
                "               AND transactions.amountghost >= 0) IS NOT NULL,".
                "               ROUND((SELECT SUM(deposits.amount - deposits.fee) ".
                "                   FROM accounts, transactions, deposits ".
                "                   WHERE transactions.id = deposits.transactionid ".
                "                   AND deposits.rejected IS NULL ".
                "                   AND deposits.valid IS NULL ".
                "                   AND accounts.id = transactions.accountid ".
                "                   AND accounts.currencyid = cur.id ".
                "                   AND transactions.amountghost >= 0), cur.decimals), ".
                "            0) LIKE '%".parseFormattedNumber($el)."%'" : '')).
                "           ".(validNumber($el) ? " OR ( IF((SELECT SUM(transactions.amount) ".
                "            	FROM transactions, accounts ".
                "            	WHERE transactions.accountid = accounts.id ".
                "           	AND accounts.currencyid = cur.id ".
                "           	AND accounts.paymentmethodid = -1) IS NOT NULL, ".
                "               ROUND((SELECT SUM(transactions.amount) ".
                "                	FROM transactions, accounts ".
                "                	WHERE transactions.accountid = accounts.id ".
                "               	AND accounts.currencyid = cur.id ".
                "               	AND accounts.paymentmethodid = -1), cur.decimals),".
                "               0) ".
                "           + IF((SELECT SUM(deposits.amount - deposits.fee) ".
                "               FROM accounts, transactions, deposits ".
                "               WHERE transactions.id = deposits.transactionid ".
                "               AND deposits.rejected IS NULL ".
                "               AND deposits.valid IS NULL ".
                "               AND accounts.id = transactions.accountid ".
                "               AND accounts.currencyid = cur.id ".
                "               AND transactions.amountghost >= 0) IS NOT NULL,".
                "               ROUND((SELECT SUM(deposits.amount - deposits.fee) ".
                "                   FROM accounts, transactions, deposits ".
                "                   WHERE transactions.id = deposits.transactionid ".
                "                   AND deposits.rejected IS NULL ".
                "                   AND deposits.valid IS NULL ".
                "                   AND accounts.id = transactions.accountid ".
                "                   AND accounts.currencyid = cur.id ".
                "                   AND transactions.amountghost >= 0), cur.decimals), ".
                "            0)) LIKE '%".floatval($el)."%'" : (validNumberFormatted($el) ? " OR ( IF((SELECT SUM(transactions.amount) ".
                "            	FROM transactions, accounts ".
                "            	WHERE transactions.accountid = accounts.id ".
                "           	AND accounts.currencyid = cur.id ".
                "           	AND accounts.paymentmethodid = -1) IS NOT NULL, ".
                "               ROUND((SELECT SUM(transactions.amount) ".
                "                	FROM transactions, accounts ".
                "                	WHERE transactions.accountid = accounts.id ".
                "               	AND accounts.currencyid = cur.id ".
                "               	AND accounts.paymentmethodid = -1), cur.decimals), ".
                "               0) ".
                "           + IF((SELECT SUM(deposits.amount - deposits.fee) ".
                "               FROM accounts, transactions, deposits ".
                "               WHERE transactions.id = deposits.transactionid ".
                "               AND deposits.rejected IS NULL ".
                "               AND deposits.valid IS NULL ".
                "               AND accounts.id = transactions.accountid ".
                "               AND accounts.currencyid = cur.id ".
                "               AND transactions.amountghost >= 0) IS NOT NULL,".
                "               ROUND((SELECT SUM(deposits.amount - deposits.fee) ".
                "                   FROM accounts, transactions, deposits ".
                "                   WHERE transactions.id = deposits.transactionid ".
                "                   AND deposits.rejected IS NULL ".
                "                   AND deposits.valid IS NULL ".
                "                   AND accounts.id = transactions.accountid ".
                "                   AND accounts.currencyid = cur.id ".
                "                   AND transactions.amountghost >= 0), cur.decimals), ".
                "            0)) LIKE '%".parseFormattedNumber($el)."%'" : ''));
            }
        }
        
        $filter .= " ) ";
    }
    
    //En caso de que el currencyid sea enviado, se construye el query
    if(isset($_GET["currencyid"]) && $_GET["currencyid"] != ""){
        $currencyid = " cur.id = ".$_GET['currencyid'];
    }
    
    // WHERE CLAUSE
    if( $currencyid != "" && $filter != ""){
        $whereclause = ' WHERE '.$currencyid.
        '           OR '.$filter;
    }else if($currencyid == "" && $filter != ""){
        $whereclause = ' WHERE '.$filter;
    }else if($filter == "" && $currencyid != ""){
        $whereclause = ' WHERE '.$currencyid;
    }
    
    //$out->testing = $whereclause;
    
    /*
   SELECT cur.id AS currencyid, cur.symbol AS currencysymbol, 
           cur.name AS currencyname, cur.decimals AS currencydecimals, 
           (SELECT COUNT(accounts.id) 
            	FROM accounts 
       		WHERE accounts.currencyid = cur.id 
               AND accounts.paymentmethodid = -1 
           ) AS qtywallets, 
           IF((SELECT SUM(transactions.amount) 
            	FROM transactions, accounts 
            	WHERE transactions.accountid = accounts.id 
           	AND accounts.currencyid = cur.id 
           	AND accounts.paymentmethodid >= -1 
           ) IS NOT NULL, (SELECT SUM(transactions.amount) 
            	FROM transactions, accounts 
            	WHERE transactions.accountid = accounts.id 
           	AND accounts.currencyid = cur.id 
           	AND accounts.paymentmethodid >= -1 
           ), 0) AS avaliable, 
           IF((SELECT SUM(deposits.amount - deposits.fee) 
               FROM accounts, transactions, deposits 
               WHERE transactions.id = deposits.transactionid 
               AND deposits.rejected IS NULL 
               AND deposits.valid IS NULL 
               AND accounts.id = transactions.accountid 
               AND accounts.currencyid = cur.id 
               AND transactions.amountghost >= 0 
           ) IS NOT NULL, (SELECT SUM(deposits.amount - deposits.fee) 
               FROM accounts, transactions, deposits 
               WHERE transactions.id = deposits.transactionid 
               AND deposits.rejected IS NULL 
               AND deposits.valid IS NULL 
               AND accounts.id = transactions.accountid 
               AND accounts.currencyid = cur.id 
               AND transactions.amountghost >= 0 
           ), 0) AS deferred, 
           ( IF((SELECT SUM(transactions.amount) 
                	FROM transactions, accounts 
                	WHERE transactions.accountid = accounts.id 
               	AND accounts.currencyid = cur.id 
               	AND accounts.paymentmethodid >= -1) IS NOT NULL, 
               (SELECT SUM(transactions.amount) 
                    	FROM transactions, accounts 
                    	WHERE transactions.accountid = accounts.id 
                   	AND accounts.currencyid = cur.id 
                   	AND accounts.paymentmethodid >= -1),
               0) 
           + IF((SELECT SUM(deposits.amount - deposits.fee) 
                   FROM accounts, transactions, deposits 
                   WHERE transactions.id = deposits.transactionid 
                   AND deposits.rejected IS NULL 
                   AND deposits.valid IS NULL 
                   AND accounts.id = transactions.accountid 
                   AND accounts.currencyid = cur.id 
                   AND transactions.amountghost >= 0) IS NOT NULL,
                   (SELECT SUM(deposits.amount - deposits.fee) 
                       FROM accounts, transactions, deposits 
                       WHERE transactions.id = deposits.transactionid 
                       AND deposits.rejected IS NULL 
                       AND deposits.valid IS NULL 
                       AND accounts.id = transactions.accountid 
                       AND accounts.currencyid = cur.id 
                       AND transactions.amountghost >= 0), 
                0)) AS total, 
           (SELECT transactions.datecreated FROM  transactions, accounts 
     	        WHERE accounts.currencyid = cur.id 
              	AND accounts.id = transactions.accountid 
             	AND transactions.datecreated = (SELECT MAX(transactions.datecreated) FROM transactions WHERE accounts.id = transactions.accountid) 
             	ORDER BY transactions.datecreated DESC, transactions.id DESC 
        		LIMIT 1 
           ) AS lasttx 
           FROM currencies cur
    */
    $sql = "SELECT COUNT(cur.id) AS qty".
    "       FROM currencies cur ".
    "       ".$whereclause;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error.$sql));
        
    $row = $rs->fetch_assoc();
    
    $out->numofrecords = (int)$row['qty'];
    
    $sql = "SELECT cur.id AS currencyid, cur.symbol AS currencysymbol, ".
    "       cur.name AS currencyname, cur.decimals AS currencydecimals, ".
    "       (SELECT COUNT(accounts.id) ".
    "        	FROM accounts ".
    "   		WHERE accounts.currencyid = cur.id ".
    "           AND accounts.paymentmethodid = -1 ".
    "       ) AS qtywallets, ".
    "       IF((SELECT SUM(transactions.amount) ".
    "        	FROM transactions, accounts ".
    "        	WHERE transactions.accountid = accounts.id ".
    "       	AND accounts.currencyid = cur.id ".
    "       	AND accounts.paymentmethodid = -1 ".
    "       ) IS NOT NULL, (SELECT SUM(transactions.amount) ".
    "        	FROM transactions, accounts ".
    "        	WHERE transactions.accountid = accounts.id ".
    "       	AND accounts.currencyid = cur.id ".
    "       	AND accounts.paymentmethodid = -1 ".
    "       ), 0) AS avaliable, ".
    "       IF((SELECT SUM(deposits.amount - deposits.fee) ".
    "           FROM accounts, transactions, deposits ".
    "           WHERE transactions.id = deposits.transactionid ".
    "           AND deposits.rejected IS NULL ".
    "           AND deposits.valid IS NULL ".
    "           AND accounts.id = transactions.accountid ".
    "           AND accounts.currencyid = cur.id ".
    "           AND transactions.amountghost >= 0 ".
    "       ) IS NOT NULL, (SELECT SUM(deposits.amount - deposits.fee) ".
    "           FROM accounts, transactions, deposits ".
    "           WHERE transactions.id = deposits.transactionid ".
    "           AND deposits.rejected IS NULL ".
    "           AND deposits.valid IS NULL ".
    "           AND accounts.id = transactions.accountid ".
    "           AND accounts.currencyid = cur.id ".
    "           AND transactions.amountghost >= 0 ".
    "       ), 0) AS deferred, ".
    "       ( IF((SELECT SUM(transactions.amount) ".
    "            	FROM transactions, accounts ".
    "            	WHERE transactions.accountid = accounts.id ".
    "           	AND accounts.currencyid = cur.id ".
    "           	AND accounts.paymentmethodid = -1) IS NOT NULL, ".
    "           (SELECT SUM(transactions.amount) ".
    "                	FROM transactions, accounts ".
    "                	WHERE transactions.accountid = accounts.id ".
    "               	AND accounts.currencyid = cur.id ".
    "               	AND accounts.paymentmethodid = -1),".
    "           0) ".
    "       + IF((SELECT SUM(deposits.amount - deposits.fee) ".
    "               FROM accounts, transactions, deposits ".
    "               WHERE transactions.id = deposits.transactionid ".
    "               AND deposits.rejected IS NULL ".
    "               AND deposits.valid IS NULL ".
    "               AND accounts.id = transactions.accountid ".
    "               AND accounts.currencyid = cur.id ".
    "               AND transactions.amountghost >= 0) IS NOT NULL,".
    "               (SELECT SUM(deposits.amount - deposits.fee) ".
    "                   FROM accounts, transactions, deposits ".
    "                   WHERE transactions.id = deposits.transactionid ".
    "                   AND deposits.rejected IS NULL ".
    "                   AND deposits.valid IS NULL ".
    "                   AND accounts.id = transactions.accountid ".
    "                   AND accounts.currencyid = cur.id ".
    "                   AND transactions.amountghost >= 0), ".
    "            0)) AS total, ".
    "       (SELECT transactions.datecreated FROM  transactions, accounts ".
    " 	        WHERE accounts.currencyid = cur.id ".
    "          	AND accounts.id = transactions.accountid ".
    "         	AND transactions.datecreated = (SELECT MAX(transactions.datecreated) FROM transactions WHERE accounts.id = transactions.accountid) ".
    "         	ORDER BY transactions.datecreated DESC, transactions.id DESC ".
    "    		LIMIT 1 ".
    "       ) AS lasttx ".
    "       FROM currencies cur".
    "       ".$whereclause.
    "       ".$order.
    "       LIMIT ".$offset.", ".$numofrec;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error.$sql));
    
    //Ordenamos los datos
    while($row = $rs->fetch_assoc()){
        $record = new stdClass();
        $record->currency = new stdClass();
        $record->currency->name = $row['currencyname'];
        $record->currency->symbol = $row['currencysymbol'];
        
        $record->accounts = numberFormatt($row['qtywallets'],0);
        $record->avaliable = $row['avaliable'] == null || $row['avaliable'] < 0 ? numberFormatt(0, $row['currencydecimals']) : numberFormatt($row['avaliable'], $row['currencydecimals']);
        $record->pending = $row['deferred'] == null || $row['deferred'] < 0 ? numberFormatt(0, $row['currencydecimals']) : numberFormatt($row['deferred'], $row['currencydecimals']);
        $record->total = $row['total'] == null || $row['total'] < 0 ? numberFormatt(0, $row['currencydecimals']) : numberFormatt($row['total'], $row['currencydecimals']);
        $record->last = $row['lasttx'] == null ? '' : date("d/m/Y", strtotime($row["lasttx"]))." - ".date("h:i a", strtotime($row["lasttx"]));
        
        $records [] = $record;
    }
    
    $out->records = $records;
    //Retornamos los privilegios del usuario en este modulo
    $access = new stdClass;
    $access->read = tienePrivilegio($db, $sessionid, 36);
    $out->privileges = $access;
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
    
    /*  Funcion para determinar el orden de los resultados, donde:
    *   0 = Ultima transferencia
    *   1 = Cantidad cuentas ASCENDENTE
    *   2 = Saldo disponible ASCENDENTE
    *   3 = Saldo pendiente ASCENDENTE
    *   4 = Saldo total ASCENDENTE
    *   5 = Ultima operacion ASCENDENTE
    *   -1 = Cantidad cuentas DESCENTE
    *   -2 = Saldo disponible DESCENTE
    *   -3 = Saldo pendiente DESCENTE
    *   -4 = Saldo total DESCENTE
    *   -5 = Ultima operacion DESCENDENTE
    *   Y si el order es enviado si ser algunos de estos valores,
    */
    function determinateOrder($order){
        $orderres = "";
        switch($order){
            case 0:
                $orderres = "ORDER BY lasttx DESC, cur.id DESC";
                break;
            case 1:
                $orderres = "ORDER BY qtywallets ASC";
                break;
            case 2:
                $orderres = "ORDER BY avaliable ASC";
                break;
            case 3:
                $orderres = "ORDER BY deferred ASC";
                break;
            case 4:
                $orderres = "ORDER BY total ASC";
                break;
            case 5:
                $orderres = "ORDER BY lasttx ASC, cur.id DESC";
                break;
            case -1:
                $orderres = "ORDER BY qtywallets DESC";
                break;
            case -2:
                $orderres = "ORDER BY avaliable DESC";
                break;
            case -3:
                $orderres = "ORDER BY deferred DESC";
                break;
            case -4:
                $orderres = "ORDER BY total DESC";
                break;
            case -5:
                $orderres = "ORDER BY lasttx DESC, cur.id DESC";
                break;
            default:
                $orderres = "ORDER BY lasttx DESC, cur.id DESC";
                break;
        }
        
        return $orderres;
    }
?>
