<?php
// cms/api/roles/update

    header("Content-Type:application/json");
    include("../dbconn.php");
    include("../utils.php");
    
    // parametros obligatorios
    $parmsob = array("sessionid","id","name","status");
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    //Declaramos e inicializamos nuestras variables
    $out= new stdClass;
    $sessionid = $_GET["sessionid"];
    $id = $_GET["id"];
    $name = $_GET["name"];
    $status = $_GET["status"];
    
    //Validamos que la session del usuario sea valida para continuar
    isSessionValidCMS($db, $sessionid);
    
    //Si el id es igual a 0, se crea, si no se actualiza el rol
    if($id == 0){
        
        //Validamos que tenga privilegios para crear
        if (!tienePrivilegio($db, $sessionid, 7))
            badEnd("403", array("msg"=>"No tiene Privilegios"));
        
        $sql = "INSERT INTO cmsusers(usr, name, status, datecreated, type)".
        "       VALUES ('".$name."', '".$name."', ".$status.", NOW(), 1)";
        if (!$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
            
        // Retornamos el id que fue insertado
        $out->id = (int)$db->insert_id;
        
        //auditoria
        setAudit($db, "ROLES", $sessionid, "CMS", "Se agregó el rol ".$name);
    }else{
        
        //Validamos que tenga privilegios para editar/actualizar
        if (!tienePrivilegio($db, $sessionid, 8))
            badEnd("403", array("msg"=>"No tiene Privilegios"));
        
        //Consultamos para validar que el registro exista
        $sql = "SELECT name, status FROM cmsusers WHERE id = ".$id." AND type = 1";
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
            
        $row = $rs->fetch_assoc();
        
        // Retornamos 204 cuando la busqueda no obtiene resutados
        if($row["name"] == null){
            badEnd("204", array("msg"=>"No se encuentra el registro"));
        }
        
        //Actualizamos el usuario
        $sql = "UPDATE cmsusers SET".
        "       usr = '".$name."', ".
        "       name = '".$name."', ".
        "       status = ".$status." ".
        "       WHERE id = ".$id." AND type = 1";
        if (!$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
        
        //Retornamos 304 si no se actualizo ningun registro
        if ($db->affected_rows == 0)
            badEnd("304", array("msg"=>"No se pudo modificar"));
    
        $out->id = (int)$id;
        
        //auditoria
        setAudit($db, "ROLES", $sessionid, "CMS", "Se actualizó el rol ".$name);
    }
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>
