<?php
// app/api/uploads/list

    header("Content-Type:application/json");
    include("../dbconn.php");
    include("../utils.php");
    
    // parametros obligatorios
    $parmsob = array("sessionid","type");
    if (!parametrosValidos($_GET, $parmsob)){
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(",", $parmsob)));
    }
    
    //Definicion de variables y almacenamiento de valores enviados por GET
    $out= new stdClass;
    $sessionid = $_GET["sessionid"];
    $type = $_GET["type"];
    
    //Validamos la session
    isSessionValid($db, $sessionid);
    
    $sql = "SELECT id, dsc, activo, type FROM cmsprefuploads".
    "       WHERE type LIKE '%".$type."%'";
    if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
            
    //Inicializamos el contador para conocer la cantidad de records
    $count = 0;
    while($uploadsarr = $rs->fetch_assoc()){
        $record = new stdClass();
        $record->id = str_pad($uploadsarr["id"], 2, "0", STR_PAD_LEFT);
        $record->dsc = $uploadsarr["dsc"];
        $record->type = new stdClass();
        $record->type->id = (int) $type;
        
        
        /*  Enviamos el tipo de dsc donde: 
        *   1 == Persona natural;
        *   2 == Persona Juridica;
        *   3 == Adicional;
        */
        $typedsc = "";
        if($type == 1){
            $typedsc = "Persona Natural";
        }else if($type == 2){
            $typedsc = "Persona Juridica";
        }else if($type == 0){
            $typedsc = "Adicional";
        }
        
        $record->type->dsc = $typedsc;
        
        $record->level = new stdClass();
        
        //Consultamos los datos del nivel
        $sql = "SELECT * FROM levels";
        if (!$resUp=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
            
        while($levelsTemp = $resUp->fetch_assoc()){
            
            $levelsarrTemp = explode("-",$levelsTemp["cmsprefuploads"]);
            foreach($levelsarrTemp as $whichlevel){
                if($uploadsarr["id"] == $whichlevel){
                    $record->level->id = (int)$levelsTemp["orden"];
                    $record->level->dsc = $levelsTemp["name"];
                }
            }
        }
        
        $records[] = $record;
        $count++;
    }
    
    //Retornamos la cantidad de records y cada record a detalle
    $out->numofrecords = $count;
    $out->records = $records;
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>
