<?php
// cms/api/countries/entry

    header("Content-Type:application/json");
    include("../dbconn.php");
    include("../utils.php");
    
    // parametros obligatorios
    $parmsob = array("sessionid","id");
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    //Declaramos e inicializamos nuestras variables
    $out= new stdClass;
    $sessionid = $_GET["sessionid"];
    $id = $_GET["id"];
    
    //Validamos que la session del usuario sea valida para continuar
    isSessionValidCMS($db, $sessionid);
    
    //Validamos que el usuario tenga privilegios
    if(!tienePrivilegio($db, $sessionid, 47))
        badEnd("403", array("msg"=>"No tiene Privilegios"));
    
    //Consultamos los datos que se necesitan del pais
    $sql = "SELECT id, name, status FROM countries".
    "       WHERE id =".$id;
    if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
            
            
    //Ordenamos los valores
    $row = $rs->fetch_assoc();
    $out->entry = new stdClass();
    $out->entry->id = (int)$row["id"];
    $out->entry->dsc = $row["name"];
    $out->entry->status = new stdClass();
    $out->entry->status->id = (int)$row["status"];
    $out->entry->status->dsc =  $out->entry->status->id == 1 ? "Activo" : "Inactivo";
    
    //Retornamos los privilegios del usuario actual
    $access = new stdClass;
    $access->create = tienePrivilegio($db, $sessionid, 44);
    $access->read =   tienePrivilegio($db, $sessionid, 47);
    $access->update = tienePrivilegio($db, $sessionid, 45);
    $access->delete = tienePrivilegio($db, $sessionid, 46);
    $out->privileges = $access;
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>
