<?php
// cms/api/preferences/savelimits

    header("Content-Type:application/json");
    include("../dbconn.php");
    include("../utils.php");
    
    // parametros obligatorios
    $parmsob = array("sessionid",'levelid','currencyid','usertype','maxmensualdeposit','opmensualdeposit','maxmensualwithdraw','opmensualwithdraw','maxmensualxfer');
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    //Declaramos e inicializamos nuestras variables
    $out = new stdClass();
    $sessionid = $_GET["sessionid"];
    $levelid = $_GET['levelid'];
    $currencyid = $_GET['currencyid'];
    $usertype = $_GET['usertype'];
    $maxmensualdeposit = $_GET['maxmensualdeposit'];
    $opmensualdeposit = $_GET['opmensualdeposit'];
    $maxmensualwithdraw = $_GET['maxmensualwithdraw'];
    $opmensualwithdraw = $_GET['opmensualwithdraw'];
    $maxmensualxfer = $_GET['maxmensualxfer'];
    
    //Validamos que la session del usuario sea valida para continuar
    isSessionValidCMS($db, $sessionid);
    
    //Validamos que el usuario tenga privilegios
    if(!tienePrivilegio($db, $sessionid, 56))
        badEnd("403", array("msg"=>"No tiene Privilegios"));
        
        
    //Validamos que exista el registro a modificar
    $sql = "SELECT COUNT(levelid) AS qty ".
    "       FROM cmspreffees ".
    "       WHERE levelid = ".$levelid.
    "       AND currencyid = ".$currencyid.
    "       AND usertype = ".$usertype;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error.$sql));
    
    $row = $rs->fetch_assoc();
    
    //SI es igual a 0 no existe
    if($row['qty'] == 0){
        badEnd('204',array('msg'=>'Registro no encontrado'));
    }
    
    // Actualizamos los limites
    $sql = "UPDATE cmspreffees SET ".
    "       maxqtymonthlyopdeposits = ".$opmensualdeposit.", ".
    "       maxamountmonthlyopdeposits = ".(validNumber($maxmensualdeposit) ? floatval($maxmensualdeposit) : (validNumberFormatted($maxmensualdeposit) ? floatval(parseFormattedNumber($maxmensualdeposit))  : '')).", ".
    "       maxqtymonthlyopwithdrawals = ".$opmensualwithdraw.", ".
    "       maxamountmonthlyopwithdrawals = ".(validNumber($maxmensualwithdraw) ? floatval($maxmensualwithdraw) : (validNumberFormatted($maxmensualwithdraw) ? floatval(parseFormattedNumber($maxmensualwithdraw))  : '')).", ".
    "       maxamountmonthlyopxfer = ".(validNumber($maxmensualxfer) ? floatval($maxmensualxfer) : (validNumberFormatted($maxmensualxfer) ? floatval(parseFormattedNumber($maxmensualxfer))  : '')).
    "       WHERE levelid = ".$levelid.
    "       AND currencyid = ".$currencyid.
    "       AND usertype = ".$usertype;
    if (!$db->query($sql))
        badEnd("500", array("msg"=>$db->error.$sql));
        
    $out->quepasa = $sql;

    //Consultamos el nombre de la moneda para mostrarlo en la auditoria
    $sql = "SELECT name FROM currencies WHERE id = ".$currencyid;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error.$sql));
    
    $row = $rs->fetch_assoc();
    
    //auditoria
    setAudit($db, "PREFERENCIAS", $sessionid, "CMS", "Se actualizaron los límites para la moneda ".$row['name'].", Persona ".($usertype == 1 ? 'Natural' : 'Jurídica').", Nivel ".$levelid);  
    
    $out->levelid = (int)$levelid;
    $out->currencyid = (int)$currencyid;
    $out->usertype = (int)$usertype;
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>
