<?php
// app/api/accounts/portafolio

    header("Content-Type:application/json");
    include("../dbconn.php");
    include("../utils.php");
    
    // parametros obligatorios
    $parmsob = array("sessionid");
    if (!parametrosValidos($_GET, $parmsob)){
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(",", $parmsob)));
    }
    
    //Definicion de variables y almacenamiento de valores enviados por GET
    $out = new stdClass;
    $sessionid = $_GET["sessionid"];
    
    //Validamos la session
    isSessionValid($db, $sessionid);
    
    //Obtenemos el id del usuario
    $sql = "SELECT id, usr FROM users WHERE sessionid = '".$sessionid."'";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    $row = $rs->fetch_assoc();
    $userid = $row["id"];
    
    //Consultamos la cantidad de registros que existen
    $sql = "SELECT count(id) AS qty FROM accounts WHERE userid = ".$userid.
    "       ".$limit;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    //Retornamos el total de registros
    $row = $rs->fetch_assoc();
    $out->numofrecords = (int)$row["qty"];
    
    //Consultamos el balance total del usuario actual
    $sql = "SELECT SUM(transactions.quantity*transactions.amount) as qty ".
    "       FROM accounts, transactions".
	"       WHERE accounts.id = transactions.accountid AND accounts.userid = ".$userid;
	if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    $row = $rs->fetch_assoc();
    //Guardamos el valor
    $out->total = new stdClass();
	$out->total->number = (float)$row["qty"];
	$out->total->formatted = number_format($out->total->number,2,",",".");
    
    //Consultamos los datos requeridos
    $sql = "SELECT * FROM accounts WHERE userid = ".$userid.
    "       ".$limit;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
        
    while($row = $rs->fetch_assoc()){
        $record = new stdClass();
        //Guardamos el id de la cuenta
        $record->id = (int)$row["id"];
        
        //Metodo de pago
        $record->paymentmethod = new stdClass();
        $record->paymentmethod->id = (int)$row["paymentmethodid"];
        
        //Consultamos el nombre del metodo de pago
        $sql = "SELECT dsc ".
        "       FROM paymentmethods ".
        "       WHERE id = ".$row["paymentmethodid"];
        if (!$res=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
        
        $payment = $res->fetch_assoc();
        //Guardamos el nombre del metodo de pago
        $record->paymentmethod->dsc = $payment["dsc"];

        //Moneda de la cuenta
        $record->currency = new stdClass();
        $record->currency->id = (int)$row["currencyid"];
        
        //Consultamos los datos de la moneda
        $sql = "SELECT id, name, symbol FROM currencies WHERE id = ".$row["currencyid"];
        if (!$res=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
        
        $currency = $res->fetch_assoc();
        //Guardamos los detalles de la moneda
        $record->currency->dsc = $currency["name"];
        $record->currency->symbol = $currency["symbol"];
        
        $sql = "SELECT SUM(quantity*amount) as qty FROM `transactions` WHERE accountid = ".$record->id;
        if (!$res=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
        
        $balance = $res->fetch_assoc();
        
        //Balance a partir de las transacciones
        $record->balance = (float)$balance["qty"];
        $record->balancedsc = number_format($record->balance,2,",",".");
        
        //Porcentaje que representa
        $record->pct = round($record->balance / ($out->total->number / 100),2);;
        $record->pctdsc = $record->pct."%";
        
        //Datos de la cuenta
        $record->status = (int)$row["status"];
        $record->details1 = $row["details1"] == null ? "" : $row["details1"] ;
        $record->details2 = $row["details2"] == null ? "" : $row["details2"] ;
        $record->details3 = $row["details3"] == null ? "" : $row["details3"] ;
        $record->details4 = $row["details4"] == null ? "" : $row["details4"] ;
        
        $records [] = $record;
    }
    
    $out->records = $records;
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>
