<?php
// app/api/paymentmethods/list

    header("Content-Type:application/json");
    include("../dbconn.php");
    include("../utils.php");
    
    // parametros obligatorios
    $parmsob = array("sessionid","countryid");
    if (!parametrosValidos($_GET, $parmsob)){
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(",", $parmsob)));
    }
    
    //Definicion de variables y almacenamiento de valores enviados por GET
    $out= new stdClass;
    $sessionid = $_GET["sessionid"];
    $offset = "";
    $numofrec = "";
    $limit = "";
    $countryid = $_GET["countryid"];
    
    //Validamos la session
    isSessionValid($db, $sessionid);
    
    //En caso de que el offset sea enviado, se construye el query
    if(isset($_GET["offset"]) && $_GET["offset"] != ""){
        $offset = $_GET["offset"];
    }else{
        $offset = "0";
    }
    
    //En caso de que el numofrec sea enviado, se construye el query
    if(isset($_GET["numofrec"]) && $_GET["numofrec"] != ""){
        $numofrec = $_GET["numofrec"];
    }
    
    if($offset != 0 && $numofrec == ""){
        $limit = " LIMIT ".$offset.", 18446744073709551615";
    }else if($offset != 0 && $numofrec != ""){
        $limit = " LIMIT ".$offset.", ".$numofrec;
    }else if($offset == 0 && $numofrec != ""){
        $limit = " LIMIT ".$numofrec;
    }else{
        $limit = " LIMIT ".$offset.", 18446744073709551615";
    }
    
    //Consultamos la cantidad de registros que existen
    $sql = "SELECT count(id) AS qty FROM paymentmethods WHERE countryid = ".$countryid;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    //Retornamos el total de registros
    $row = $rs->fetch_assoc();
    $out->numofrecords = (int)$row["qty"];
    
    //Consultamos los datos requeridos
    $sql = "SELECT * FROM paymentmethods WHERE countryid = ".$countryid.
    "       ".$limit;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
        
    while($row = $rs->fetch_assoc()){
        $record = new stdClass();
        //Guardamos el id de la cuenta
        $record->id = (int)$row["id"];
        $record->dsc = $row["dsc"];
        
        //Consultamos los datos del pais
        $sql = "SELECT id, name FROM countries WHERE id = ".$row["countryid"];
        if (!$res=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
            
            
        $country = $res->fetch_assoc();
        
        //Guardamos los datos del country
        $record->country = new stdClass();
        $record->country->id = (int)$country["id"];
        $record->country->dsc = $country["name"];
        
        $currencies = explode(",", $row["currencies"]);
        $currenciesarr = [];
        //Traemos los detalles de cada moneda que administra
        foreach($currencies as $curren){
            $sql = "SELECT * FROM currencies WHERE id = ".$curren;
            if (!$rescurren=$db->query($sql))
                badEnd("500", array("msg"=>$db->error));
            
            $rowcurren = $rescurren->fetch_assoc();
            
            $currendata = new stdClass();
            $currendata->id = (int)$rowcurren["id"];
            $currendata->dsc = $rowcurren["name"];
            $currendata->symbol = $rowcurren["symbol"];
            $currendata->default = $currendata->id == $row["currencyid"] ? true : false;
            
            $currenciesarr [] = $currendata;
        }
        
        $record->currencies = $currenciesarr;
        
        //Guardamos los detalles del metodo
        $record->details1 = $row["details1"] == null ? "" : $row["details1"];
        $record->details2 = $row["details2"] == null ? "" : $row["details2"];
        $record->details3 = $row["details3"] == null ? "" : $row["details3"];
        $record->details4 = $row["details4"] == null ? "" : $row["details4"];
        
        $records [] = $record;
    }
        
    $out->records = $records;
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>
