<?php
// cms/api/operations/accept

    header("Content-Type:application/json");
    include("../dbconn.php");
    include("../utils.php");
    
    // parametros obligatorios
    $parmsob = array("sessionid","id");
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    //Declaramos e inicializamos nuestras variables
    $out= new stdClass;
    $sessionid = $_GET["sessionid"];
    $id = $_GET["id"];
    $paymentdate = "";
    $paymentref = "";
    
    //Validamos que la session del usuario sea valida para continuar
    isSessionValidCMS($db, $sessionid);
    
    //En caso de que el paymentdate sea enviado, se construye el query
    if(isset($_GET["paymentdate"]) && $_GET["paymentdate"] != ""){
        $paymentdate = " paymentdate = '".$_GET["paymentdate"]."', ";
    }
    
    //En caso de que el paymentref sea enviado, se construye el query
    if(isset($_GET["paymentref"]) && $_GET["paymentref"] != ""){
        $paymentref = " paymentref = '".$_GET["paymentref"]."', ";
    }
    
    //Validamos que el usuario tenga privilegios
    if(!tienePrivilegio($db, $sessionid, 31))
        badEnd("403", array("msg"=>"No tiene Privilegios"));
        
    //Validamos que exista el registro
    $sql = "SELECT id FROM transactions WHERE id = ".$id;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
            
    $row = $rs->fetch_assoc();
        
    // Retornamos 404 cuando la busqueda no obtiene resutados
    if($row["id"] == null){
        badEnd("404", array("msg"=>"No se encuentra el registro"));
    }
    
    $db->autocommit(FALSE);
    
    //Actualizamos la transaccion
    $sql = "UPDATE transactions SET".
    "       amount = amount + amountghost, ".
    "       amountghost = 0 ".
    "       WHERE txid = ".$id;
    if (!$db->query($sql)){
        $error = $db->error;
        $db->rollback();
        $db->close();
        badEnd("500", array("msg"=>$error));
    }
    
    //Colocamos la fecha de validacion del retiro
    $sql = "UPDATE withdrawals SET".
    "       ".$paymentref.
    "       ".$paymentdate.
    "       valid = NOW() ".
    "       WHERE transactionid = ".$id;
    if (!$db->query($sql)){
        $error = $db->error;
        $db->rollback();
        $db->close();
        badEnd("500", array("msg"=>$error));
    }
    
    //Colocamos la fecha de validacion del deposito
    $sql = "UPDATE deposits SET".
    "       valid = NOW() ".
    "       WHERE transactionid = ".$id;
    if (!$db->query($sql)){
        $error = $db->error;
        $db->rollback();
        $db->close();
        badEnd("500", array("msg"=>$error));
    }
    
    $out->id = (int)$id;
    
    //auditoria
    setAudit($db, "OPERACIONES", $sessionid, "CMS", "Se acepto el movimiento ".$out->id);
    
    $db->commit();
    $db->close();
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>
