<?php
// app/api/xfer/make

    header("Content-Type:application/json");
    include("../dbconn.php");
    include("../utils.php");
    
    // parametros obligatorios
    $parmsob = array("sessionid","originaccountid","usr","amount");
    if (!parametrosValidos($_GET, $parmsob)){
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(",", $parmsob)));
    }
    
    //Definicion de variables y almacenamiento de valores enviados por GET
    $out= new stdClass;
    $sessionid = $_GET["sessionid"];
    $originaccount = $_GET["originaccountid"];
    $usr = $_GET["usr"];
    $amount = (float)$_GET["amount"];
    
    if($amount <= 0){
        badEnd("403", array("msg"=>"Monto no puede ser menor o igual a 0"));
    }
    
    //Criptomonedas 
    $cryptoarr = array("BTC","LTC","ETH","PTR");
    //Monedas Fiat
    $fiatarr = array("BSS","$","€");
    
    //Validamos la session
    $idSessionUser = isSessionValid($db, $sessionid);
    
    //Validamos el si el usuario puede crear cuentas
    isLevelValid($db, $idSessionUser);
    
    //Validamos que el usuario no se este transfiriendo a si mismo
    $sql = "SELECT usr, id FROM users WHERE id = ".$idSessionUser;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    $userdesdata = $rs->fetch_assoc();
        
    if($userdesdata["usr"] == $usr){
        badEnd("400","No puede transferir a si mismo");
    }
    
    //Consultamos los datos del usuario que realiza la transferencia
    $sql = "SELECT accounts.currencyid AS accurrencyid, ".
    "       accounts.id AS accountid ".
    "       FROM accounts, users ".
    "       WHERE accounts.userid = users.id ".
    "       AND users.sessionid = '".$sessionid."' ".
    "       AND accounts.id = ".$originaccount;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    $accountdata = $rs->fetch_assoc();
    
    $sql = "SELECT SUM(amount) as qty FROM transactions WHERE accountid = ".$accountdata["accountid"];
    if (!$res=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    $balance = $res->fetch_assoc();
    
    $sql = "SELECT SUM(amount) AS qty ".
    "       FROM ( ".
    "           SELECT SUM(CASE WHEN orders.side = 1 THEN orders.quantity ELSE orders.total END) AS amount ".
    "           FROM orders ".
    "           WHERE orders.accountid = ".$accountdata["accountid"].
	"           AND orders.canceled IS NULL ".
    "       UNION ALL ".
    "           SELECT SUM(transactions.amount) AS amount ".
    "           FROM transactions, orders ".
    "           WHERE orders.id = transactions.orderid ".
    "           AND transactions.accountid = ".$accountdata["accountid"].
	"           AND orders.canceled IS NULL ".
	"           AND transactions.amount < 0".
    "       ) amount";
    if (!$res=$db->query($sql))
        badEnd("500", array("msg"=>$db->error.$sql));
        
    $balanceorder = $res->fetch_assoc();
    
    if(($balance["qty"] - $balanceorder['qty']) <= 0 || ($balance["qty"] - $balanceorder['qty']) < $amount){
        badEnd("403", array("msg"=>"Saldo insuficiente"));
    }
    
    //Consultamos el id del usuario
    $sql = "SELECT count(id) AS qty FROM users ".
    "       WHERE UPPER(usr) = UPPER('".$usr."')";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    $userdesdata = $rs->fetch_assoc();
        
    if($userdesdata["qty"] == 0){
        badEnd("404","Usuario no encontrado");
    }
    
    //Consultamos los datos del usuario para validar su nivel
    $sql = "SELECT id, usr, level, type FROM users ".
    "       WHERE UPPER(usr) = UPPER('".$usr."')";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    $userdesdatalevel = $rs->fetch_assoc();
        
    if($userdesdatalevel["level"] == 0){
        badEnd("404","Usuario no registrado o verificado en AFX");
    }
    
    //Consultamos los datos del usuario de destino
    $sql = "SELECT accounts.id AS accountid ".
    "       FROM accounts, users ".
    "       WHERE accounts.userid = users.id ".
    "       AND users.usr = '".$usr."'".
    "       AND accounts.currencyid = ".$accountdata["accurrencyid"].
    "       AND accounts.paymentmethodid = -1";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    $accountdestination = $rs->fetch_assoc();
    
    //Si el usuario posee una cuenta en la moneda de origen puede continuar
    //Si no se le genera una
    if($accountdestination["accountid"] == null){
        
        //Consultamos los datos de la moneda para validar que tipo es
        $sql = "SELECT * FROM currencies ".
        "       WHERE id = ".$accountdata["accurrencyid"];
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
        
        $currencydata = $rs->fetch_assoc();
        
        //Consultamos el id del usuario
        $sql = "SELECT * FROM users ".
        "       WHERE UPPER(usr) = UPPER('".$usr."')";
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
        
        $userdesdata = $rs->fetch_assoc();
        
        $isCripto = false;
        $isFiat = false;
    
        foreach($cryptoarr as $crypto){
            if($crypto == $currencydata["symbol"]){
                $isCripto = true;
            }
        }
    
        foreach($fiatarr as $fiat){
            if(strtoupper($fiat) == strtoupper($currencydata["symbol"])){
                $isFiat = true;
            }
        }
        
        
        $db->autocommit(FALSE);
        
        if($isCripto && !$isFiat){
            $randomWallet = randomString(30);
        
            //Insertamos la nueva cuenta
            $sql = "INSERT INTO accounts".
            "       (".
            "       paymentmethodid, ".
            "       userid, ".
            "       currencyid, ".
            "       details1, ".
            "       status ".
            "       )".
            "       VALUES(".
            "       -1, ".
            "       ".$userdesdata["id"].", ".
            "       ".$accountdata["accurrencyid"].", ".
            "       '".$randomWallet."', ".
            "       1 ".
            "       )";
            if (!$db->query($sql)){
                $error = $db->error;
                $db->rollback();
                $db->close();
                badEnd("500", array("msg"=>$error." 1 ".$sql));
            }
            
            // Retornamos el id que fue insertado
            $idcreated = (int)$db->insert_id;
        
            //Al ser una cripto, creamos una wallet
            $sql = "INSERT INTO wallets".
            "       (".
            "       wallet, ".
            "       secretKey, ".
            "       accountid, ".
            "       expirationDate".
            "       )".
            "       VALUES(".
            "       '".$randomWallet."', ".
            "       '".randomString(8)."', ".
            "       ".$idcreated.", ".
            "       DATE_ADD(NOW(), INTERVAL 1 YEAR)".
            "       )";
            if (!$db->query($sql)){
                $error = $db->error;
                $db->rollback();
                $db->close();
                badEnd("500", array("msg"=>$error."2"));
            }
        
        }else if($isFiat && !$isCripto){
            //Insertamos la nueva cuenta
            $sql = "INSERT INTO accounts".
            "       (".
            "       paymentmethodid, ".
            "       userid, ".
            "       currencyid, ".
            "       status".
            "       )".
            "       VALUES(".
            "       -1, ".
            "       ".$userdesdata["id"].", ".
            "       ".$accountdata["accurrencyid"].", ".
            "       1".
            "       )";
            if (!$db->query($sql)){
                $error = $db->error;
                $db->rollback();
                $db->close();
                badEnd("500", array("msg"=>$error."3"));
            }
        }else{
            $db->rollback();
            $db->close();
            badEnd("500", array("msg"=>"No se logro determinar el tipo de moneda, avise para verificar el arreglo de monedas"));
        }
        
        $db->autocommit(TRUE);
        
        //Consultamos nuevamente los datos del usuario de destino
        $sql = "SELECT accounts.id AS accountid ".
        "       FROM accounts, users ".
        "       WHERE accounts.userid = users.id ".
        "       AND users.usr = '".$usr."'".
        "       AND accounts.currencyid = ".$accountdata["accurrencyid"].
        "       AND accounts.paymentmethodid = -1";
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
        
        $accountdestination = $rs->fetch_assoc();
    }
    
    //Consultamos la cuenta que tiene la moneda del retiro de AFX
    $sql = "SELECT * FROM accounts WHERE userid = -1".
    "       AND currencyid = ".$accountdata["accurrencyid"].
    "       AND paymentmethodid = -4";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
    
    //Guardamos la data de la cuenta AFX
    $afxdata = $rs->fetch_assoc();
    
    //Obtenemos el nivel de usuario para determinar su fee
    $sql = "SELECT * FROM users WHERE sessionid = '".$sessionid."'";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
    
    //Guardamos la data de la cuenta
    $userdata = $rs->fetch_assoc();
    
    $level = 1;
    
    if($userdata["level"] == 0){
        $level = 1;
    }else{
        $level = $userdata["level"];
    }
    
    //Obtenemos el fee de cada operacion por la moneda de la cuenta
    $sql = "SELECT * FROM cmspreffees WHERE currencyid = ".$accountdata["accurrencyid"].
    "       AND levelid = ".$level.
    "       AND usertype = ".$userdata["type"];
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
    
    //Guardamos la data de la cuenta
    $fee = $rs->fetch_assoc();
    
    /*
    //Validamos que el monto sea mas que el minimo aceptado
    if($fee["minbalance"] > $amount){
        badEnd("403", array("msg"=>"Monto no autorizado"));
    }*/
    
    //Calculamos el monto real quitandole la comision
    if($fee["pctfeexfer"] != null){
        if($fee["pctfeexfer"] == 0){
            $realfee = $amount - ($amount - $fee["nmlfeexfer"]);
            $realamount = $amount - $realfee;
        }else{
            $realfee = ($fee["pctfeexfer"]*$amount)/100;
            $realamount = $amount - $realfee;
        }
    }else{
        $realfee = (0.4*$amount)/100;
        $realamount = $amount - $realfee;
    }
    
    if($realamount <= 0){
        badEnd("403", array("msg"=>"Total neto no puede ser menor o igual a 0"));
    }
    
    //Obtenemos los datos de la moneda para saber si es cripto o FIAT
    $sql = "SELECT * FROM currencies WHERE id = ".$accountdata["accurrencyid"];
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
    
    //Guardamos la data de la cuenta AFX
    $row = $rs->fetch_assoc();
    
    //Obtenemos los datos del usuario de destino
    $sql = "SELECT users.id AS userid, ".
    "       users.usr AS userusr, ".
    "       users.type AS usertype, ".
    "       userpersons.fname AS userpersonfname, ".
    "       userpersons.flastname AS userpersonflastname, ".
    "       usercompanies.name AS usercompanyname ".
    "       FROM users".
    "       LEFT JOIN userpersons ON userpersons.usrid = users.id ".
    "       LEFT JOIN usercompanies ON usercompanies.usrid = users.id".
    "       WHERE users.usr = '".$usr."'";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    $userdestinationdata = $rs->fetch_assoc();
    
    //Validamos si es una criptomoneda o fiat
    $isCripto = false;
    $isFiat = false;
    
    foreach($cryptoarr as $crypto){
        if($crypto == $row["symbol"]){
            $isCripto = true;
        }
    }
    
    foreach($fiatarr as $fiat){
        if(strtoupper($fiat) == strtoupper($row["symbol"])){
            $isFiat = true;
        }
    }
    
    $validator = getValidator(8);
    
    $db->autocommit(FALSE);
        
    //insertamos la transferencia desde el origen
    $sql = "INSERT INTO transactions".
    "       (".
    "       datecreated, ".
    "       dsc, ".
    "       accountid, ".
    "       accountorigin, ".
    "       amount, ".
    "       amountghost, ".
    "       accountdestination, ".
    "       validator, ".
    "       validthru ".
    "       )".
    "       VALUES(".
    "       NOW(), ".
    "       'Transferencia', ".
    "       ".$accountdata["accountid"].", ".
    "       ".$accountdata["accountid"].", ".
    "       0, ".
    "       -".$realamount.", ".
    "       ".$accountdestination["accountid"].", ".
    "       '".$validator."', ".
    "       DATE_ADD(NOW(), INTERVAL 10 MINUTE)".
    "       )";
    if (!$db->query($sql)){
        $error = $db->error;
        $db->rollback();
        $db->close();
        badEnd("500", array("msg"=>$error."111"));
    }
    
    //Guardamos el id de la transaccion de deposito
    $txid = (int)$db->insert_id;
    $out->transactionid = $txid;
    
    //Le colocamos a la primera transferencia el txid
    $sql = "UPDATE transactions SET".
    "       txid= ".$txid.
    "       WHERE id = ".$txid;
    if (!$db->query($sql)){
        $error = $db->error;
        $db->rollback();
        $db->close();
        badEnd("500", array("msg"=>$error));
    }
    
    //insertamos el fee de la transferencia para el origen
    $sql = "INSERT INTO transactions".
    "       (".
    "       datecreated, ".
    "       dsc, ".
    "       accountid, ".
    "       txid, ".
    "       accountorigin, ".
    "       amountghost, ".
    "       amount, ".
    "       accountdestination, ".
    "       validator, ".
    "       validthru ".
    "       )".
    "       VALUES(".
    "       NOW(), ".
    "       'Comisión de Transferencia', ".
    "       ".$accountdata["accountid"].", ".
    "       ".$txid.", ".
    "       ".$accountdata["accountid"].", ".
    "       -".$realfee.", ".
    "       0, ".
    "       ".$afxdata["id"].", ".
    "       '".$validator."', ".
    "       DATE_ADD(NOW(), INTERVAL 10 MINUTE)".
    "       )";
    if (!$db->query($sql)){
        $error = $db->error;
        $db->rollback();
        $db->close();
        badEnd("500", array("msg"=>$error."222"));
    }
    
    //insertamos el fee de la transferencia
    $sql = "INSERT INTO transactions".
    "       (".
    "       datecreated, ".
    "       dsc, ".
    "       accountid, ".
    "       txid, ".
    "       accountorigin, ".
    "       amount, ".
    "       amountghost, ".
    "       accountdestination, ".
    "       validator, ".
    "       validthru ".
    "       )".
    "       VALUES(".
    "       NOW(), ".
    "       'Comisión de Transferencia', ".
    "       ".$afxdata["id"].", ".
    "       ".$txid.", ".
    "       ".$accountdata["accountid"].", ".
    "       0, ".
    "       ".$realfee.", ".
    "       ".$afxdata["id"].", ".
    "       '".$validator."', ".
    "       DATE_ADD(NOW(), INTERVAL 10 MINUTE)".
    "       )";
    if (!$db->query($sql)){
        $error = $db->error;
        $db->rollback();
        $db->close();
        badEnd("500", array("msg"=>$error."333"));
    }
    
    //insertamos la transferencia hacia el destino
    $sql = "INSERT INTO transactions".
    "       (".
    "       datecreated, ".
    "       dsc, ".
    "       accountid, ".
    "       txid, ".
    "       accountorigin, ".
    "       amount, ".
    "       amountghost, ".
    "       accountdestination, ".
    "       validator, ".
    "       validthru ".
    "       )".
    "       VALUES(".
    "       NOW(), ".
    "       'Transferencia', ".
    "       ".$accountdestination["accountid"].", ".
    "       ".$txid.", ".
    "       ".$accountdata["accountid"].", ".
    "       0, ".
    "       ".$realamount.", ".
    "       ".$accountdestination["accountid"].", ".
    "       '".$validator."', ".
    "       DATE_ADD(NOW(), INTERVAL 10 MINUTE)".
    "       )";
    if (!$db->query($sql)){
        $error = $db->error;
        $db->rollback();
        $db->close();
        badEnd("500", array("msg"=>$error."444".$sql));
    }
    
    //Datos del destinatario
    $out->destinationuser = new stdClass();
    $out->destinationuser->id = (int)$userdestinationdata["userid"];
    
    if($userdestinationdata["usertype"] == 1){
            $out->destinationuser->name = $userdestinationdata["userpersonfname"].($userdestinationdata["userpersonflastname"] == "" ? "" : " ".$userdestinationdata["userpersonflastname"]);
        }else{
            $out->destinationuser->name = $userdestinationdata["usercompanyname"];
        }
    
    //auditoria
    setAudit($db, "OPERACIONES", $sessionid, "APP", "El usuario ".$userdata["id"]." hizo la transferencia ".$out->transactionid);
    
    $db->commit();
    $db->close();
    
    $email = $userdata["usr"];
    $subject = "Código  de Transferencia AFX";
    $subject = '=?UTF-8?B?'.base64_encode($subject).'?=';
    $body = "Hola ".strtolower($email).", para completar la transferencia de fondos ingrese el c&oacute;digo a continuaci&oacute;n:<br><br>".
            "<b>".$validator."</b><br><br>".
            "<b>Este c&oacute;digo expirar&aacute; en 10 minutos.</b><br><br>".
            "<br>Gracias de antemano<br>AFX<br>";
            
    enviarCorreo($fromeMail, strtolower($email), $subject, $body);
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>
