<?php
// cms/api/transactions/update
    header("Content-Type:application/json");
    include("../dbconn.php");
    include("../utils.php");
    
    // parametros obligatorios
    $parmsob = array("sessionid",'id','date','dsc','currencyid','userid','amount');
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    //Declaramos e inicializamos nuestras variables
    $out = new stdClass();
    $sessionid = $_GET["sessionid"];
    $id = $_GET['id'];
    $date = $_GET['date'];
    $dsc = $_GET['dsc'];
    $currencyid = $_GET['currencyid'];
    $userid = $_GET['userid'];
    $amount = $_GET['amount'];
    
    //Validamos que la session del usuario sea valida para continuar
    isSessionValidCMS($db, $sessionid);
    
    //Si es 0 insertamos el ajuste, si no lo modificamos
    if($id == 0){
        
        //Validamos que el usuario tenga privilegios para crear
        if(!tienePrivilegio($db, $sessionid, 37))
            badEnd("403", array("msg"=>"No tiene Privilegios"));
        
        //Consultamos si el usuario posee una cuenta
        $sql = "SELECT COUNT(id) AS qty".
        "       FROM accounts ".
        "       WHERE userid = ".$userid.
        "       AND currencyid = ".$currencyid.
        "       AND paymentmethodid = -1";
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error.$sql));
        
        $row = $rs->fetch_assoc();
        
        //Si el usuario no posee cuenta en esa moneda se la creamos
        if($row['qty'] == 0){
            //Consultamos los datos de la moneda para validar que tipo es
            $sql = "SELECT * FROM currencies ".
            "       WHERE id = ".$currencyid;
            if (!$rs=$db->query($sql))
                badEnd("500", array("msg"=>$db->error));
        
            $currencydata = $rs->fetch_assoc();
        
            $isCripto = false;
            $isFiat = false;
            
            if($currencydata['interface'] == 1 || $currencydata['interface'] == 2 || $currencydata['interface'] == 3){
                $isFiat = true;
            }else if($currencydata['interface'] == 4 || $currencydata['interface'] == 5){
                $isCripto = true;
            }
        
            $db->autocommit(FALSE);
        
            if($isCripto && !$isFiat){
                $randomWallet = randomString(30);
        
                //Insertamos la nueva cuenta
                $sql = "INSERT INTO accounts".
                "       (".
                "       paymentmethodid, ".
                "       userid, ".
                "       currencyid, ".
                "       details1, ".
                "       status ".
                "       )".
                "       VALUES(".
                "       -1, ".
                "       ".$userid.", ".
                "       ".$currencyid["id"].", ".
                "       '".$randomWallet."', ".
                "       1 ".
                "       )";
                if (!$db->query($sql)){
                    $error = $db->error;
                    $db->rollback();
                    $db->close();
                    badEnd("500", array("msg"=>$error." 1 ".$sql));
                }
            
                // Retornamos el id que fue insertado
                $idcreated = (int)$db->insert_id;
        
                //Al ser una cripto, creamos una wallet
                $sql = "INSERT INTO wallets".
                "       (".
                "       wallet, ".
                "       secretKey, ".
                "       accountid, ".
                "       expirationDate".
                "       )".
                "       VALUES(".
                "       '".$randomWallet."', ".
                "       '".randomString(8)."', ".
                "       ".$idcreated.", ".
                "       DATE_ADD(NOW(), INTERVAL 1 YEAR)".
                "       )";
                if (!$db->query($sql)){
                    $error = $db->error;
                    $db->rollback();
                    $db->close();
                    badEnd("500", array("msg"=>$error."2"));
                }
        
            }else if($isFiat && !$isCripto){
                //Insertamos la nueva cuenta
                $sql = "INSERT INTO accounts".
                "       (".
                "       paymentmethodid, ".
                "       userid, ".
                "       currencyid, ".
                "       status".
                "       )".
                "       VALUES(".
                "       -1, ".
                "       ".$userid.", ".
                "       ".$currencyid["id"].", ".
                "       1".
                "       )";
                if (!$db->query($sql)){
                    $error = $db->error;
                    $db->rollback();
                    $db->close();
                    badEnd("500", array("msg"=>$error."3"));
                }
            }else{
                $db->rollback();
                $db->close();
                badEnd("500", array("msg"=>"No se logro determinar el tipo de moneda, avise para verificar el arreglo de monedas"));
            }
        
            $db->commit();
            $db->autocommit(TRUE);
        }
        
        $sql = "SELECT id ".
        "       FROM accounts ".
        "       WHERE userid = ".$userid.
        "       AND currencyid = ".$currencyid.
        "       AND paymentmethodid = -1";
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error.$sql));
        
        $row = $rs->fetch_assoc();
        
        $sql = "INSERT INTO transactions (".
        "       datecreated, ".
        "       dsc, ".
        "       amount, ".
        "       amountghost, ".
        "       accountid, ".
        "       accountdestination ".
        "       ) VALUES (".
        "       '".$date."', ".
        "       '".$dsc."', ".
        "       ".$amount.", ".
        "       0, ".
        "       ".$row['id'].", ".
        "       ".$row['id'].
        "       )";
        if (!$db->query($sql))
            badEnd("500", array("msg"=>$db->error.$sql));
        
        // Retornamos el id que fue insertado
        $out->id = (int)$db->insert_id;
        
        //Le colocamos a la primera transferencia el txid
        $sql = "UPDATE transactions SET".
        "       txid = ".$out->id.
        "       WHERE id = ".$out->id;
        if (!$db->query($sql))
            badEnd("500", array("msg"=>$db->error.$sql));
        
        //auditoria
        setAudit($db, "TRANSACCIONES", $sessionid, "CMS", "Se incluyo el ajuste ".$out->id);
    }else{
        
        //Validamos que el usuario tenga privilegios para actualizar
        if(!tienePrivilegio($db, $sessionid, 38))
            badEnd("403", array("msg"=>"No tiene Privilegios"));
            
        //Consultamos para verificar que existe el ajuste
        $sql = "SELECT COUNT(id) AS qty ".
        "       FROM transactions ".
        "       WHERE txid = ".$id;
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error.$sql));
            
        $row = $rs->fetch_assoc();
        
        // Si es 0 no existe el registro
        if($row['qty'] == 0){
            badEnd("204", array("msg"=>"No se encuentra el registro"));
        }
        
        //Consultamos si el usuario posee una cuenta
        $sql = "SELECT COUNT(id) AS qty".
        "       FROM accounts ".
        "       WHERE userid = ".$userid.
        "       AND currencyid = ".$currencyid.
        "       AND paymentmethodid = -1";
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error.$sql));
        
        $row = $rs->fetch_assoc();
        
        //Si el usuario no posee cuenta en esa moneda se la creamos
        if($row['qty'] == 0){
            //Consultamos los datos de la moneda para validar que tipo es
            $sql = "SELECT * FROM currencies ".
            "       WHERE id = ".$currencyid;
            if (!$rs=$db->query($sql))
                badEnd("500", array("msg"=>$db->error));
        
            $currencydata = $rs->fetch_assoc();
        
            $isCripto = false;
            $isFiat = false;
            
            if($currencydata['interface'] == 1 || $currencydata['interface'] == 2 || $currencydata['interface'] == 3){
                $isFiat = true;
            }else if($currencydata['interface'] == 4 || $currencydata['interface'] == 5){
                $isCripto = true;
            }
        
            $db->autocommit(FALSE);
        
            if($isCripto && !$isFiat){
                $randomWallet = randomString(30);
        
                //Insertamos la nueva cuenta
                $sql = "INSERT INTO accounts".
                "       (".
                "       paymentmethodid, ".
                "       userid, ".
                "       currencyid, ".
                "       details1, ".
                "       status ".
                "       )".
                "       VALUES(".
                "       -1, ".
                "       ".$userid.", ".
                "       ".$currencyid["id"].", ".
                "       '".$randomWallet."', ".
                "       1 ".
                "       )";
                if (!$db->query($sql)){
                    $error = $db->error;
                    $db->rollback();
                    $db->close();
                    badEnd("500", array("msg"=>$error." 1 ".$sql));
                }
            
                // Retornamos el id que fue insertado
                $idcreated = (int)$db->insert_id;
        
                //Al ser una cripto, creamos una wallet
                $sql = "INSERT INTO wallets".
                "       (".
                "       wallet, ".
                "       secretKey, ".
                "       accountid, ".
                "       expirationDate".
                "       )".
                "       VALUES(".
                "       '".$randomWallet."', ".
                "       '".randomString(8)."', ".
                "       ".$idcreated.", ".
                "       DATE_ADD(NOW(), INTERVAL 1 YEAR)".
                "       )";
                if (!$db->query($sql)){
                    $error = $db->error;
                    $db->rollback();
                    $db->close();
                    badEnd("500", array("msg"=>$error."2"));
                }
        
            }else if($isFiat && !$isCripto){
                //Insertamos la nueva cuenta
                $sql = "INSERT INTO accounts".
                "       (".
                "       paymentmethodid, ".
                "       userid, ".
                "       currencyid, ".
                "       status".
                "       )".
                "       VALUES(".
                "       -1, ".
                "       ".$userid.", ".
                "       ".$currencyid["id"].", ".
                "       1".
                "       )";
                if (!$db->query($sql)){
                    $error = $db->error;
                    $db->rollback();
                    $db->close();
                    badEnd("500", array("msg"=>$error."3"));
                }
            }else{
                $db->rollback();
                $db->close();
                badEnd("500", array("msg"=>"No se logro determinar el tipo de moneda, avise para verificar el arreglo de monedas"));
            }
        
            $db->commit();
            $db->autocommit(TRUE);
        }
        
        $sql = "SELECT id ".
        "       FROM accounts ".
        "       WHERE userid = ".$userid.
        "       AND currencyid = ".$currencyid.
        "       AND paymentmethodid = -1";
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error.$sql));
        
        $row = $rs->fetch_assoc();
        
        //actualizamos el registro
        $sql = "UPDATE transactions SET ".
        "       amount = ".$amount.", ".
        "       dsc = '".$dsc."', ".
        "       datecreated = '".$date."', ".
        "       accountid = ".$row['id'].", ".
        "       accountdestination = ".$row['id'].
        "       WHERE txid = ".$id;
        if (!$db->query($sql))
            badEnd("500", array("msg"=>$db->error.$sql));
        
        // Retornamos el id que fue insertado
        $out->id = (int)$db->insert_id;
        
        //Retornamos 304 si no se actualizo ningun registro
        if ($db->affected_rows == 0)
            badEnd("304", array("msg"=>"No se pudo modificar"));
    
        $out->id = (int)$id;
        
        //auditoria
        setAudit($db, "TRANSACCIONES", $sessionid, "CMS", "Se actualizo el ajuste ".$out->id);
    }
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>
